/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.biome.overworld;

import biomesoplenty.api.block.BOPBlocks;
import biomesoplenty.api.config.IBOPWorldSettings;
import biomesoplenty.api.enums.BOPClimates;
import biomesoplenty.api.generation.GeneratorStage;
import biomesoplenty.common.biome.overworld.BOPBiome;
import biomesoplenty.common.world.generator.GeneratorLakes;
import biomesoplenty.common.world.generator.GeneratorOreSingle;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;

public class BiomeGenAlps
extends BOPBiome {
    public BiomeGenAlps() {
        super("alps", new BOPBiome.PropsBuilder("Alps").withGuiColour(0xCCCCCC).withSnowEnabled().withTemperature(Float.valueOf(-0.5f)).withRainfall(Float.valueOf(0.3f)));
        this.terrainSettings.avgHeight(198.0).heightVariation(12.0, 12.0).octaves(1.0, 1.0, 2.0, 2.0, 3.0, 3.0);
        this.canGenerateRivers = false;
        this.canSpawnInBiome = false;
        this.canGenerateVillages = false;
        this.addWeight(BOPClimates.TUNDRA, 3);
        this.addWeight(BOPClimates.ICE_CAP, 5);
        this.field_76752_A = Blocks.field_150433_aE.func_176223_P();
        this.field_76753_B = Blocks.field_150433_aE.func_176223_P();
        this.avgDirtDepth = 8;
        this.field_76762_K.clear();
        this.addGenerator("hot_springs", GeneratorStage.SAND, ((GeneratorLakes.Builder)new GeneratorLakes.Builder().amountPerChunk(0.5f)).waterLakeForBiome(this).liquid(BOPBlocks.hot_spring_water).frozenLiquid((IBlockState)null).create());
        this.addGenerator("emeralds", GeneratorStage.SAND, ((GeneratorOreSingle.Builder)((GeneratorOreSingle.Builder)new GeneratorOreSingle.Builder().amountPerChunk(12.0f)).with(Blocks.field_150412_bA.func_176223_P())).create());
    }

    @Override
    public void applySettings(IBOPWorldSettings settings) {
        if (!settings.isEnabled(IBOPWorldSettings.GeneratorType.MUSHROOMS)) {
            this.removeGenerator("glowshrooms");
        }
        if (!settings.isEnabled(IBOPWorldSettings.GeneratorType.FLOWERS)) {
            this.removeGenerator("miners_delight");
        }
        if (!settings.isEnabled(IBOPWorldSettings.GeneratorType.ROCK_FORMATIONS)) {
            this.removeGenerator("stone_formations");
        }
        if (!settings.isEnabled(IBOPWorldSettings.GeneratorType.HOT_SPRINGS)) {
            this.removeGenerator("hot_springs");
        }
        if (!settings.isEnabled(IBOPWorldSettings.GeneratorType.FOLIAGE)) {
            this.removeGenerator("bushes");
            this.removeGenerator("koru");
            this.removeGenerator("shrubs");
            this.removeGenerator("leaf_piles");
            this.removeGenerator("dead_leaf_piles");
            this.removeGenerator("clover_patches");
            this.removeGenerator("sprouts");
        }
        if (!settings.isEnabled(IBOPWorldSettings.GeneratorType.PLANTS)) {
            this.removeGenerator("cattail");
            this.removeGenerator("double_cattail");
            this.removeGenerator("river_cane");
            this.removeGenerator("tiny_cacti");
            this.removeGenerator("roots");
            this.removeGenerator("rafflesia");
            this.removeGenerator("desert_sprouts");
        }
    }
}

