/*
 * Decompiled with CFR 0.152.
 */
package breakabletables.core;

import breakabletables.QuickRegister;
import breakabletables.blocks.BlockWorkbenchBreakable;
import breakabletables.blocks.TileEntityWorkbenchBreakable;
import breakabletables.core.proxies.CommonProxy;
import breakabletables.handlers.ConfigHandler;
import breakabletables.items.blocks.ItemBlockWorkbench;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.ShapedOreRecipe;
import org.apache.logging.log4j.Logger;

@Mod(modid="breakabletables", version="1.0.4", name="Breakable Tables", guiFactory="breakabletables.handlers.ConfigGuiFactory", acceptedMinecraftVersions="[1.10.2]")
public class BreakableTables {
    public static final String MODID = "breakabletables";
    public static final String VERSION = "1.0.4";
    public static final String NAME = "Breakable Tables";
    public static final String PROXY = "breakabletables.core.proxies";
    public static final String CHANNEL = "BT_CHAN";
    @Mod.Instance(value="breakabletables")
    public static BreakableTables instance;
    @SidedProxy(clientSide="breakabletables.core.proxies.ClientProxy", serverSide="breakabletables.core.proxies.CommonProxy")
    public static CommonProxy proxy;
    public SimpleNetworkWrapper network;
    public static Logger logger;
    public static Block basicWorkbench;
    public static Block goodWorkbench;
    public static Block greatWorkbench;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        logger = event.getModLog();
        this.network = NetworkRegistry.INSTANCE.newSimpleChannel(CHANNEL);
        ConfigHandler.config = new Configuration(event.getSuggestedConfigurationFile(), true);
        ConfigHandler.initConfigs();
        proxy.registerHandlers();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        GameRegistry.registerTileEntity(TileEntityWorkbenchBreakable.class, (String)"breakabletables_workbench");
        QuickRegister.registerBlock(basicWorkbench, (ItemBlock)new ItemBlockWorkbench(basicWorkbench), "workbench_basic");
        QuickRegister.registerBlock(goodWorkbench, (ItemBlock)new ItemBlockWorkbench(goodWorkbench), "workbench_good");
        QuickRegister.registerBlock(greatWorkbench, (ItemBlock)new ItemBlockWorkbench(greatWorkbench), "workbench_great");
        Blocks.field_150480_ab.func_180686_a(basicWorkbench, 5, 20);
        Blocks.field_150480_ab.func_180686_a(goodWorkbench, 5, 20);
        Blocks.field_150480_ab.func_180686_a(greatWorkbench, 5, 20);
        Blocks.field_150480_ab.func_180686_a(Blocks.field_150462_ai, 5, 20);
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(basicWorkbench), new Object[]{new String[]{"PP", "PP"}, Character.valueOf('P'), "plankWood"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(goodWorkbench), new Object[]{new String[]{"PPP", "PTP", "PPP"}, Character.valueOf('P'), "plankWood", Character.valueOf('T'), new ItemStack(basicWorkbench)}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(greatWorkbench), new Object[]{new String[]{"PPP", "PTP", "PPP"}, Character.valueOf('P'), "ingotIron", Character.valueOf('T'), new ItemStack(goodWorkbench)}));
        proxy.registerRenderers();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
    }

    static {
        basicWorkbench = new BlockWorkbenchBreakable(BlockWorkbenchBreakable.TableQuality.BASIC);
        goodWorkbench = new BlockWorkbenchBreakable(BlockWorkbenchBreakable.TableQuality.GOOD);
        greatWorkbench = new BlockWorkbenchBreakable(BlockWorkbenchBreakable.TableQuality.GREAT);
    }
}

