/*
 * Decompiled with CFR 0.152.
 */
package breakabletables.blocks;

import breakabletables.blocks.TileEntityWorkbenchBreakable;
import breakabletables.core.BT_Settings;
import breakabletables.core.BreakableTables;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class BlockWorkbenchBreakable
extends Block
implements ITileEntityProvider {
    public static final PropertyInteger DAMAGE = PropertyInteger.func_177719_a((String)"damage", (int)0, (int)2);
    private final TableQuality quality;

    public BlockWorkbenchBreakable(TableQuality q) {
        super(Material.field_151575_d);
        this.func_149711_c(2.5f);
        this.func_149672_a(SoundType.field_185848_a);
        this.func_149663_c("breakabletables.workbench_" + q.toString().toLowerCase());
        this.func_180632_j(this.func_176223_P().func_177226_a((IProperty)DAMAGE, (Comparable)Integer.valueOf(0)));
        this.func_149647_a(CreativeTabs.field_78031_c);
        this.quality = q;
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return super.func_180642_a(worldIn, pos, facing, hitX, hitY, hitZ, meta, placer).func_177226_a((IProperty)DAMAGE, (Comparable)Integer.valueOf(MathHelper.func_76125_a((int)meta, (int)0, (int)2)));
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof IInventory) {
            InventoryHelper.func_180175_a((World)worldIn, (BlockPos)pos, (IInventory)((IInventory)tileentity));
            worldIn.func_175666_e(pos, (Block)this);
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public int func_180651_a(IBlockState state) {
        return 0;
    }

    public int func_149745_a(Random rand) {
        return this.quality == TableQuality.BASIC ? 2 + rand.nextInt(1) : 1;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return this.quality == TableQuality.BASIC ? Items.field_151055_y : Item.func_150898_a((Block)BreakableTables.basicWorkbench);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)DAMAGE, (Comparable)Integer.valueOf(MathHelper.func_76125_a((int)meta, (int)0, (int)2)));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)DAMAGE);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{DAMAGE});
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, @Nullable ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!worldIn.field_72995_K) {
            playerIn.openGui((Object)BreakableTables.instance, 0, worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
        return true;
    }

    public float getDamageChance() {
        return BT_Settings.damageChance * this.quality.getDamageModifier();
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityWorkbenchBreakable();
    }

    public static enum TableQuality {
        BASIC(1.0f),
        GOOD(0.5f),
        GREAT(0.1f);

        float mod = 1.0f;

        private TableQuality(float mod) {
            this.mod = mod;
        }

        public float getDamageModifier() {
            return this.mod;
        }
    }
}

