/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.util;

import java.util.IllegalFormatException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;

public class Translator {
    private static Pattern pluralPattern = Pattern.compile("\\[\\[(.*)\\|\\|(.*)\\]\\]");

    public static String translate(String id) {
        return I18n.func_74838_a((String)id).replace("\\n", "\n");
    }

    public static String translate(String id, Object ... args) {
        return Translator.translate(false, id, args);
    }

    public static String translate(boolean plural, String id, Object ... args) {
        return Translator.format(Translator.translate(id), plural, args);
    }

    public static ITextComponent translateToIChatComponent(String id, Object ... args) {
        return Translator.translateToIChatComponent(TextFormatting.WHITE, id, args);
    }

    public static ITextComponent translateToIChatComponent(TextFormatting colour, String id, Object ... args) {
        return Translator.translateToIChatComponent(colour, false, id, args);
    }

    public static ITextComponent translateToIChatComponent(TextFormatting colour, boolean plural, String id, Object ... args) {
        TextComponentString iChatComponent = new TextComponentString(Translator.translate(plural, id, args));
        iChatComponent.func_150256_b().func_150238_a(colour);
        return iChatComponent;
    }

    public static String format(String s, boolean plural, Object ... args) {
        if (s == null) {
            return s;
        }
        try {
            Matcher matcher = pluralPattern.matcher(s);
            while (matcher.find()) {
                s = matcher.replaceFirst(matcher.group(plural ? 2 : 1));
                matcher = pluralPattern.matcher(s);
            }
            return String.format(s, args);
        }
        catch (IllegalFormatException e) {
            return "Format Exception: " + s;
        }
    }
}

