/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.util;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class OreDictionaryHelper {
    public static boolean match(ItemStack stack1, ItemStack stack2) {
        int[] ids1 = OreDictionary.getOreIDs((ItemStack)stack1);
        int[] ids2 = OreDictionary.getOreIDs((ItemStack)stack2);
        for (int id1 : ids1) {
            for (int id2 : ids2) {
                if (id1 != id2) continue;
                return true;
            }
        }
        return false;
    }

    public static List<ItemStack> getPermutationsList(ItemStack stack) {
        ArrayList<ItemStack> permutations = new ArrayList<ItemStack>();
        for (int id : OreDictionary.getOreIDs((ItemStack)stack)) {
            permutations.addAll(OreDictionaryHelper.getPermutationsList(OreDictionary.getOreName((int)id)));
        }
        if (permutations.size() == 0) {
            permutations.add(stack);
        }
        return OreDictionaryHelper.stripWildcardDamage(permutations);
    }

    public static ItemStack[] getPermutations(ItemStack stack) {
        List<ItemStack> permutations = OreDictionaryHelper.getPermutationsList(stack);
        return permutations.toArray(new ItemStack[permutations.size()]);
    }

    public static List<ItemStack> getPermutationsList(String oreName) {
        return OreDictionaryHelper.stripWildcardDamage(OreDictionary.getOres((String)oreName));
    }

    public static ItemStack[] getPermutations(String oreName) {
        List<ItemStack> permutations = OreDictionaryHelper.getPermutationsList(oreName);
        return permutations.toArray(new ItemStack[permutations.size()]);
    }

    public static String[] getOreNames(ItemStack stack) {
        ArrayList<String> names = new ArrayList<String>();
        for (int id : OreDictionary.getOreIDs((ItemStack)stack)) {
            names.add(OreDictionary.getOreName((int)id));
        }
        return names.toArray(new String[names.size()]);
    }

    private static List<ItemStack> stripWildcardDamage(List<ItemStack> list) {
        ArrayList<ItemStack> result = new ArrayList<ItemStack>(list.size());
        for (ItemStack stack : list) {
            result.add(new ItemStack(stack.func_77973_b(), stack.field_77994_a, stack.func_77952_i() == Short.MAX_VALUE ? 0 : stack.func_77952_i()));
        }
        return result;
    }
}

