/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.util;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonWriter;
import hardcorequesting.commands.CommandHandler;
import hardcorequesting.network.NetworkManager;
import hardcorequesting.network.message.OpActionMessage;
import hardcorequesting.quests.Quest;
import hardcorequesting.quests.QuestingData;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public final class OPBookHelper {
    private OPBookHelper() {
    }

    public static void reverseQuestCompletion(Quest quest, EntityPlayer subject) {
        NetworkManager.sendToServer(OpAction.QUEST_COMPLETION.build(quest, subject));
    }

    public static void reset(EntityPlayer player) {
        NetworkManager.sendToServer(OpAction.RESET.build(null, player));
    }

    public static enum OpAction {
        RESET{

            @Override
            public void process(String data) {
                this.fromJson(data);
                QuestingData.getQuestingData(this.subject).getTeam().clearProgress();
            }
        }
        ,
        QUEST_COMPLETION{

            @Override
            public void process(String data) {
                this.fromJson(data);
                if (this.quest != null) {
                    if (this.quest.isCompleted(this.subject)) {
                        QuestingData.getQuestingData(this.subject).getTeam().resetProgress(this.quest);
                    } else {
                        this.quest.completeQuest(this.subject);
                    }
                    this.quest.sendUpdatedDataToTeam(this.subject);
                }
            }
        };

        private static final String QUEST = "quest";
        private static final String SUBJECT = "subject";
        protected Quest quest;
        protected EntityPlayer subject;

        private static String toJson(Quest quest, EntityPlayer subject) {
            StringWriter stringWriter = new StringWriter();
            try {
                JsonWriter writer = new JsonWriter((Writer)stringWriter);
                writer.beginObject();
                if (quest != null) {
                    writer.name(QUEST).value(quest.getId());
                }
                if (subject != null) {
                    writer.name(SUBJECT).value(subject.getPersistentID().toString());
                }
                writer.endObject();
                writer.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return stringWriter.toString();
        }

        public abstract void process(String var1);

        public IMessage build(Quest quest, EntityPlayer subject) {
            return new OpActionMessage(this, OpAction.toJson(quest, subject));
        }

        public void process(EntityPlayer player, String data) {
            if (CommandHandler.isOwnerOrOp((ICommandSender)player)) {
                this.process(data);
            }
        }

        protected void fromJson(String data) {
            JsonParser parser = new JsonParser();
            JsonObject root = parser.parse(data).getAsJsonObject();
            if (root.has(QUEST)) {
                this.quest = Quest.getQuest(root.get(QUEST).getAsString());
            }
            if (root.has(SUBJECT)) {
                this.subject = QuestingData.getPlayer(root.get(SUBJECT).getAsString());
            }
        }
    }
}

