/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.tileentity;

import hardcorequesting.blocks.ModBlocks;
import hardcorequesting.client.ClientChange;
import hardcorequesting.client.interfaces.GuiBase;
import hardcorequesting.client.interfaces.GuiType;
import hardcorequesting.client.interfaces.GuiWrapperEditMenu;
import hardcorequesting.client.interfaces.edit.GuiEditMenuTracker;
import hardcorequesting.network.NetworkManager;
import hardcorequesting.quests.Quest;
import hardcorequesting.tileentity.TrackerType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityTracker
extends TileEntity
implements ITickable {
    private static final String NBT_QUEST = "Quest";
    private static final String NBT_RADIUS = "Radius";
    private static final String NBT_TYPE = "TrackerType";
    private Quest quest;
    private String questId;
    private int radius;
    private TrackerType type = TrackerType.TEAM;
    private int delay = 0;

    private static TileEntityTracker getTracker(World world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        return te instanceof TileEntityTracker ? (TileEntityTracker)te : null;
    }

    @SideOnly(value=Side.CLIENT)
    public static void openInterface(EntityPlayer player, BlockPos pos, String questId, int radius, TrackerType type) {
        TileEntityTracker tracker = TileEntityTracker.getTracker(player.field_70170_p, pos);
        if (tracker != null) {
            tracker.questId = questId;
            tracker.quest = null;
            tracker.radius = radius;
            tracker.type = type;
            GuiWrapperEditMenu gui = new GuiWrapperEditMenu();
            ((GuiBase)gui).setEditMenu(new GuiEditMenuTracker((GuiBase)gui, player, tracker));
            Minecraft.func_71410_x().func_147108_a((GuiScreen)gui);
        }
    }

    public static void saveToServer(EntityPlayer player, BlockPos pos, int radius, TrackerType type) {
        TileEntityTracker tracker = TileEntityTracker.getTracker(player.field_70170_p, pos);
        if (Quest.isEditing && tracker != null) {
            tracker.radius = radius;
            tracker.type = type;
        }
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        if (compound.func_74764_b(NBT_QUEST)) {
            this.questId = compound.func_74779_i(NBT_QUEST);
        } else {
            this.quest = null;
        }
        this.radius = compound.func_74762_e(NBT_RADIUS);
        this.type = TrackerType.values()[compound.func_74771_c(NBT_TYPE)];
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        if (this.quest != null) {
            compound.func_74778_a(NBT_QUEST, this.quest.getId());
        }
        compound.func_74768_a(NBT_RADIUS, this.radius);
        compound.func_74774_a(NBT_TYPE, (byte)this.type.ordinal());
        return compound;
    }

    public void func_73660_a() {
        if (this.quest == null && this.questId != null) {
            this.quest = Quest.getQuest(this.questId);
            this.questId = null;
        }
        if (!this.field_145850_b.field_72995_K && this.delay++ == 20) {
            if (this.quest != null && Quest.getQuest(this.quest.getId()) == null) {
                this.quest = null;
            }
            int oldMeta = this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c().func_176201_c(ModBlocks.itemTracker.func_176223_P());
            int meta = 0;
            if (this.quest != null) {
                meta = this.type.getMeta(this, this.quest, this.radius);
            }
            if (oldMeta != meta) {
                this.field_145850_b.func_180501_a(this.field_174879_c, ModBlocks.itemTracker.func_176223_P(), 3);
                this.notifyUpdate(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), 2);
            }
            this.delay = 0;
        }
    }

    private void notifyUpdate(int x, int y, int z, int i) {
        if (i == 2 || x != this.field_174879_c.func_177958_n() || y != this.field_174879_c.func_177956_o() || z != this.field_174879_c.func_177952_p()) {
            this.field_145850_b.func_175685_c(this.field_174879_c, this.func_145838_q());
            if (i > 0) {
                this.notifyUpdate(x - 1, y, z, i - 1);
                this.notifyUpdate(x + 1, y, z, i - 1);
                this.notifyUpdate(x, y - 1, z, i - 1);
                this.notifyUpdate(x, y + 1, z, i - 1);
                this.notifyUpdate(x, y, z - 1, i - 1);
                this.notifyUpdate(x, y, z + 1, i - 1);
            }
        }
    }

    public int getRadius() {
        return this.radius;
    }

    public void setRadius(int radius) {
        this.radius = radius;
    }

    public TrackerType getType() {
        return this.type;
    }

    public void setType(TrackerType type) {
        this.type = type;
    }

    public void setCurrentQuest() {
        this.quest = Quest.getQuest(Quest.selectedQuestId);
    }

    public Quest getCurrentQuest() {
        return this.quest;
    }

    public void openInterface(EntityPlayer player) {
        if (player instanceof EntityPlayerMP) {
            NetworkManager.sendToPlayer(GuiType.TRACKER.build(this.build()), (EntityPlayerMP)player);
        }
    }

    private String[] build() {
        String[] data = new String[]{"" + this.field_174879_c.func_177986_g(), this.quest != null ? this.quest.getId() : null, "" + this.radius, "" + this.type.ordinal()};
        return data;
    }

    public void sendToServer() {
        NetworkManager.sendToServer(ClientChange.TRACKER_UPDATE.build((Object)this));
    }
}

