/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.tileentity;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonWriter;
import hardcorequesting.client.interfaces.GuiBase;
import hardcorequesting.client.interfaces.GuiWrapperEditMenu;
import hardcorequesting.client.interfaces.edit.GuiEditMenuPortal;
import hardcorequesting.network.NetworkManager;
import hardcorequesting.quests.Quest;
import hardcorequesting.quests.QuestingData;
import hardcorequesting.team.PlayerEntry;
import hardcorequesting.team.Team;
import hardcorequesting.tileentity.IBlockSync;
import hardcorequesting.tileentity.PortalType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityPortal
extends TileEntity
implements IBlockSync,
ITickable {
    public static final String NBT_QUEST = "Quest";
    public static final String NBT_TYPE = "PortalType";
    public static final String NBT_ID = "ItemId";
    public static final String NBT_DMG = "ItemDmg";
    public static final String NBT_COLLISION = "Collision";
    public static final String NBT_TEXTURES = "Textures";
    public static final String NBT_NOT_COLLISION = "NotCollision";
    public static final String NBT_NOT_TEXTURES = "NotTextures";
    private static final String QUEST = "quest";
    private static final String PORTAL_TYPE = "portalType";
    private static final String HAS_ITEM = "hasItem";
    private static final String ITEM = "fluidStack";
    private static final String ITEM_DAMAGE = "itemDamage";
    private static final String COMPLETED_COLLISION = "completedCollision";
    private static final String COMPLETED_TEXTURE = "completedTexture";
    private static final String UNCOMPLETED_COLLISION = "uncompletedCollision";
    private static final String UNCOMPLETED_TEXTURE = "uncompletedTexture";
    private static final String PLAYERS = "players";
    private Quest quest;
    private String questId;
    private List<String> players = new ArrayList<String>();
    private PortalType type = PortalType.TECH;
    private ItemStack stack;
    private boolean completedTexture;
    private boolean uncompletedTexture = true;
    private boolean completedCollision;
    private boolean uncompletedCollision = true;
    private int delay = 20;
    private int resetDelay = 0;
    private boolean hasUpdatedData = false;

    public boolean isCompletedTexture() {
        return this.completedTexture;
    }

    public void setCompletedTexture(boolean completedTexture) {
        this.completedTexture = completedTexture;
    }

    public boolean isUncompletedTexture() {
        return this.uncompletedTexture;
    }

    public void setUncompletedTexture(boolean uncompletedTexture) {
        this.uncompletedTexture = uncompletedTexture;
    }

    public boolean isCompletedCollision() {
        return this.completedCollision;
    }

    public void setCompletedCollision(boolean completedCollision) {
        this.completedCollision = completedCollision;
    }

    public boolean isUncompletedCollision() {
        return this.uncompletedCollision;
    }

    public void setUncompletedCollision(boolean uncompletedCollision) {
        this.uncompletedCollision = uncompletedCollision;
    }

    public PortalType getType() {
        return this.type;
    }

    public void setType(PortalType type) {
        this.type = type;
    }

    public void writeContentToNBT(NBTTagCompound compound) {
        if (this.quest != null) {
            compound.func_74778_a(NBT_QUEST, this.quest.getId());
        }
        compound.func_74774_a(NBT_TYPE, (byte)this.type.ordinal());
        if (this.stack != null) {
            compound.func_74777_a(NBT_ID, (short)Item.func_150891_b((Item)this.stack.func_77973_b()));
            compound.func_74777_a(NBT_DMG, (short)this.stack.func_77952_i());
        }
        compound.func_74757_a(NBT_COLLISION, this.completedCollision);
        compound.func_74757_a(NBT_TEXTURES, this.completedTexture);
        compound.func_74757_a(NBT_NOT_COLLISION, this.uncompletedCollision);
        compound.func_74757_a(NBT_NOT_TEXTURES, this.uncompletedTexture);
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.readContentFromNBT(compound);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        this.writeContentToNBT(compound);
        return compound;
    }

    public void readContentFromNBT(NBTTagCompound compound) {
        if (compound.func_74764_b(NBT_QUEST)) {
            this.questId = compound.func_74779_i(NBT_QUEST);
            if (Quest.getQuests() != null) {
                this.quest = Quest.getQuest(this.questId);
            }
        } else {
            this.quest = null;
        }
        this.type = PortalType.values()[compound.func_74771_c(NBT_TYPE)];
        if (compound.func_74764_b(NBT_ID)) {
            short id = compound.func_74765_d(NBT_ID);
            short dmg = compound.func_74765_d(NBT_DMG);
            this.stack = new ItemStack(Item.func_150899_d((int)id), 1, (int)dmg);
        } else {
            this.stack = null;
        }
        if (compound.func_74764_b(NBT_COLLISION)) {
            this.completedCollision = compound.func_74767_n(NBT_COLLISION);
            this.completedTexture = compound.func_74767_n(NBT_COLLISION);
            this.uncompletedCollision = compound.func_74767_n(NBT_NOT_COLLISION);
            this.uncompletedTexture = compound.func_74767_n(NBT_NOT_TEXTURES);
        } else {
            this.completedTexture = false;
            this.completedCollision = false;
            this.uncompletedTexture = true;
            this.uncompletedCollision = true;
        }
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.quest == null && this.questId != null) {
                this.quest = Quest.getQuest(this.questId);
                this.questId = null;
            }
            boolean updated = false;
            if (this.delay++ >= 20) {
                if (this.quest != null && Quest.getQuest(this.quest.getId()) == null) {
                    this.quest = null;
                }
                if (this.quest != null) {
                    for (Team team : QuestingData.getAllTeams()) {
                        if (!team.getQuestData((String)this.quest.getId()).completed) continue;
                        for (PlayerEntry entry : team.getPlayers()) {
                            if (!entry.isInTeam() || this.players.contains(entry.getUUID())) continue;
                            this.players.add(entry.getUUID());
                            updated = true;
                        }
                    }
                }
                this.delay = 0;
            }
            if (this.resetDelay++ >= 1200) {
                if (this.quest != null && Quest.getQuest(this.quest.getId()) == null) {
                    this.quest = null;
                }
                if (this.quest != null) {
                    Iterator<String> iterator = this.players.iterator();
                    while (iterator.hasNext()) {
                        String player = iterator.next();
                        if (QuestingData.hasData(player) && this.quest.isCompleted(player)) continue;
                        iterator.remove();
                        updated = true;
                    }
                } else if (this.players.size() > 0) {
                    this.players.clear();
                    updated = true;
                }
                this.resetDelay = 0;
            }
            if (updated) {
                NetworkManager.sendBlockUpdate(this, null, 0);
            }
        } else {
            this.keepClientDataUpdated();
        }
    }

    public boolean hasTexture(EntityPlayer player) {
        return this.players.contains(player.func_146103_bH().getName()) ? this.completedTexture : this.uncompletedTexture;
    }

    public boolean hasCollision(EntityPlayer player) {
        return this.players.contains(player.func_146103_bH().getName()) ? this.completedCollision : this.uncompletedCollision;
    }

    public void setCurrentQuest() {
        this.quest = Quest.getQuest(Quest.selectedQuestId);
        this.delay = 1200;
        this.resetDelay = 1200;
        NetworkManager.sendBlockUpdate(this, null, 0);
    }

    public Quest getCurrentQuest() {
        return this.quest;
    }

    @SideOnly(value=Side.CLIENT)
    private void keepClientDataUpdated() {
        double distance = Minecraft.func_71410_x().field_71439_g.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5);
        if (distance > Math.pow(128.0, 2.0)) {
            this.hasUpdatedData = false;
        } else if (!this.hasUpdatedData && distance < Math.pow(123.0, 2.0)) {
            this.hasUpdatedData = true;
            NetworkManager.sendBlockUpdate(this, (EntityPlayer)Minecraft.func_71410_x().field_71439_g, 0);
        }
    }

    @Override
    public void writeData(EntityPlayer player, boolean onServer, int type, JsonWriter writer) throws IOException {
        switch (type) {
            case 0: {
                if (!onServer) break;
                writer.name(QUEST).value(this.quest == null ? null : this.quest.getId());
                writer.name(PORTAL_TYPE).value((long)this.type.ordinal());
                if (!this.type.isPreset()) {
                    writer.name(HAS_ITEM).value(this.stack != null);
                    if (this.stack != null) {
                        writer.name(ITEM).value(this.stack.func_77973_b().getRegistryName().toString());
                        writer.name(ITEM_DAMAGE).value((long)this.stack.func_77952_i());
                    }
                }
                writer.name(COMPLETED_COLLISION).value(this.completedCollision);
                writer.name(COMPLETED_TEXTURE).value(this.completedTexture);
                writer.name(UNCOMPLETED_COLLISION).value(this.uncompletedCollision);
                writer.name(UNCOMPLETED_TEXTURE).value(this.uncompletedTexture);
                writer.name(PLAYERS).beginArray();
                for (String p : this.players) {
                    writer.value(p);
                }
                writer.endArray();
                break;
            }
            case 1: {
                if (onServer) break;
                writer.name(PORTAL_TYPE).value((long)this.type.ordinal());
                if (!this.type.isPreset()) {
                    writer.name(HAS_ITEM).value(this.stack != null);
                    if (this.stack != null) {
                        writer.name(ITEM).value(this.stack.func_77973_b().getRegistryName().toString());
                        writer.name(ITEM_DAMAGE).value((long)this.stack.func_77952_i());
                    }
                }
                writer.name(COMPLETED_COLLISION).value(this.completedCollision);
                writer.name(COMPLETED_TEXTURE).value(this.completedTexture);
                writer.name(UNCOMPLETED_COLLISION).value(this.uncompletedCollision);
                writer.name(UNCOMPLETED_TEXTURE).value(this.uncompletedTexture);
            }
        }
    }

    @Override
    public void readData(EntityPlayer player, boolean onServer, int type, JsonObject data) {
        switch (type) {
            case 0: {
                if (onServer) {
                    NetworkManager.sendBlockUpdate(this, player, 0);
                    break;
                }
                JsonElement questElement = data.get(QUEST);
                this.quest = questElement.isJsonNull() ? null : Quest.getQuest(questElement.getAsString());
                this.type = PortalType.values()[data.get(PORTAL_TYPE).getAsInt()];
                if (!this.type.isPreset()) {
                    if (data.get(HAS_ITEM).getAsBoolean()) {
                        String itemId = data.get(ITEM).getAsString();
                        int dmg = data.get(ITEM_DAMAGE).getAsInt();
                        this.stack = new ItemStack((Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(itemId)), 1, dmg);
                    } else {
                        this.stack = null;
                    }
                }
                this.completedCollision = data.get(COMPLETED_COLLISION).getAsBoolean();
                this.completedTexture = data.get(COMPLETED_TEXTURE).getAsBoolean();
                this.uncompletedCollision = data.get(UNCOMPLETED_COLLISION).getAsBoolean();
                this.uncompletedTexture = data.get(UNCOMPLETED_TEXTURE).getAsBoolean();
                this.players.clear();
                for (JsonElement p : data.get(PLAYERS).getAsJsonArray()) {
                    this.players.add(p.getAsString());
                }
                IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
                this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
                break;
            }
            case 1: {
                if (onServer) {
                    if (!Quest.isEditing) break;
                    this.type = PortalType.values()[data.get(PORTAL_TYPE).getAsInt()];
                    if (!this.type.isPreset()) {
                        if (data.get(HAS_ITEM).getAsBoolean()) {
                            String itemId = data.get(ITEM).getAsString();
                            int dmg = data.get(ITEM_DAMAGE).getAsInt();
                            this.stack = new ItemStack((Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(itemId)), 1, dmg);
                        } else {
                            this.stack = null;
                        }
                    }
                    this.completedCollision = data.get(COMPLETED_COLLISION).getAsBoolean();
                    this.completedTexture = data.get(COMPLETED_TEXTURE).getAsBoolean();
                    this.uncompletedCollision = data.get(UNCOMPLETED_COLLISION).getAsBoolean();
                    this.uncompletedTexture = data.get(UNCOMPLETED_TEXTURE).getAsBoolean();
                    NetworkManager.sendBlockUpdate(this, null, 0);
                    break;
                }
                this.openInterfaceClient(player);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void openInterfaceClient(EntityPlayer player) {
        GuiWrapperEditMenu gui = new GuiWrapperEditMenu();
        ((GuiBase)gui).setEditMenu(new GuiEditMenuPortal((GuiBase)gui, player, this));
        Minecraft.func_71410_x().func_147108_a((GuiScreen)gui);
    }

    public void openInterface(EntityPlayer player) {
        NetworkManager.sendBlockUpdate(this, player, 1);
    }

    @SideOnly(value=Side.CLIENT)
    public void sendToServer() {
        NetworkManager.sendBlockUpdate(this, (EntityPlayer)Minecraft.func_71410_x().field_71439_g, 1);
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public void setStack(ItemStack stack) {
        this.stack = stack;
    }

    public TileEntityPortal copy() {
        TileEntityPortal portal = new TileEntityPortal();
        NBTTagCompound compound = new NBTTagCompound();
        this.func_189515_b(compound);
        portal.func_145839_a(compound);
        portal.field_145850_b = this.field_145850_b;
        return portal;
    }
}

