/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.tileentity;

import hardcorequesting.blocks.BlockDelivery;
import hardcorequesting.blocks.ModBlocks;
import hardcorequesting.quests.Quest;
import hardcorequesting.quests.QuestingData;
import hardcorequesting.quests.data.QuestDataTaskItems;
import hardcorequesting.quests.task.QuestTask;
import hardcorequesting.quests.task.QuestTaskItemsConsume;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class TileEntityBarrel
extends TileEntity
implements IInventory,
IFluidHandler,
ITickable {
    private static final int SYNC_TIME = 20;
    private static final String NBT_PLAYER_NAME = "Player";
    private static final String NBT_QUEST = "Quest";
    private static final String NBT_TASK = "Task";
    public String selectedQuest;
    public int selectedTask;
    private int modifiedSyncTimer;
    private String playerUuid;

    public int func_70302_i_() {
        return 1;
    }

    public ItemStack func_70301_a(int i) {
        return null;
    }

    public ItemStack func_70298_a(int i, int j) {
        return null;
    }

    public ItemStack func_70304_b(int index) {
        return null;
    }

    public void func_70299_a(int i, ItemStack stack) {
        QuestTask task = this.getCurrentTask();
        if (task != null && task instanceof QuestTaskItemsConsume && ((QuestTaskItemsConsume)task).increaseItems(new ItemStack[]{stack}, (QuestDataTaskItems)task.getData(this.playerUuid), this.playerUuid) && this.modifiedSyncTimer <= 0) {
            this.modifiedSyncTimer = 20;
        }
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return true;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int i, ItemStack stack) {
        return true;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
    }

    public void func_73660_a() {
        if (this.modifiedSyncTimer > 0 && --this.modifiedSyncTimer == 0) {
            this.doSync();
            this.updateState();
        }
    }

    private void doSync() {
        EntityPlayer player;
        QuestTask task;
        if (!this.field_145850_b.field_72995_K && (task = this.getCurrentTask()) != null && (player = QuestingData.getPlayerFromUsername(this.playerUuid)) != null) {
            task.getParent().sendUpdatedDataToTeam(player);
        }
    }

    private void updateState() {
        EntityPlayer player;
        QuestTask task;
        if (!this.field_145850_b.field_72995_K && (task = this.getCurrentTask()) != null && (player = QuestingData.getPlayer(this.playerUuid)) != null) {
            if (task.isCompleted(player)) {
                this.field_145850_b.func_180501_a(this.field_174879_c, ModBlocks.itemBarrel.func_176223_P(), 3);
            } else if (!((Boolean)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockDelivery.BOUND)).booleanValue()) {
                this.field_145850_b.func_180501_a(this.field_174879_c, ModBlocks.itemBarrel.func_176223_P().func_177226_a((IProperty)BlockDelivery.BOUND, (Comparable)Boolean.valueOf(true)), 3);
            }
        }
    }

    public QuestTask getCurrentTask() {
        Quest quest;
        if (this.playerUuid != null && this.selectedQuest != null && (quest = Quest.getQuest(this.selectedQuest)) != null && this.selectedTask >= 0 && this.selectedTask < quest.getTasks().size()) {
            return quest.getTasks().get(this.selectedTask);
        }
        return null;
    }

    public String func_70005_c_() {
        return null;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public void storeSettings(EntityPlayer player) {
        if (this.modifiedSyncTimer > 0) {
            this.modifiedSyncTimer = 0;
            this.doSync();
        }
        this.playerUuid = QuestingData.getUserUUID(player);
        QuestingData data = QuestingData.getQuestingData(player);
        this.selectedQuest = data.selectedQuest;
        this.selectedTask = data.selectedTask;
        this.updateState();
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        if (compound.func_74764_b(NBT_PLAYER_NAME)) {
            this.playerUuid = compound.func_74779_i(NBT_PLAYER_NAME);
            this.selectedQuest = compound.func_74779_i(NBT_QUEST);
            this.selectedTask = compound.func_74771_c(NBT_TASK);
        } else {
            this.playerUuid = null;
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        if (this.playerUuid != null) {
            compound.func_74778_a(NBT_PLAYER_NAME, this.playerUuid);
            compound.func_74778_a(NBT_QUEST, this.selectedQuest);
            compound.func_74774_a(NBT_TASK, (byte)this.selectedTask);
        }
        return compound;
    }

    public ITextComponent func_145748_c_() {
        return null;
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return this.getCapability(capability, facing) != null;
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)((Object)this);
        }
        return (T)super.getCapability(capability, facing);
    }

    public String getPlayer() {
        return this.playerUuid;
    }

    public IFluidTankProperties[] getTankProperties() {
        return new IFluidTankProperties[0];
    }

    public int fill(FluidStack resource, boolean doFill) {
        QuestTask task;
        if (resource == null) {
            return 0;
        }
        if (doFill && (task = this.getCurrentTask()) != null && task instanceof QuestTaskItemsConsume && ((QuestTaskItemsConsume)task).increaseFluid(resource.copy(), (QuestDataTaskItems)task.getData(this.playerUuid), this.playerUuid) && this.modifiedSyncTimer <= 0) {
            this.modifiedSyncTimer = 20;
        }
        return resource.amount;
    }

    @Nullable
    public FluidStack drain(FluidStack resource, boolean doDrain) {
        return null;
    }

    @Nullable
    public FluidStack drain(int maxDrain, boolean doDrain) {
        return null;
    }
}

