/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.team;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonWriter;
import hardcorequesting.io.adapter.TeamAdapter;
import hardcorequesting.network.message.TeamUpdateMessage;
import hardcorequesting.quests.Quest;
import hardcorequesting.quests.QuestData;
import hardcorequesting.quests.QuestingData;
import hardcorequesting.quests.reward.ReputationReward;
import hardcorequesting.reputation.Reputation;
import hardcorequesting.team.Team;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;

public enum TeamUpdateType {
    FULL{

        @Override
        public void update(Team team, String data) {
            try {
                team.update((Team)TeamAdapter.TEAM_ADAPTER.fromJson(data));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        @Override
        public TeamUpdateMessage build(Team team, Object ... data) {
            try {
                return new TeamUpdateMessage(this, TeamAdapter.TEAM_ADAPTER.toJson((Object)team));
            }
            catch (IOException iOException) {
                return null;
            }
        }
    }
    ,
    LIVES{

        @Override
        public void update(Team team, String data) {
            team.setClientTeamLives(Integer.parseInt(data));
        }

        @Override
        public TeamUpdateMessage build(Team team, Object ... data) {
            return new TeamUpdateMessage(this, "" + team.getSharedLives());
        }
    }
    ,
    REPUTATION_RECEIVED{
        private static final String QUEST = "quest";
        private static final String REPUTATIONS = "reputations";
        private static final String ID = "id";
        private static final String VAL = "val";

        @Override
        public void update(Team team, String data) {
            QuestData questData;
            JsonParser parser = new JsonParser();
            JsonObject object = parser.parse(data).getAsJsonObject();
            Quest quest = Quest.getQuest(object.get(QUEST).getAsString());
            if (quest != null && (questData = team.getQuestData(quest.getId())) != null) {
                questData.claimed = true;
                for (JsonElement element : object.get(REPUTATIONS).getAsJsonArray()) {
                    String id = element.getAsJsonObject().get(ID).getAsString();
                    int val = element.getAsJsonObject().get(VAL).getAsInt();
                    team.setReputation(id, (Integer)val);
                }
            }
        }

        @Override
        public TeamUpdateMessage build(Team team, Object ... data) {
            StringWriter out = new StringWriter();
            try {
                JsonWriter writer = new JsonWriter((Writer)out);
                writer.beginObject();
                writer.name(QUEST).value(((Quest)data[0]).getId());
                writer.name(REPUTATIONS).beginArray();
                for (ReputationReward reward : (List)data[1]) {
                    writer.beginObject();
                    writer.name(ID).value(((Reputation)reward.getReward()).getId());
                    writer.name(VAL).value((long)team.getReputation((Reputation)reward.getReward()));
                    writer.endObject();
                }
                writer.endArray();
                writer.endObject();
                writer.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return new TeamUpdateMessage(this, out.toString());
        }
    }
    ,
    CREATE_TEAM{

        @Override
        public void update(Team team, String data) {
            try {
                Team newTeam = (Team)TeamAdapter.TEAM_ADAPTER.fromJson(data);
                QuestingData.getTeams().add(newTeam);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        @Override
        public TeamUpdateMessage build(Team team, Object ... data) {
            try {
                return new TeamUpdateMessage(this, TeamAdapter.TEAM_ADAPTER.toJson((Object)team));
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }
    }
    ,
    JOIN_TEAM{

        @Override
        public void update(Team team, String data) {
            String uuid = data.substring(0, 36);
            String teamJson = data.substring(36);
            try {
                QuestingData.getQuestingData(uuid).setTeam((Team)TeamAdapter.TEAM_ADAPTER.fromJson(teamJson));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        @Override
        public TeamUpdateMessage build(Team team, Object ... data) {
            try {
                return new TeamUpdateMessage(this, data[0].toString() + TeamAdapter.TEAM_ADAPTER.toJson((Object)team));
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }
    }
    ,
    LEAVE_TEAM{

        @Override
        public void update(Team team, String data) {
            String uuid = data.substring(0, 36);
            String teamJson = data.substring(36);
            try {
                QuestingData.getQuestingData(uuid).setTeam((Team)TeamAdapter.TEAM_ADAPTER.fromJson(teamJson));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        @Override
        public TeamUpdateMessage build(Team team, Object ... data) {
            try {
                return new TeamUpdateMessage(this, data[0].toString() + TeamAdapter.TEAM_ADAPTER.toJson((Object)((Team)data[1])));
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }
    }
    ,
    REMOVE_TEAM{

        @Override
        public void update(Team clientTeam, String data) {
            int id = Integer.parseInt(data);
            List<Team> teams = QuestingData.getTeams();
            teams.remove(id);
            for (int i = id; i < teams.size(); ++i) {
                Team team = teams.get(i);
                team.setId(team.getId() - 1);
            }
        }

        @Override
        public TeamUpdateMessage build(Team team, Object ... data) {
            return new TeamUpdateMessage(this, "" + team.getId());
        }
    }
    ,
    INVITE{

        @Override
        public void update(Team clientTeam, String data) {
            try {
                Team team = (Team)TeamAdapter.TEAM_ADAPTER.fromJson(data);
                QuestingData.getTeams().set(team.getId(), team);
                clientTeam.getInvites().add(team);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        @Override
        public TeamUpdateMessage build(Team team, Object ... data) {
            try {
                return new TeamUpdateMessage(this, TeamAdapter.TEAM_ADAPTER.toJson((Object)team));
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }
    };


    public abstract void update(Team var1, String var2);

    public abstract TeamUpdateMessage build(Team var1, Object ... var2);
}

