/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.team;

import hardcorequesting.network.NetworkManager;
import hardcorequesting.network.message.TeamStatsMessage;
import hardcorequesting.team.Team;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TeamStats {
    private static Map<String, TeamStats> clientTeams;
    private static TeamStats[] clientTeamsList;
    private static TeamComparator teamComparator;
    private String name;
    private int players;
    private int lives;
    private float progress;

    public TeamStats(String name, int players, int lives, float progress) {
        this.name = name;
        this.players = players;
        this.lives = lives;
        this.progress = progress;
    }

    public static void refreshTeam(Team team) {
        NetworkManager.sendToAllPlayers(new TeamStatsMessage(team));
    }

    public static void updateTeams(List<TeamStats> stats) {
        clientTeams = new HashMap<String, TeamStats>();
        for (TeamStats stat : stats) {
            if (stat.getPlayers() <= 0) continue;
            clientTeams.put(stat.name, stat);
        }
        TeamStats.updateTeams();
    }

    public static void updateTeam(TeamStats stat) {
        if (clientTeams == null) {
            clientTeams = new HashMap<String, TeamStats>();
        }
        if (stat.getPlayers() > 0) {
            clientTeams.put(stat.name, stat);
        } else {
            clientTeams.remove(stat.name);
        }
        TeamStats.updateTeams();
    }

    private static void updateTeams() {
        clientTeamsList = new TeamStats[clientTeams.size()];
        int id = 0;
        for (TeamStats teamStats : clientTeams.values()) {
            TeamStats.clientTeamsList[id++] = teamStats;
        }
        Arrays.sort(clientTeamsList, teamComparator);
    }

    public static TeamStats[] getTeamStats() {
        return clientTeamsList;
    }

    public String getName() {
        return this.name;
    }

    public int getPlayers() {
        return this.players;
    }

    public int getLives() {
        return this.lives;
    }

    public float getProgress() {
        return this.progress;
    }

    static {
        teamComparator = new TeamComparator();
    }

    private static class TeamComparator
    implements Comparator<TeamStats> {
        private TeamComparator() {
        }

        @Override
        public int compare(TeamStats o1, TeamStats o2) {
            return Float.valueOf(o2.progress).compareTo(Float.valueOf(o1.progress));
        }
    }
}

