/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.team;

import hardcorequesting.network.NetworkManager;
import hardcorequesting.quests.Quest;
import hardcorequesting.quests.QuestData;
import hardcorequesting.quests.QuestingData;
import hardcorequesting.reputation.Reputation;
import hardcorequesting.team.LifeSetting;
import hardcorequesting.team.PlayerEntry;
import hardcorequesting.team.RewardSetting;
import hardcorequesting.team.Team;
import hardcorequesting.team.TeamError;
import hardcorequesting.team.TeamStats;
import hardcorequesting.team.TeamUpdateSize;
import hardcorequesting.team.TeamUpdateType;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.FMLCommonHandler;

public enum TeamAction {
    CREATE{

        @Override
        public void process(Team team, EntityPlayer player, String teamName) {
            if (team.isSingle()) {
                if (teamName.length() == 0) {
                    return;
                }
                for (Team t : QuestingData.getTeams()) {
                    if (!t.getName().equals(teamName)) continue;
                    TeamError.USED_NAME.sendToClient(player);
                    return;
                }
                QuestingData.addTeam(team);
                team.setName(teamName);
                team.refreshTeamData(TeamUpdateSize.ONLY_MEMBERS);
                Team.declineAll(QuestingData.getUserUUID(player));
                TeamStats.refreshTeam(team);
                NetworkManager.sendToAllPlayers(TeamUpdateType.CREATE_TEAM.build(team, new Object[0]));
                if (player instanceof EntityPlayerMP) {
                    NetworkManager.sendToPlayer(TeamUpdateType.JOIN_TEAM.build(team, player.func_110124_au().toString()), (EntityPlayerMP)player);
                }
            }
        }
    }
    ,
    INVITE{

        @Override
        public void process(Team team, EntityPlayer player, String playerName) {
            EntityPlayerMP invitee = FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_152612_a(playerName);
            if (!team.isSingle() && team.isOwner(player) && invitee != null) {
                PlayerEntry entry = new PlayerEntry(invitee.func_110124_au().toString(), false, false);
                if (!QuestingData.hasData(entry.getUUID())) {
                    TeamError.INVALID_PLAYER.sendToClient(player);
                    return;
                }
                if (!QuestingData.getQuestingData(entry.getUUID()).getTeam().isSingle()) {
                    TeamError.IN_PARTY.sendToClient(player);
                    return;
                }
                if (!team.getPlayers().contains(entry)) {
                    team.getPlayers().add(entry);
                    team.refreshTeamData(TeamUpdateSize.ONLY_MEMBERS);
                    QuestingData.getQuestingData(entry.getUUID()).getTeam().refreshTeamData(TeamUpdateSize.ONLY_MEMBERS);
                    QuestingData.getQuestingData(entry.getUUID()).getTeam().getInvites().add(team);
                    NetworkManager.sendToPlayer(TeamUpdateType.INVITE.build(team, new Object[0]), entry.getPlayerMP());
                }
            }
        }
    }
    ,
    ACCEPT{

        @Override
        public void process(Team team, EntityPlayer player, String data) {
            int acceptId;
            if (team.isSingle() && (acceptId = Integer.parseInt(data)) >= 0 && acceptId < QuestingData.getTeams().size()) {
                Team inviteTeam = QuestingData.getTeams().get(acceptId);
                int id = 0;
                for (PlayerEntry entry : inviteTeam.getPlayers()) {
                    QuestData questData;
                    QuestData joinData;
                    if (entry.isInTeam()) {
                        ++id;
                        continue;
                    }
                    if (!entry.getUUID().equals(QuestingData.getUserUUID(player))) continue;
                    entry.setBookOpen(true);
                    entry.setInTeam(true);
                    QuestingData.getQuestingData(entry.getUUID()).setTeam(inviteTeam);
                    for (String quest : inviteTeam.getQuestData().keySet()) {
                        joinData = team.getQuestData().get(quest);
                        questData = inviteTeam.getQuestData().get(quest);
                        if (questData == null) continue;
                        boolean[] old = questData.reward;
                        questData.reward = new boolean[old.length + 1];
                        for (int j = 0; j < questData.reward.length; ++j) {
                            questData.reward[j] = j == id ? joinData.reward[0] : (j < id ? old[j] : old[j - 1]);
                        }
                    }
                    for (String quest : inviteTeam.getQuestData().keySet()) {
                        joinData = team.getQuestData().get(quest);
                        questData = inviteTeam.getQuestData().get(quest);
                        if (questData == null || Quest.getQuest(quest) == null) continue;
                        Quest.getQuest(quest).mergeProgress(QuestingData.getUserUUID(player), questData, joinData);
                    }
                    for (Reputation reputation : Reputation.getReputations().values()) {
                        if (reputation == null) continue;
                        int joinValue = team.getReputation(reputation);
                        int teamValue = inviteTeam.getReputation(reputation);
                        int targetValue = Math.abs(joinValue) > Math.abs(teamValue) ? joinValue : teamValue;
                        inviteTeam.setReputation(reputation, targetValue);
                    }
                    inviteTeam.refreshData();
                    inviteTeam.refreshTeamData(TeamUpdateSize.ALL);
                    Team.declineAll(QuestingData.getUserUUID(player));
                    TeamStats.refreshTeam(inviteTeam);
                    NetworkManager.sendToPlayer(TeamUpdateType.JOIN_TEAM.build(inviteTeam, entry.getUUID()), entry.getPlayerMP());
                    break;
                }
            }
        }
    }
    ,
    DECLINE{

        @Override
        public void process(Team team, EntityPlayer player, String data) {
            int declineId;
            if (team.isSingle() && (declineId = Integer.parseInt(data)) >= 0 && declineId < QuestingData.getTeams().size()) {
                Team inviteTeam = QuestingData.getTeams().get(declineId);
                inviteTeam.getPlayers().remove(new PlayerEntry(QuestingData.getUserUUID(player), false, false));
                inviteTeam.refreshTeamData(TeamUpdateSize.ONLY_OWNER);
                team.refreshTeamData(TeamUpdateSize.ONLY_MEMBERS);
            }
        }
    }
    ,
    KICK{

        @Override
        public void process(Team team, EntityPlayer player, String toRemovePlayerUuid) {
            PlayerEntry entryToRemove;
            EntityPlayerMP playerToRemove = FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_177451_a(UUID.fromString(toRemovePlayerUuid));
            if (!team.isSingle() && team.isOwner(player) && playerToRemove != null && !(entryToRemove = team.getEntry(playerToRemove.func_110124_au().toString())).isOwner()) {
                if (entryToRemove.isInTeam()) {
                    team.removePlayer((EntityPlayer)playerToRemove);
                    team.refreshTeamData(TeamUpdateSize.ALL);
                    TeamStats.refreshTeam(team);
                } else {
                    team.getPlayers().remove(entryToRemove);
                    team.refreshTeamData(TeamUpdateSize.ONLY_OWNER);
                }
                QuestingData.getQuestingData((EntityPlayer)playerToRemove).getTeam().refreshTeamData(TeamUpdateSize.ONLY_MEMBERS);
            }
        }
    }
    ,
    LEAVE{

        @Override
        public void process(Team team, EntityPlayer player, String data) {
            if (!team.isSingle() && !team.isOwner(player)) {
                team.removePlayer(player);
                team.refreshTeamData(TeamUpdateSize.ALL);
                TeamAction.getTeam(player).refreshTeamData(TeamUpdateSize.ONLY_MEMBERS);
                TeamStats.refreshTeam(team);
            }
        }
    }
    ,
    DISBAND{

        @Override
        public void process(Team team, EntityPlayer player, String data) {
            if (!team.isSingle() && team.isOwner(player)) {
                team.deleteTeam();
                TeamStats.refreshTeam(team);
            }
        }
    }
    ,
    NEXT_LIFE_SETTING{

        @Override
        public void process(Team team, EntityPlayer player, String data) {
            if (!team.isSingle() && team.isOwner(player)) {
                team.setLifeSetting(LifeSetting.values()[(team.getLifeSetting().ordinal() + 1) % LifeSetting.values().length]);
                team.refreshTeamData(TeamUpdateSize.ALL);
            }
        }
    }
    ,
    NEXT_REWARD_SETTING{

        @Override
        public void process(Team team, EntityPlayer player, String data) {
            if (!team.isSingle() && team.isOwner(player)) {
                team.setRewardSetting(RewardSetting.values()[(team.getRewardSetting().ordinal() + 1) % RewardSetting.values().length]);
                if (team.getRewardSetting() == RewardSetting.ALL) {
                    team.setRewardSetting(RewardSetting.getDefault());
                }
                team.refreshTeamData(TeamUpdateSize.ALL);
            }
        }
    };


    private static Team getTeam(EntityPlayer player) {
        return QuestingData.getQuestingData(player).getTeam();
    }

    public void process(EntityPlayer player, String data) {
        this.process(TeamAction.getTeam(player), player, data);
    }

    public abstract void process(Team var1, EntityPlayer var2, String var3);
}

