/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.team;

import hardcorequesting.io.SaveHandler;
import hardcorequesting.io.adapter.TeamAdapter;
import hardcorequesting.network.NetworkManager;
import hardcorequesting.network.message.TeamMessage;
import hardcorequesting.quests.Quest;
import hardcorequesting.quests.QuestData;
import hardcorequesting.quests.QuestingData;
import hardcorequesting.quests.reward.ReputationReward;
import hardcorequesting.reputation.Reputation;
import hardcorequesting.team.LifeSetting;
import hardcorequesting.team.PlayerEntry;
import hardcorequesting.team.RewardSetting;
import hardcorequesting.team.TeamAction;
import hardcorequesting.team.TeamStats;
import hardcorequesting.team.TeamUpdateSize;
import hardcorequesting.team.TeamUpdateType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.FMLLog;
import org.apache.logging.log4j.Level;

public class Team {
    public static boolean reloadedInvites;
    private int id = -1;
    private List<PlayerEntry> players = new ArrayList<PlayerEntry>();
    private List<Team> invites;
    private String name;
    private Map<String, Integer> reputation;
    private Map<String, QuestData> questData;
    private int clientTeamLives = -1;
    private RewardSetting rewardSetting = RewardSetting.getDefault();
    private LifeSetting lifeSetting = LifeSetting.SHARE;

    public Team(String playerUuid) {
        if (playerUuid != null) {
            this.players.add(new PlayerEntry(playerUuid, true, true));
        }
        this.createQuestData();
        this.createReputation();
        this.invites = new ArrayList<Team>();
    }

    public static void loadAll(boolean isClient, boolean remote) {
        try {
            QuestingData.getTeams().clear();
            TeamAdapter.clearInvitesMap();
            List<Team> teams = SaveHandler.loadTeams(SaveHandler.getFile("teams", remote));
            for (int i = 0; i < teams.size(); ++i) {
                QuestingData.getTeams().add(null);
            }
            teams.stream().filter(team -> !team.isSingle()).forEach(team -> QuestingData.getTeams().set(team.getId(), (Team)team));
            TeamAdapter.commitInvitesMap();
            if (isClient) {
                TeamStats.updateTeams(QuestingData.getTeams().stream().map(Team::toStat).collect(Collectors.toList()));
            }
        }
        catch (IOException e) {
            FMLLog.log((String)"HQM", (Level)Level.INFO, (String)"Can't load teams", (Object[])new Object[0]);
        }
    }

    public static void saveAll() {
        try {
            SaveHandler.saveTeams(SaveHandler.getLocalFile("teams"));
        }
        catch (IOException e) {
            FMLLog.log((String)"HQM", (Level)Level.INFO, (String)"Failed saving teams", (Object[])new Object[0]);
        }
    }

    public static void declineAll(String playerName) {
        block0: for (Team team : QuestingData.getTeams()) {
            Iterator<PlayerEntry> iterator = team.getPlayers().iterator();
            while (iterator.hasNext()) {
                PlayerEntry playerEntry = iterator.next();
                if (playerEntry.isInTeam() || !playerEntry.getUUID().equals(playerName)) continue;
                iterator.remove();
                team.refreshTeamData(TeamUpdateSize.ONLY_OWNER);
                continue block0;
            }
        }
    }

    public void resetProgress(Quest quest) {
        this.questData.put(quest.getId(), Quest.getQuest(quest.getId()).createData(this.getPlayerCount()));
        this.refreshData();
    }

    public Map<String, QuestData> getQuestData() {
        return this.questData;
    }

    public TeamStats toStat() {
        return new TeamStats(this.name, this.getPlayerCount(), this.getSharedLives(), this.getProgress());
    }

    public float getProgress() {
        int completed = 0;
        int total = 0;
        for (QuestData data : this.questData.values()) {
            if (data == null) continue;
            ++total;
            if (!data.completed) continue;
            ++completed;
        }
        return (float)completed / (float)total;
    }

    public void receiveAndSyncReputation(Quest quest, List<ReputationReward> reputationList) {
        for (ReputationReward reputationReward : reputationList) {
            this.setReputation((Reputation)reputationReward.getReward(), this.getReputation((Reputation)reputationReward.getReward()) + reputationReward.getValue());
        }
        for (PlayerEntry entry : this.getPlayers()) {
            if (!entry.isInTeam()) continue;
            NetworkManager.sendToPlayer(TeamUpdateType.REPUTATION_RECEIVED.build(this, quest, reputationList), entry.getPlayerMP());
        }
    }

    public RewardSetting getRewardSetting() {
        return this.rewardSetting;
    }

    public void setRewardSetting(RewardSetting rewardSetting) {
        this.rewardSetting = rewardSetting;
    }

    public LifeSetting getLifeSetting() {
        return this.lifeSetting;
    }

    public void setLifeSetting(LifeSetting lifeSetting) {
        this.lifeSetting = lifeSetting;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public boolean isSharingLives() {
        return this.lifeSetting == LifeSetting.SHARE;
    }

    public int getSharedLives() {
        if (this.clientTeamLives != -1) {
            return this.clientTeamLives;
        }
        int lives = 0;
        for (PlayerEntry entry : this.getPlayers()) {
            if (!entry.isInTeam()) continue;
            lives += QuestingData.getQuestingData(entry.getUUID()).getRawLives();
        }
        return lives;
    }

    public int getPlayerCount() {
        return (int)this.players.stream().filter(PlayerEntry::isInTeam).count();
    }

    public void addPlayer(PlayerEntry entry) {
        this.players.add(entry);
    }

    public void removePlayer(EntityPlayer player) {
        this.removePlayer(QuestingData.getUserUUID(player));
    }

    public void removePlayer(String uuid) {
        int id = 0;
        for (PlayerEntry player : this.players) {
            if (!player.isInTeam()) continue;
            if (player.getUUID().equals(uuid)) {
                QuestData data;
                QuestData leaveData;
                Team leaveTeam = new Team(uuid);
                for (String i : this.questData.keySet()) {
                    leaveData = leaveTeam.questData.get(i);
                    data = this.questData.get(i);
                    if (data == null) continue;
                    boolean[] old = data.reward;
                    data.reward = new boolean[old.length - 1];
                    for (int j = 0; j < data.reward.length; ++j) {
                        data.reward[j] = j < id ? old[j] : old[j + 1];
                    }
                    leaveData.reward[0] = old[id];
                }
                this.players.remove(id);
                for (String i : this.questData.keySet()) {
                    leaveData = leaveTeam.questData.get(i);
                    data = this.questData.get(i);
                    if (data == null || Quest.getQuest(i) == null) continue;
                    Quest.getQuest(i).copyProgress(leaveData, data);
                }
                for (String i : Reputation.getReputations().keySet()) {
                    Reputation reputation = Reputation.getReputation(i);
                    if (reputation == null) continue;
                    leaveTeam.setReputation(reputation, this.getReputation(reputation));
                }
                QuestingData.getQuestingData(uuid).setTeam(leaveTeam);
                this.refreshTeamData(player, TeamUpdateSize.ONLY_MEMBERS);
                leaveTeam.refreshTeamData(player, TeamUpdateSize.ONLY_MEMBERS);
                NetworkManager.sendToPlayer(TeamUpdateType.LEAVE_TEAM.build(this, player.getUUID(), leaveTeam), player.getPlayerMP());
                break;
            }
            ++id;
        }
    }

    public void refreshTeamData(TeamUpdateSize type) {
        for (PlayerEntry entry : this.getPlayers()) {
            this.refreshTeamData(entry, type);
        }
    }

    private void refreshTeamData(PlayerEntry entry, TeamUpdateSize type) {
        boolean valid = false;
        switch (type) {
            case ALL: {
                valid = true;
                break;
            }
            case ONLY_MEMBERS: {
                valid = entry.isInTeam();
                break;
            }
            case ONLY_OWNER: {
                valid = entry.isOwner();
            }
        }
        if (valid) {
            NetworkManager.sendToPlayer(TeamUpdateType.FULL.build(this, new Object[0]), entry.getPlayerMP());
        }
    }

    public void refreshTeamLives() {
        if (!this.isSingle() && this.isSharingLives()) {
            for (PlayerEntry entry : this.getPlayers()) {
                NetworkManager.sendToPlayer(TeamUpdateType.LIVES.build(this, new Object[0]), entry.getPlayerMP());
            }
        }
    }

    public void refreshData() {
        for (PlayerEntry entry : this.getPlayers()) {
            this.refreshTeamData(entry, TeamUpdateSize.ALL);
        }
    }

    public void clearProgress() {
        this.questData.clear();
        this.createQuestData();
        int playerCount = this.getPlayerCount();
        for (Quest quest : Quest.getQuests().values()) {
            if (quest == null || this.questData.get(quest.getId()) == null) continue;
            quest.initRewards(playerCount, this.questData.get(quest.getId()));
        }
        this.refreshData();
    }

    public void deleteTeam() {
        for (int i = this.players.size() - 1; i >= 0; --i) {
            PlayerEntry player = this.players.get(i);
            if (player.isInTeam()) {
                this.removePlayer(player.getUUID());
                continue;
            }
            this.players.remove(i);
        }
        List<Team> teams = QuestingData.getTeams();
        teams.remove(this.id);
        for (int i = this.id; i < teams.size(); ++i) {
            Team team = teams.get(i);
            --team.id;
        }
        NetworkManager.sendToAllPlayers(TeamUpdateType.REMOVE_TEAM.build(this, new Object[0]));
        for (EntityPlayer player : FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_181057_v()) {
            Team team = QuestingData.getQuestingData(player).getTeam();
            PlayerEntry entry = team.getEntry(player.func_110124_au().toString());
            if (entry == null) continue;
            team.refreshTeamData(entry, TeamUpdateSize.ALL);
        }
    }

    public List<Team> getInvites() {
        return this.invites;
    }

    public List<PlayerEntry> getPlayers() {
        return this.players;
    }

    public void create(String name) {
        NetworkManager.sendToServer(new TeamMessage(TeamAction.CREATE, name));
    }

    public void invite(String name) {
        NetworkManager.sendToServer(new TeamMessage(TeamAction.INVITE, name));
    }

    public void accept() {
        NetworkManager.sendToServer(new TeamMessage(TeamAction.ACCEPT, "" + this.id));
    }

    public void decline() {
        NetworkManager.sendToServer(new TeamMessage(TeamAction.DECLINE, "" + this.id));
    }

    public void kick(String name) {
        NetworkManager.sendToServer(new TeamMessage(TeamAction.KICK, name));
    }

    public void leave() {
        NetworkManager.sendToServer(new TeamMessage(TeamAction.LEAVE, ""));
    }

    public void disband() {
        NetworkManager.sendToServer(new TeamMessage(TeamAction.DISBAND, ""));
    }

    public void nextLifeSetting() {
        NetworkManager.sendToServer(new TeamMessage(TeamAction.NEXT_LIFE_SETTING, ""));
    }

    public void nextRewardSetting() {
        NetworkManager.sendToServer(new TeamMessage(TeamAction.NEXT_REWARD_SETTING, ""));
    }

    public boolean isOwner(EntityPlayer player) {
        return this.isOwner(QuestingData.getUserUUID(player));
    }

    public boolean isOwner(String uuid) {
        PlayerEntry entry = this.getEntry(uuid);
        return entry != null && entry.isOwner();
    }

    public PlayerEntry getEntry(String uuid) {
        for (PlayerEntry playerEntry : this.getPlayers()) {
            if (!playerEntry.getUUID().equals(uuid)) continue;
            return playerEntry;
        }
        return null;
    }

    private void createReputation() {
        this.reputation = new HashMap<String, Integer>();
        for (Reputation reputation : Reputation.getReputations().values()) {
            this.createReputation(reputation.getId());
        }
    }

    public int getReputation(Reputation reputation) {
        return this.getReputation(reputation.getId());
    }

    public void setReputation(Reputation reputation, int value) {
        this.setReputation(reputation.getId(), (Integer)value);
    }

    private void createReputation(String id) {
        this.reputation.put(id, 0);
    }

    public int getReputation(String id) {
        Integer value = this.reputation.get(id);
        return value == null ? 0 : value;
    }

    public void setReputation(String id, Integer value) {
        this.reputation.put(id, value);
    }

    private void createQuestData() {
        this.questData = new HashMap<String, QuestData>();
        Quest.getQuests().keySet().forEach(this::createQuestData);
    }

    private void createQuestData(String id) {
        this.questData.put(id, Quest.getQuest(id).createData(1));
    }

    public QuestData getQuestData(String id) {
        if (!this.questData.containsKey(id)) {
            this.createQuestData(id);
        }
        return this.questData.get(id);
    }

    public void setQuestData(String id, QuestData data) {
        this.questData.put(id, data);
    }

    public boolean isSingle() {
        return this.id == -1;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setClientTeamLives(int lives) {
        this.clientTeamLives = lives;
    }

    public void update(Team team) {
        this.name = team.name;
        this.questData = team.questData;
        this.reputation = team.reputation;
        this.lifeSetting = team.lifeSetting;
        this.rewardSetting = team.rewardSetting;
        this.players = team.players;
    }

    public static String saveTeam(EntityPlayer entity) {
        Team team = QuestingData.getQuestingData(entity).getTeam();
        if (team.isSingle()) {
            return "";
        }
        return SaveHandler.saveTeam(team);
    }
}

