/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.team;

import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PlayerEntry {
    private static final String UUID = "uuid";
    private static final String OWNER = "owner";
    private static final String BOOK = "bookOpen";
    private static final String IN_TEAM = "inTeam";
    private String uuid;
    private boolean inTeam;
    private boolean owner;
    private boolean bookOpen;
    private String playername = null;

    private PlayerEntry() {
    }

    public PlayerEntry(String uuid, boolean inTeam, boolean owner) {
        this();
        this.uuid = uuid;
        this.inTeam = inTeam;
        this.owner = owner;
        this.bookOpen = false;
    }

    public static PlayerEntry read(JsonReader in) throws IOException {
        PlayerEntry playerEntry = new PlayerEntry();
        in.beginObject();
        while (in.hasNext()) {
            switch (in.nextName()) {
                case "uuid": {
                    playerEntry.uuid = in.nextString();
                    break;
                }
                case "owner": {
                    playerEntry.owner = in.nextBoolean();
                    break;
                }
                case "bookOpen": {
                    playerEntry.bookOpen = in.nextBoolean();
                    break;
                }
                case "inTeam": {
                    playerEntry.inTeam = in.nextBoolean();
                    break;
                }
            }
        }
        in.endObject();
        return playerEntry;
    }

    public String getUUID() {
        return this.uuid;
    }

    @SideOnly(value=Side.CLIENT)
    public String getDisplayName() {
        if (this.playername == null) {
            EntityPlayer entry = Minecraft.func_71410_x().field_71441_e.func_152378_a(java.util.UUID.fromString(this.uuid));
            this.playername = entry == null ? null : entry.getDisplayNameString();
        }
        return this.playername;
    }

    public boolean isInTeam() {
        return this.inTeam;
    }

    public void setInTeam(boolean inTeam) {
        this.inTeam = inTeam;
    }

    public boolean isOwner() {
        return this.owner;
    }

    public int hashCode() {
        return this.uuid != null ? this.uuid.hashCode() : 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PlayerEntry entry = (PlayerEntry)o;
        return this.uuid != null ? this.uuid.equals(entry.uuid) : entry.uuid == null;
    }

    public boolean isBookOpen() {
        return this.bookOpen;
    }

    public void setBookOpen(boolean bookOpen) {
        this.bookOpen = bookOpen;
    }

    public void write(JsonWriter out) throws IOException {
        out.beginObject();
        out.name(UUID).value(this.uuid);
        out.name(OWNER).value(this.owner);
        out.name(BOOK).value(this.bookOpen);
        out.name(IN_TEAM).value(this.inTeam);
        out.endObject();
    }

    public EntityPlayerMP getPlayerMP() {
        return FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_177451_a(java.util.UUID.fromString(this.uuid));
    }
}

