/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.reputation;

import hardcorequesting.client.EditMode;
import hardcorequesting.client.interfaces.GuiBase;
import hardcorequesting.client.interfaces.GuiColor;
import hardcorequesting.client.interfaces.GuiQuestBook;
import hardcorequesting.client.interfaces.ResourceHelper;
import hardcorequesting.client.interfaces.edit.GuiEditMenuReputationValue;
import hardcorequesting.client.interfaces.edit.GuiEditMenuTextEditor;
import hardcorequesting.io.SaveHandler;
import hardcorequesting.quests.Quest;
import hardcorequesting.quests.QuestingData;
import hardcorequesting.quests.reward.ReputationReward;
import hardcorequesting.quests.task.QuestTask;
import hardcorequesting.quests.task.QuestTaskReputation;
import hardcorequesting.reputation.ReputationMarker;
import hardcorequesting.util.SaveHelper;
import hardcorequesting.util.Translator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.Level;

public class Reputation {
    public static final int BAR_SRC_X = 0;
    public static final int BAR_SRC_Y = 101;
    public static final int BAR_WIDTH = 125;
    public static final int BAR_HEIGHT = 3;
    public static final int BAR_X = 0;
    public static final int BAR_Y = 5;
    public static final int REPUTATION_LIST_X = 20;
    public static final int REPUTATION_MARKER_LIST_X = 180;
    public static final int REPUTATION_LIST_Y = 20;
    public static final int REPUTATION_MARKER_LIST_Y = 35;
    public static final int REPUTATION_NEUTRAL_Y = 20;
    public static final int REPUTATION_OFFSET = 20;
    public static final int FONT_HEIGHT = 9;
    private static final int OFFSET_Y = 24;
    private static final int ARROW_SRC_POINTER_X = 0;
    private static final int ARROW_SRC_MARKER_X = 10;
    private static final int ARROW_SRC_NEUTRAL_X = 20;
    private static final int ARROW_MARKER_OFFSET = 5;
    private static final int ARROW_MARKER_Y = 1;
    private static final int ARROW_POINTER_Y = -5;
    private static final int ARROW_SRC_Y = 93;
    private static final int ARROW_SIZE = 5;
    private static final int TEXT_X = 5;
    private static final int TEXT_Y = 14;
    private static Map<String, Reputation> reputationMap = new HashMap<String, Reputation>();
    private String uuid;
    private String name;
    private ReputationMarker neutral;
    private List<ReputationMarker> markers;

    public Reputation(String name, String neutralName) {
        do {
            this.uuid = UUID.randomUUID().toString();
        } while (reputationMap.containsKey(this.uuid));
        this.name = name;
        this.neutral = new ReputationMarker(neutralName, 0, true);
        this.markers = new ArrayList<ReputationMarker>();
    }

    public Reputation(String id, String name, String neutralName) {
        this.uuid = id;
        while (this.uuid == null || reputationMap.containsKey(this.uuid)) {
            this.uuid = UUID.randomUUID().toString();
        }
        this.name = name;
        this.neutral = new ReputationMarker(neutralName, 0, true);
        this.markers = new ArrayList<ReputationMarker>();
    }

    public static Map<String, Reputation> getReputations() {
        return reputationMap;
    }

    public static List<Reputation> getReputationList() {
        return new ArrayList<Reputation>(reputationMap.values());
    }

    public static Reputation getReputation(String id) {
        return reputationMap.get(id);
    }

    public static void clear() {
        reputationMap.clear();
    }

    public static void addReputation(Reputation reputation) {
        reputationMap.put(reputation.getId(), reputation);
    }

    public static int size() {
        return reputationMap.size();
    }

    @SideOnly(value=Side.CLIENT)
    public static void drawAll(GuiQuestBook gui, int x, int y, int mX, int mY, final EntityPlayer player) {
        String info = null;
        List<Reputation> reputations = Reputation.getReputationList();
        Collections.sort(reputations, new Comparator<Reputation>(){

            @Override
            public int compare(Reputation reputation1, Reputation reputation2) {
                return Integer.valueOf(Math.abs(reputation2.getValue(player))).compareTo(Math.abs(reputation1.getValue(player)));
            }
        });
        int start = gui.reputationDisplayScroll.isVisible(gui) ? Math.round((float)(reputations.size() - 4) * gui.reputationDisplayScroll.getScroll()) : 0;
        int end = Math.min(start + 4, reputations.size());
        for (int i = start; i < end; ++i) {
            gui.applyColor(-1);
            ResourceHelper.bindResource(GuiQuestBook.MAP_TEXTURE);
            info = reputations.get(i).draw(gui, x, y + (i - start) * 24, mX, mY, info, player, false, null, null, false, null, null, false);
        }
        if (info != null) {
            gui.drawMouseOver(info, mX + gui.getLeft(), mY + gui.getTop());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void drawEditPage(GuiQuestBook gui, int mX, int mY) {
        boolean hover;
        String str;
        int y;
        int x;
        int i;
        if (gui.getCurrentMode() != EditMode.CREATE || GuiQuestBook.selectedReputation == null) {
            int start = gui.reputationScroll.isVisible(gui) ? Math.round((float)(reputationMap.size() - 10) * gui.reputationScroll.getScroll()) : 0;
            int end = Math.min(start + 10, reputationMap.size());
            List<Reputation> reputationList = Reputation.getReputationList();
            for (i = start; i < end; ++i) {
                x = 20;
                y = 20 + (i - start) * 20;
                str = reputationList.get((int)i).name;
                hover = gui.inBounds(x, y, gui.getStringWidth(str), 9, mX, mY);
                boolean selected = reputationList.get(i).equals(GuiQuestBook.selectedReputation);
                gui.drawString(str, x, y, selected ? (hover ? 0x40CC40 : 0x409040) : (hover ? 0xAAAAAA : 0x404040));
            }
        }
        if (GuiQuestBook.selectedReputation != null) {
            String neutralName;
            gui.drawString(neutralName, 180, 20, gui.inBounds(180, 20, gui.getStringWidth(neutralName = Translator.translate("hqm.rep.neutral", GuiQuestBook.selectedReputation.neutral.getName())), 9, mX, mY) ? 0xAAAAAA : 0x404040);
            int start = gui.reputationTierScroll.isVisible(gui) ? Math.round((float)(GuiQuestBook.selectedReputation.markers.size() - 9) * gui.reputationTierScroll.getScroll()) : 0;
            int end = Math.min(start + 9, GuiQuestBook.selectedReputation.markers.size());
            for (i = start; i < end; ++i) {
                hover = gui.inBounds(x = 180, y = 35 + (i - start) * 20, gui.getStringWidth(str = GuiQuestBook.selectedReputation.markers.get(i).getTitle()), 9, mX, mY);
                gui.drawString(str, x, y, hover ? 0xAAAAAA : 0x404040);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void onClick(GuiQuestBook gui, int mX, int mY, EntityPlayer player) {
        int y;
        int x;
        int i;
        if (gui.getCurrentMode() != EditMode.CREATE || GuiQuestBook.selectedReputation == null) {
            int start = gui.reputationScroll.isVisible(gui) ? Math.round((float)(reputationMap.size() - 10) * gui.reputationScroll.getScroll()) : 0;
            int end = Math.min(start + 10, reputationMap.size());
            List<Reputation> reputationList = Reputation.getReputationList();
            for (i = start; i < end; ++i) {
                x = 20;
                y = 20 + (i - start) * 20;
                Reputation reputation = reputationList.get(i);
                String str = reputation.name;
                if (!gui.inBounds(x, y, gui.getStringWidth(str), 9, mX, mY)) continue;
                if (gui.getCurrentMode() == EditMode.NORMAL) {
                    GuiQuestBook.selectedReputation = reputation.equals(GuiQuestBook.selectedReputation) ? null : reputation;
                } else if (gui.getCurrentMode() == EditMode.RENAME) {
                    gui.setEditMenu(new GuiEditMenuTextEditor(gui, player, reputation));
                } else if (gui.getCurrentMode() == EditMode.DELETE) {
                    for (Quest quest : Quest.getQuests().values()) {
                        for (QuestTask task : quest.getTasks()) {
                            if (!(task instanceof QuestTaskReputation)) continue;
                            QuestTaskReputation reputationTask = (QuestTaskReputation)task;
                            QuestTaskReputation.ReputationSetting[] settings = reputationTask.getSettings();
                            for (int j = settings.length - 1; j >= 0; --j) {
                                QuestTaskReputation.ReputationSetting setting = settings[j];
                                if (!reputation.equals(setting.getReputation())) continue;
                                reputationTask.removeSetting(j);
                            }
                        }
                        List<ReputationReward> rewards = quest.getReputationRewards();
                        if (rewards == null) continue;
                        Iterator<ReputationReward> iterator = rewards.iterator();
                        while (iterator.hasNext()) {
                            ReputationReward reward = iterator.next();
                            if (!reputation.equals(reward.getReward())) continue;
                            iterator.remove();
                        }
                    }
                    reputationMap.remove(reputation.getId());
                    SaveHelper.add(SaveHelper.EditType.REPUTATION_REMOVE);
                }
                return;
            }
        }
        if (GuiQuestBook.selectedReputation != null) {
            String neutralName = Translator.translate("hqm.rep.neutral", GuiQuestBook.selectedReputation.neutral.getName());
            if (gui.inBounds(180, 20, gui.getStringWidth(neutralName), 9, mX, mY)) {
                if (gui.getCurrentMode() == EditMode.RENAME) {
                    gui.setEditMenu(new GuiEditMenuTextEditor(gui, player, GuiQuestBook.selectedReputation.neutral));
                }
                return;
            }
            int start = gui.reputationTierScroll.isVisible(gui) ? Math.round((float)(GuiQuestBook.selectedReputation.markers.size() - 9) * gui.reputationTierScroll.getScroll()) : 0;
            int end = Math.min(start + 9, GuiQuestBook.selectedReputation.markers.size());
            for (i = start; i < end; ++i) {
                x = 180;
                y = 35 + (i - start) * 20;
                String str = GuiQuestBook.selectedReputation.markers.get(i).getTitle();
                if (!gui.inBounds(x, y, gui.getStringWidth(str), 9, mX, mY)) continue;
                if (gui.getCurrentMode() == EditMode.RENAME) {
                    gui.setEditMenu(new GuiEditMenuTextEditor(gui, player, GuiQuestBook.selectedReputation.markers.get(i)));
                } else if (gui.getCurrentMode() == EditMode.REPUTATION_VALUE) {
                    gui.setEditMenu(new GuiEditMenuReputationValue((GuiBase)gui, player, GuiQuestBook.selectedReputation.markers.get(i)));
                } else if (gui.getCurrentMode() == EditMode.DELETE) {
                    for (Quest quest : Quest.getQuests().values()) {
                        for (QuestTask task : quest.getTasks()) {
                            if (!(task instanceof QuestTaskReputation)) continue;
                            QuestTaskReputation reputationTask = (QuestTaskReputation)task;
                            for (QuestTaskReputation.ReputationSetting setting : reputationTask.getSettings()) {
                                if (GuiQuestBook.selectedReputation.markers.get(i).equals(setting.getLower())) {
                                    setting.setLower(null);
                                }
                                if (!GuiQuestBook.selectedReputation.markers.get(i).equals(setting.getUpper())) continue;
                                setting.setUpper(null);
                            }
                        }
                    }
                    GuiQuestBook.selectedReputation.markers.remove(i);
                    GuiQuestBook.selectedReputation.sort();
                    SaveHelper.add(SaveHelper.EditType.REPUTATION_MARKER_REMOVE);
                }
                return;
            }
        }
    }

    public static void loadAll(boolean remote) {
        reputationMap.clear();
        try {
            SaveHandler.loadReputations(SaveHandler.getFile("reputations", remote)).forEach(Reputation::addReputation);
        }
        catch (IOException ignored) {
            FMLLog.log((String)"HQM", (Level)Level.INFO, (String)"Failed loading reputations", (Object[])new Object[0]);
        }
    }

    public static void saveAll() {
        try {
            SaveHandler.saveReputations(SaveHandler.getLocalFile("reputations"));
        }
        catch (IOException e) {
            FMLLog.log((String)"HQM", (Level)Level.INFO, (String)"Failed saving reputations", (Object[])new Object[0]);
        }
    }

    public static void saveAllDefault() {
        try {
            SaveHandler.saveReputations(SaveHandler.getDefaultFile("reputations"));
        }
        catch (IOException e) {
            FMLLog.log((String)"HQM", (Level)Level.INFO, (String)"Failed saving reputations", (Object[])new Object[0]);
        }
    }

    public String getId() {
        return this.uuid;
    }

    public String getNeutralName() {
        return this.neutral.getName();
    }

    public void sort() {
        Collections.sort(this.markers);
        for (int i = 0; i < this.markers.size(); ++i) {
            this.markers.get(i).setId(i);
        }
        this.neutral.setId(this.markers.size());
    }

    public int getValue(EntityPlayer player) {
        return this.getValue(QuestingData.getUserUUID(player));
    }

    public int getValue(String uuid) {
        return QuestingData.getQuestingData(uuid).getTeam().getReputation(this);
    }

    @SideOnly(value=Side.CLIENT)
    public String draw(GuiQuestBook gui, int x, int y, int mX, int mY, String info, EntityPlayer player, boolean effects, ReputationMarker lower, ReputationMarker upper, boolean inverted, ReputationMarker active, String text, boolean completed) {
        String str;
        String error = this.getError();
        if (error != null) {
            gui.drawRect(x + 0, y + 5, 0, 101, 125, 3);
            gui.drawString(error, x + 5, y + 14, 0.7f, GuiColor.RED.getHexColor());
            return info;
        }
        int lowerValue = 0;
        int upperValue = 0;
        boolean lowerMoved = false;
        boolean upperMoved = false;
        boolean lowerMovedInner = false;
        boolean upperMovedInner = false;
        boolean lowerOnMarker = false;
        boolean upperOnMarker = false;
        if (effects) {
            int i;
            if (lower == null) {
                lowerValue = Math.min(this.markers.get(0).getValue(), 0);
            } else {
                lowerValue = lower.getValue();
                boolean bl = lowerOnMarker = lower.getId() == 0 && lower.getValue() > 0;
                if (lower.isNeutral()) {
                    lowerOnMarker = true;
                    lowerMovedInner = true;
                    lowerMoved = true;
                } else if (lower.getId() == this.markers.size() - 1) {
                    lowerOnMarker = true;
                } else if (lowerValue <= 0) {
                    for (i = 0; i < this.markers.size(); ++i) {
                        if (this.markers.get(i).getValue() < lowerValue) continue;
                        lowerValue = this.markers.get(i).getValue();
                        if (i - 1 == 0) break;
                        lowerMoved = true;
                        break;
                    }
                }
            }
            if (upper == null) {
                upperValue = Math.max(this.markers.get(this.markers.size() - 1).getValue(), 0);
            } else {
                upperValue = upper.getValue();
                boolean bl = upperOnMarker = upper.getId() == this.markers.size() - 1 && upper.getValue() < 0;
                if (upper.isNeutral()) {
                    upperOnMarker = true;
                    upperMovedInner = true;
                    upperMoved = true;
                } else if (upper.getId() == 0) {
                    upperOnMarker = true;
                } else if (upperValue >= 0) {
                    for (i = this.markers.size() - 1; i >= 0; --i) {
                        if (this.markers.get(i).getValue() > upperValue) continue;
                        upperValue = this.markers.get(i).getValue();
                        if (i + 1 != this.markers.size()) break;
                        upperMoved = true;
                        break;
                    }
                }
            }
        }
        int normalSrcY = 101;
        int selectedSrcY = 98;
        if (effects && inverted) {
            normalSrcY = selectedSrcY;
            selectedSrcY = 101;
        }
        gui.drawRect(x + 0, y + 5, 0, normalSrcY, 125, 3);
        if (effects) {
            int leftX = this.getPointerPosition(lowerValue, lowerOnMarker);
            if (lowerMoved) {
                leftX += lowerMovedInner ? 1 : 6;
            }
            int rightX = this.getPointerPosition(upperValue, upperOnMarker) + 1;
            if (upperMoved) {
                rightX -= upperMovedInner ? 1 : 5;
            }
            gui.drawRect(x + 0 + leftX, y + 5, 0 + leftX, selectedSrcY, rightX - leftX, 3);
        }
        for (int i = 0; i < this.markers.size(); ++i) {
            int position = i * 115 / (this.markers.size() - 1);
            int markerX = x + 0 - 2 + position + 5;
            int markerY = y + 5 + 1;
            int srcX = 10;
            int value = this.markers.get(i).getValue();
            if (info == null && gui.inBounds(markerX, markerY, 5, 5, mX, mY)) {
                srcX += 5;
                info = this.markers.get(i).getName() + " (" + value + ")";
            }
            boolean selected = this.markers.get(i).equals(active) || effects && (lowerValue <= value && value <= upperValue) != inverted;
            gui.drawRect(markerX, markerY, srcX, 93 + (selected ? -5 : 0), 5, 5);
        }
        ReputationMarker current = null;
        int value = 0;
        if (player != null) {
            value = this.getValue(player);
            current = this.getCurrentMarker(value);
            if (this.drawPointer(gui, value, x, y, -5, 0, mX, mY, false)) {
                info = current.getName() + " (" + value + ")";
            }
        }
        if (this.drawPointer(gui, 0, x, y, 1, 20, mX, mY, this.neutral.equals(active) || effects && (lowerValue <= 0 && 0 <= upperValue) != inverted)) {
            info = this.neutral.getName();
        }
        boolean selected = false;
        if (text != null) {
            str = text;
        } else if (current == null || lower != null || upper != null) {
            if (lower == null && upper == null) {
                str = (Object)((Object)GuiColor.RED) + Translator.translate("hqm.rep" + (inverted ? "no" : "any") + "ValueOf") + " " + this.name;
            } else {
                String upperName;
                String lowerName;
                String string = lower == null ? null : (lowerName = GuiScreen.func_146272_n() ? String.valueOf(lower.getValue()) : lower.getName());
                String string2 = upper == null ? null : (upperName = GuiScreen.func_146272_n() ? String.valueOf(upper.getValue()) : upper.getName());
                str = lower != null && upper != null ? (lower.equals(upper) ? (inverted ? this.name + " != " + lowerName : this.name + " == " + lowerName) : (inverted ? Translator.translate("hqm.rep.not") + " (" + lowerName + " <= " + this.name + " <= " + upperName + ")" : lowerName + " <= " + this.name + " <= " + upperName)) : (lower != null ? this.name + " " + (inverted ? "<" : ">=") + " " + lowerName : this.name + " " + (inverted ? ">" : "<=") + " " + upperName);
            }
        } else {
            str = this.name + ": " + current.getName() + " (" + value + ")";
            selected = completed || effects && (lowerValue <= current.getValue() && current.getValue() <= upperValue) != inverted;
        }
        gui.drawString(str, x + 5, y + 14, 0.7f, selected ? 0x40AA40 : 0x404040);
        return info;
    }

    private String getError() {
        String error = null;
        if (this.markers.size() < 2) {
            error = "atLeastTwo";
        } else {
            for (ReputationMarker marker : this.markers) {
                if (marker.getValue() == 0) {
                    error = "notZero";
                } else {
                    for (ReputationMarker marker2 : this.markers) {
                        if (marker.equals(marker2) || marker.getValue() != marker2.getValue()) continue;
                        error = "unique";
                        break;
                    }
                }
                if (error == null) continue;
                break;
            }
        }
        return error == null ? null : Translator.translate("hqm.rep." + error);
    }

    public ReputationMarker getCurrentMarker(int value) {
        ReputationMarker current = this.neutral;
        if (value != 0) {
            for (ReputationMarker marker : this.markers) {
                if (value > 0 && marker.getValue() > 0 && value >= marker.getValue()) {
                    current = marker;
                    continue;
                }
                if (value >= 0 || marker.getValue() >= 0 || value > marker.getValue()) continue;
                current = marker;
                break;
            }
        }
        return current;
    }

    private boolean drawPointer(GuiQuestBook gui, int value, int x, int y, int offsetY, int srcX, int mX, int mY, boolean selectedTexture) {
        int pointerY;
        boolean flag = false;
        int pointerX = x + 0 - 2 + this.getPointerPosition(value, true);
        if (gui.inBounds(pointerX, pointerY = y + 5 + offsetY, 5, 5, mX, mY)) {
            srcX += 5;
            flag = true;
        }
        gui.drawRect(pointerX, pointerY, srcX, 93 + (selectedTexture ? -5 : 0), 5, 5);
        return flag;
    }

    private int getPointerPosition(int value, boolean onMarker) {
        int pointerPosition = 124;
        for (int i = 0; i < this.markers.size(); ++i) {
            boolean pointAtMarker;
            ReputationMarker marker = this.markers.get(i);
            if (value > marker.getValue()) continue;
            boolean bl = pointAtMarker = onMarker && value == marker.getValue();
            if (pointAtMarker) {
                pointerPosition = 5 + i * 115 / (this.markers.size() - 1);
                break;
            }
            if (i == this.markers.size() - 1 && marker.getValue() == value) {
                pointerPosition = 124;
                break;
            }
            if (i == 0) {
                pointerPosition = 0;
                break;
            }
            ReputationMarker prevMarker = this.markers.get(i - 1);
            int span = marker.getValue() - prevMarker.getValue();
            int internalValue = value - prevMarker.getValue();
            pointerPosition = 5 + (int)(((float)(i - 1) + (float)internalValue / (float)span) * 115.0f / (float)(this.markers.size() - 1));
            break;
        }
        return pointerPosition;
    }

    @SideOnly(value=Side.CLIENT)
    public ReputationMarker onActiveClick(GuiQuestBook gui, int x, int y, int mX, int mY) {
        int pointerY;
        if (this.getError() != null) {
            return null;
        }
        int pointerX = x + 0 - 2 + this.getPointerPosition(0, true);
        if (gui.inBounds(pointerX, pointerY = y + 5 + 1, 5, 5, mX, mY)) {
            return this.neutral;
        }
        for (int i = 0; i < this.markers.size(); ++i) {
            int markerY;
            int position = i * 115 / (this.markers.size() - 1);
            int markerX = x + 0 - 2 + position + 5;
            if (!gui.inBounds(markerX, markerY = y + 5 + 1, 5, 5, mX, mY)) continue;
            return this.markers.get(i);
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void clearMarkers() {
        this.markers.clear();
        this.sort();
    }

    public void add(ReputationMarker marker) {
        this.markers.add(marker);
        this.sort();
    }

    public ReputationMarker getMarker(int i) {
        if (i == this.markers.size()) {
            return this.neutral;
        }
        return this.markers.get(i);
    }

    public boolean isValid() {
        return this.markers.size() >= 2;
    }

    public int getMarkerCount() {
        return this.markers.size();
    }
}

