/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.quests.task;

import hardcorequesting.client.interfaces.GuiColor;
import hardcorequesting.client.interfaces.GuiQuestBook;
import hardcorequesting.event.EventHandler;
import hardcorequesting.quests.Quest;
import hardcorequesting.quests.data.QuestDataTask;
import hardcorequesting.quests.data.QuestDataTaskReputationKill;
import hardcorequesting.quests.task.QuestTaskMob;
import hardcorequesting.quests.task.QuestTaskReputation;
import hardcorequesting.util.Translator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class QuestTaskReputationKill
extends QuestTaskReputation {
    private int kills;

    public QuestTaskReputationKill(Quest parent, String description, String longDescription) {
        super(parent, description, longDescription, 20);
        this.register(EventHandler.Type.DEATH);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void draw(GuiQuestBook gui, EntityPlayer player, int mX, int mY) {
        super.draw(gui, player, mX, mY);
        int killCount = ((QuestDataTaskReputationKill)this.getData((EntityPlayer)player)).kills;
        if (Quest.isEditing) {
            gui.drawString(gui.getLinesFromText(Translator.translate(this.kills != 1, "hqm.repKil.kills", killCount, this.kills), 1.0f, 130), 180, 95, 1.0f, 0x404040);
        } else {
            gui.drawString(gui.getLinesFromText(killCount == this.kills ? (Object)((Object)GuiColor.GREEN) + Translator.translate(this.kills != 1, "hqm.repKil.killCount", this.kills) : Translator.translate("hqm.repKil.killCountOutOf", killCount, this.kills), 1.0f, 130), 180, 95, 1.0f, 0x404040);
        }
    }

    @Override
    public float getCompletedRatio(String uuid) {
        return (float)((QuestDataTaskReputationKill)this.getData((String)uuid)).kills / (float)this.kills;
    }

    @Override
    public void mergeProgress(String uuid, QuestDataTask own, QuestDataTask other) {
        ((QuestDataTaskReputationKill)own).kills = Math.max(((QuestDataTaskReputationKill)own).kills, ((QuestDataTaskReputationKill)other).kills);
        if (((QuestDataTaskReputationKill)own).kills == this.kills) {
            this.completeTask(uuid);
        }
    }

    @Override
    public void autoComplete(String uuid) {
        this.kills = ((QuestDataTaskReputationKill)this.getData((String)uuid)).kills;
    }

    @Override
    protected EntityPlayer getPlayerForRender(EntityPlayer player) {
        return null;
    }

    @Override
    public Class<? extends QuestDataTask> getDataType() {
        return QuestDataTaskReputationKill.class;
    }

    @Override
    public void onUpdate(EntityPlayer player) {
    }

    @Override
    public void copyProgress(QuestDataTask own, QuestDataTask other) {
        super.copyProgress(own, other);
        ((QuestDataTaskReputationKill)own).kills = ((QuestDataTaskReputationKill)other).kills;
    }

    @Override
    public void onLivingDeath(LivingDeathEvent event) {
        EntityPlayer killer = QuestTaskMob.getKiller(event);
        if (killer != null && this.parent.isEnabled(killer) && this.parent.isAvailable(killer) && this.isVisible(killer) && !this.isCompleted(killer) && !killer.equals((Object)event.getEntityLiving()) && event.getEntityLiving() instanceof EntityPlayer && this.isPlayerInRange((EntityPlayer)event.getEntityLiving())) {
            QuestDataTaskReputationKill killData = (QuestDataTaskReputationKill)this.getData(killer);
            if (killData.kills < this.kills) {
                ++killData.kills;
                if (killData.kills == this.kills) {
                    this.completeTask(killer.func_110124_au());
                }
                this.parent.sendUpdatedDataToTeam(killer);
            }
        }
    }

    public int getKills() {
        return this.kills;
    }

    public void setKills(int kills) {
        this.kills = kills;
    }
}

