/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.quests.task;

import hardcorequesting.client.EditMode;
import hardcorequesting.client.interfaces.GuiQuestBook;
import hardcorequesting.client.interfaces.ResourceHelper;
import hardcorequesting.client.interfaces.edit.GuiEditMenuReputationSetting;
import hardcorequesting.quests.Quest;
import hardcorequesting.quests.QuestingData;
import hardcorequesting.quests.data.QuestDataTask;
import hardcorequesting.quests.task.QuestTask;
import hardcorequesting.reputation.Reputation;
import hardcorequesting.reputation.ReputationMarker;
import hardcorequesting.util.SaveHelper;
import java.util.Arrays;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class QuestTaskReputation
extends QuestTask {
    private static final int OFFSET_Y = 27;
    private final int startOffsetY;
    private ReputationSetting[] settings = new ReputationSetting[0];

    public QuestTaskReputation(Quest parent, String description, String longDescription, int startOffsetY) {
        super(parent, description, longDescription);
        this.startOffsetY = startOffsetY;
    }

    public ReputationSetting[] getSettings() {
        return this.settings;
    }

    public void setSetting(int id, ReputationSetting setting) {
        if (id >= this.settings.length) {
            this.settings = Arrays.copyOf(this.settings, this.settings.length + 1);
            SaveHelper.add(SaveHelper.EditType.REPUTATION_TASK_CREATE);
        } else {
            SaveHelper.add(SaveHelper.EditType.REPUTATION_TASK_CHANGE);
        }
        this.settings[id] = setting;
    }

    protected boolean isPlayerInRange(EntityPlayer player) {
        if (this.settings.length > 0) {
            QuestDataTask data = this.getData(player);
            if (!data.completed && !player.func_130014_f_().field_72995_K) {
                String name = QuestingData.getUserUUID(player);
                for (ReputationSetting setting : this.settings) {
                    if (setting.isValid(name)) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void draw(GuiQuestBook gui, EntityPlayer player, int mX, int mY) {
        String info = null;
        int size = Quest.isEditing ? this.settings.length + 1 : this.settings.length;
        for (int i = 0; i < size; ++i) {
            gui.applyColor(-1);
            ResourceHelper.bindResource(GuiQuestBook.MAP_TEXTURE);
            if (i >= this.settings.length) {
                gui.drawRect(180, 95 + this.startOffsetY + i * 27 + 5, 0, 101, 125, 3);
                continue;
            }
            ReputationSetting setting = this.settings[i];
            info = setting.reputation.draw(gui, 180, 95 + this.startOffsetY + i * 27, mX, mY, info, this.getPlayerForRender(player), true, setting.lower, setting.upper, setting.inverted, null, null, this.getData((EntityPlayer)player).completed);
        }
        if (info != null) {
            gui.drawMouseOver(info, mX + gui.getLeft(), mY + gui.getTop());
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onClick(GuiQuestBook gui, EntityPlayer player, int mX, int mY, int b) {
        if (Quest.isEditing && gui.getCurrentMode() != EditMode.NORMAL) {
            int size = this.settings.length + 1;
            for (int i = 0; i < size; ++i) {
                if (!gui.inBounds(180, 95 + this.startOffsetY + i * 27, 125, 20, mX, mY)) continue;
                if (gui.getCurrentMode() == EditMode.REPUTATION_TASK) {
                    gui.setEditMenu(new GuiEditMenuReputationSetting(gui, player, this, i, i >= this.settings.length ? null : this.settings[i]));
                    break;
                }
                if (gui.getCurrentMode() != EditMode.DELETE || i >= this.settings.length) break;
                this.removeSetting(i);
                SaveHelper.add(SaveHelper.EditType.REPUTATION_TASK_REMOVE);
                break;
            }
        }
    }

    @Override
    public float getCompletedRatio(String uuid) {
        int count = this.settings.length;
        if (count == 0) {
            return 0.0f;
        }
        int valid = 0;
        for (ReputationSetting setting : this.settings) {
            if (!setting.isValid(uuid)) continue;
            ++valid;
        }
        return (float)valid / (float)count;
    }

    @Override
    public void mergeProgress(String uuid, QuestDataTask own, QuestDataTask other) {
        if (other.completed) {
            own.completed = true;
        }
    }

    @Override
    public void autoComplete(String uuid) {
        this.getData((String)uuid).completed = true;
    }

    protected EntityPlayer getPlayerForRender(EntityPlayer player) {
        return player;
    }

    public void removeSetting(int i) {
        int id = 0;
        ReputationSetting[] settings = new ReputationSetting[this.settings.length - 1];
        for (int j = 0; j < this.settings.length; ++j) {
            if (j == i) continue;
            settings[id] = this.settings[j];
            ++id;
        }
        this.settings = settings;
    }

    public static class ReputationSetting {
        private Reputation reputation;
        private ReputationMarker lower;
        private ReputationMarker upper;
        private boolean inverted;

        public ReputationSetting(Reputation reputation, ReputationMarker lower, ReputationMarker upper, boolean inverted) {
            this.reputation = reputation;
            this.lower = lower;
            this.upper = upper;
            this.inverted = inverted;
        }

        public Reputation getReputation() {
            return this.reputation;
        }

        public ReputationMarker getLower() {
            return this.lower;
        }

        public void setLower(ReputationMarker lower) {
            this.lower = lower;
        }

        public ReputationMarker getUpper() {
            return this.upper;
        }

        public void setUpper(ReputationMarker upper) {
            this.upper = upper;
        }

        public boolean isInverted() {
            return this.inverted;
        }

        public boolean isValid(String uuid) {
            if (this.getReputation() == null || !this.getReputation().isValid()) {
                return false;
            }
            ReputationMarker current = this.getReputation().getCurrentMarker(this.getReputation().getValue(uuid));
            return !(this.lower != null && this.lower.getValue() > current.getValue() || this.upper != null && current.getValue() > this.upper.getValue()) != this.inverted;
        }
    }
}

