/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.quests.task;

import hardcorequesting.client.EditMode;
import hardcorequesting.client.interfaces.GuiBase;
import hardcorequesting.client.interfaces.GuiColor;
import hardcorequesting.client.interfaces.GuiQuestBook;
import hardcorequesting.client.interfaces.edit.GuiEditMenuItem;
import hardcorequesting.client.interfaces.edit.GuiEditMenuMob;
import hardcorequesting.client.interfaces.edit.GuiEditMenuTextEditor;
import hardcorequesting.event.EventHandler;
import hardcorequesting.quests.ItemPrecision;
import hardcorequesting.quests.Quest;
import hardcorequesting.quests.data.QuestDataTask;
import hardcorequesting.quests.data.QuestDataTaskMob;
import hardcorequesting.quests.task.QuestTask;
import hardcorequesting.util.SaveHelper;
import hardcorequesting.util.Translator;
import java.util.Arrays;
import javax.annotation.Nonnull;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class QuestTaskMob
extends QuestTask {
    private static final int Y_OFFSET = 30;
    private static final int X_TEXT_OFFSET = 23;
    private static final int X_TEXT_INDENT = 0;
    private static final int Y_TEXT_OFFSET = 0;
    private static final int ITEM_SIZE = 18;
    public Mob[] mobs = new Mob[0];

    public QuestTaskMob(Quest parent, String description, String longDescription) {
        super(parent, description, longDescription);
        this.register(EventHandler.Type.DEATH);
    }

    public static EntityPlayer getKiller(LivingDeathEvent event) {
        if (event.getEntityLiving() != null && !event.getEntityLiving().func_130014_f_().field_72995_K && event.getSource() != null) {
            if (event.getSource().func_76364_f() != null && event.getSource().func_76364_f() instanceof EntityPlayer) {
                return (EntityPlayer)event.getSource().func_76364_f();
            }
            if (event.getEntityLiving().func_174793_f() instanceof EntityPlayer) {
                return (EntityPlayer)event.getEntityLiving().func_174793_f();
            }
        }
        return null;
    }

    public void setMob(int id, Mob mob, EntityPlayer player) {
        if (id >= this.mobs.length) {
            this.mobs = Arrays.copyOf(this.mobs, this.mobs.length + 1);
            QuestDataTaskMob data = (QuestDataTaskMob)this.getData(player);
            data.killed = Arrays.copyOf(data.killed, data.killed.length + 1);
            SaveHelper.add(SaveHelper.EditType.MONSTER_CREATE);
        } else {
            SaveHelper.add(SaveHelper.EditType.MONSTER_CHANGE);
        }
        this.mobs[id] = mob;
    }

    public void setIcon(int id, ItemStack stack, EntityPlayer player) {
        System.out.println(stack);
        this.setMob(id, id >= this.mobs.length ? new Mob() : this.mobs[id], player);
        this.mobs[id].iconStack = stack;
    }

    public void setName(int id, String str, EntityPlayer player) {
        this.setMob(id, id >= this.mobs.length ? new Mob() : this.mobs[id], player);
        this.mobs[id].name = str;
    }

    private Mob[] getEditFriendlyMobs(Mob[] mobs) {
        if (Quest.isEditing) {
            mobs = Arrays.copyOf(mobs, mobs.length + 1);
            mobs[mobs.length - 1] = new Mob();
            return mobs;
        }
        return mobs;
    }

    private int killed(int id, EntityPlayer player) {
        return id < this.mobs.length ? ((QuestDataTaskMob)this.getData((EntityPlayer)player)).killed[id] : 0;
    }

    @Override
    public Class<? extends QuestDataTask> getDataType() {
        return QuestDataTaskMob.class;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void draw(GuiQuestBook gui, EntityPlayer player, int mX, int mY) {
        Mob[] mobs = this.getEditFriendlyMobs(this.mobs);
        for (int i = 0; i < mobs.length; ++i) {
            Mob mob = mobs[i];
            int x = 180;
            int y = 95 + i * 30;
            gui.drawItemStack(mob.iconStack, x, y, mX, mY, false);
            gui.drawString(mob.name, x + 23, y + 0, 0x404040);
            int killed = this.killed(i, player);
            if (killed == mob.count) {
                gui.drawString((Object)((Object)GuiColor.GREEN) + Translator.translate("hqm.mobTask.allKilled"), x + 23 + 0, y + 0 + 9, 0.7f, 0x404040);
            } else {
                gui.drawString(Translator.translate("hqm.mobTask.partKills", killed, 100 * killed / mob.count), x + 23 + 0, y + 0 + 9, 0.7f, 0x404040);
            }
            gui.drawString(Translator.translate("hqm.mobTask.totalKills", mob.count), x + 23 + 0, y + 0 + 15, 0.7f, 0x404040);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onClick(GuiQuestBook gui, EntityPlayer player, int mX, int mY, int b) {
        if (Quest.isEditing && gui.getCurrentMode() != EditMode.NORMAL) {
            Mob[] mobs = this.getEditFriendlyMobs(this.mobs);
            block6: for (int i = 0; i < mobs.length; ++i) {
                Mob mob = mobs[i];
                int x = 180;
                int y = 95 + i * 30;
                if (!gui.inBounds(x, y, 18, 18, mX, mY)) continue;
                switch (gui.getCurrentMode()) {
                    case MOB: {
                        gui.setEditMenu(new GuiEditMenuMob(gui, this, mob.copy(), i, player));
                        break;
                    }
                    case ITEM: {
                        gui.setEditMenu(new GuiEditMenuItem((GuiBase)gui, player, (Object)mob.iconStack, i, GuiEditMenuItem.Type.MOB, 1, ItemPrecision.PRECISE));
                        break;
                    }
                    case RENAME: {
                        gui.setEditMenu(new GuiEditMenuTextEditor(gui, player, this, i, mob));
                        break;
                    }
                    case DELETE: {
                        if (i >= this.mobs.length) break block6;
                        Mob[] newMobs = new Mob[this.mobs.length - 1];
                        int id = 0;
                        for (int j = 0; j < this.mobs.length; ++j) {
                            if (j == i) continue;
                            newMobs[id] = this.mobs[j];
                            ++id;
                        }
                        this.mobs = newMobs;
                        SaveHelper.add(SaveHelper.EditType.MONSTER_REMOVE);
                        break;
                    }
                }
                break;
            }
        }
    }

    @Override
    public void onUpdate(EntityPlayer player) {
    }

    @Override
    public float getCompletedRatio(String uuid) {
        int killed = 0;
        int total = 0;
        for (int i = 0; i < this.mobs.length; ++i) {
            killed += ((QuestDataTaskMob)this.getData((String)uuid)).killed[i];
            total += this.mobs[i].count;
        }
        return (float)killed / (float)total;
    }

    @Override
    public void mergeProgress(String uuid, QuestDataTask own, QuestDataTask other) {
        int[] killed = ((QuestDataTaskMob)own).killed;
        int[] otherKilled = ((QuestDataTaskMob)other).killed;
        boolean all = true;
        for (int i = 0; i < killed.length; ++i) {
            killed[i] = Math.max(killed[i], otherKilled[i]);
            if (killed[i] >= this.mobs[i].count) continue;
            all = false;
        }
        if (all) {
            this.completeTask(uuid);
        }
    }

    @Override
    public void autoComplete(String uuid) {
        int[] killed = ((QuestDataTaskMob)this.getData((String)uuid)).killed;
        for (int i = 0; i < killed.length; ++i) {
            killed[i] = this.mobs[i].count;
        }
    }

    @Override
    public void copyProgress(QuestDataTask own, QuestDataTask other) {
        super.copyProgress(own, other);
        int[] killed = ((QuestDataTaskMob)own).killed;
        System.arraycopy(((QuestDataTaskMob)other).killed, 0, killed, 0, killed.length);
    }

    @Override
    public void onLivingDeath(LivingDeathEvent event) {
        EntityPlayer player = QuestTaskMob.getKiller(event);
        if (player != null && this.parent.isEnabled(player) && this.parent.isAvailable(player) && this.isVisible(player) && !this.isCompleted(player)) {
            boolean updated = false;
            for (int i = 0; i < this.mobs.length; ++i) {
                Class clazz;
                Mob mob = this.mobs[i];
                if (mob.count <= ((QuestDataTaskMob)this.getData((EntityPlayer)player)).killed[i] || (clazz = (Class)EntityList.field_75625_b.get(mob.mob)) == null) continue;
                if (mob.isExact()) {
                    if (!clazz.equals(event.getEntityLiving().getClass())) continue;
                    int n = i;
                    ((QuestDataTaskMob)this.getData((EntityPlayer)player)).killed[n] = ((QuestDataTaskMob)this.getData((EntityPlayer)player)).killed[n] + 1;
                    updated = true;
                    continue;
                }
                if (!clazz.isAssignableFrom(event.getEntityLiving().getClass())) continue;
                int n = i;
                ((QuestDataTaskMob)this.getData((EntityPlayer)player)).killed[n] = ((QuestDataTaskMob)this.getData((EntityPlayer)player)).killed[n] + 1;
                updated = true;
            }
            if (updated) {
                boolean done = true;
                for (int i = 0; i < this.mobs.length; ++i) {
                    Mob mob = this.mobs[i];
                    if (this.killed(i, player) >= mob.count) continue;
                    done = false;
                    break;
                }
                if (done) {
                    this.completeTask(player.func_110124_au());
                }
                this.parent.sendUpdatedDataToTeam(player);
            }
        }
    }

    public class Mob {
        private ItemStack iconStack;
        private String name = "New";
        private String mob;
        private int count = 1;
        private boolean exact;

        public Mob copy() {
            Mob other = new Mob();
            other.iconStack = this.iconStack == null ? null : this.iconStack.func_77946_l();
            other.name = this.name;
            other.mob = this.mob;
            other.count = this.count;
            other.exact = this.exact;
            return other;
        }

        public ItemStack getIconStack() {
            return this.iconStack;
        }

        public void setIconStack(@Nonnull ItemStack iconStack) {
            this.iconStack = iconStack;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getMob() {
            return this.mob;
        }

        public void setMob(String mob) {
            this.mob = mob;
        }

        public int getCount() {
            return this.count;
        }

        public void setCount(int count) {
            this.count = count;
        }

        public boolean isExact() {
            return this.exact;
        }

        public void setExact(boolean exact) {
            this.exact = exact;
        }
    }
}

