/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.quests.task;

import hardcorequesting.client.EditMode;
import hardcorequesting.client.interfaces.GuiBase;
import hardcorequesting.client.interfaces.GuiColor;
import hardcorequesting.client.interfaces.GuiQuestBook;
import hardcorequesting.client.interfaces.edit.GuiEditMenuItem;
import hardcorequesting.client.interfaces.edit.GuiEditMenuLocation;
import hardcorequesting.client.interfaces.edit.GuiEditMenuTextEditor;
import hardcorequesting.event.EventHandler;
import hardcorequesting.quests.ItemPrecision;
import hardcorequesting.quests.Quest;
import hardcorequesting.quests.data.QuestDataTask;
import hardcorequesting.quests.data.QuestDataTaskLocation;
import hardcorequesting.quests.task.QuestTask;
import hardcorequesting.util.SaveHelper;
import hardcorequesting.util.Translator;
import java.util.Arrays;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class QuestTaskLocation
extends QuestTask {
    private static final int CHECK_DELAY = 20;
    private static final int Y_OFFSET = 30;
    private static final int X_TEXT_OFFSET = 23;
    private static final int X_TEXT_INDENT = 0;
    private static final int Y_TEXT_OFFSET = 0;
    private static final int ITEM_SIZE = 18;
    public Location[] locations = new Location[0];
    private int delay = 1;

    public QuestTaskLocation(Quest parent, String description, String longDescription) {
        super(parent, description, longDescription);
        this.register(EventHandler.Type.SERVER, EventHandler.Type.PLAYER);
    }

    private void tick(EntityPlayer player, boolean isPlayerEvent) {
        if (!isPlayerEvent) {
            ++this.delay;
            this.delay %= 20;
        } else if (this.delay == 0) {
            World world = player.func_130014_f_();
            if (!world.field_72995_K) {
                boolean[] visited = ((QuestDataTaskLocation)this.getData((EntityPlayer)player)).visited;
                boolean all = true;
                boolean updated = false;
                for (int i = 0; i < this.locations.length; ++i) {
                    Location location = this.locations[i];
                    if (visited[i] || player.func_130014_f_().field_73011_w.getDimension() != location.dimension) continue;
                    int current = (int)player.func_70092_e((double)location.x + 0.5, (double)location.y + 0.5, (double)location.z + 0.5);
                    int target = location.radius * location.radius;
                    if (location.radius >= 0 && current > target) {
                        all = false;
                        continue;
                    }
                    if (this.isCompleted(player) || !this.isVisible(player) || !this.parent.isEnabled(player) || !this.parent.isAvailable(player)) continue;
                    updated = true;
                    visited[i] = true;
                }
                if (updated) {
                    if (all) {
                        this.completeTask(player.func_110124_au());
                    }
                    this.parent.sendUpdatedDataToTeam(player);
                }
            }
        }
    }

    private Location[] getEditFriendlyLocations(Location[] locations) {
        if (Quest.isEditing) {
            locations = Arrays.copyOf(locations, locations.length + 1);
            locations[locations.length - 1] = new Location();
            return locations;
        }
        return locations;
    }

    private boolean visited(int id, EntityPlayer player) {
        return id < this.locations.length && ((QuestDataTaskLocation)this.getData((EntityPlayer)player)).visited[id];
    }

    public void setLocation(int id, Location location, EntityPlayer player) {
        if (id >= this.locations.length) {
            this.locations = Arrays.copyOf(this.locations, this.locations.length + 1);
            QuestDataTaskLocation data = (QuestDataTaskLocation)this.getData(player);
            data.visited = Arrays.copyOf(data.visited, data.visited.length + 1);
            SaveHelper.add(SaveHelper.EditType.LOCATION_CREATE);
        } else {
            SaveHelper.add(SaveHelper.EditType.LOCATION_CHANGE);
        }
        this.locations[id] = location;
    }

    public void setIcon(int id, ItemStack stack, EntityPlayer player) {
        this.setLocation(id, id >= this.locations.length ? new Location() : this.locations[id], player);
        this.locations[id].iconStack = stack;
    }

    public void setName(int id, String str, EntityPlayer player) {
        this.setLocation(id, id >= this.locations.length ? new Location() : this.locations[id], player);
        this.locations[id].name = str;
    }

    @Override
    public Class<? extends QuestDataTask> getDataType() {
        return QuestDataTaskLocation.class;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void draw(GuiQuestBook gui, EntityPlayer player, int mX, int mY) {
        Location[] locations = this.getEditFriendlyLocations(this.locations);
        for (int i = 0; i < locations.length; ++i) {
            Location location = locations[i];
            int x = 180;
            int y = 95 + i * 30;
            gui.drawItemStack(location.iconStack, x, y, mX, mY, false);
            gui.drawString(location.name, x + 23, y + 0, 0x404040);
            if (this.visited(i, player)) {
                gui.drawString((Object)((Object)GuiColor.GREEN) + Translator.translate("hqm.locationMenu.visited"), x + 23 + 0, y + 0 + 9, 0.7f, 0x404040);
                continue;
            }
            if (!location.visible.doShowCoordinate()) continue;
            if (location.radius >= 0) {
                gui.drawString("(" + location.x + ", " + location.y + ", " + location.z + ")", x + 23 + 0, y + 0 + 9, 0.7f, 0x404040);
            }
            if (player.func_130014_f_().field_73011_w.getDimension() == location.dimension) {
                if (location.radius < 0) continue;
                int distance = (int)player.func_70011_f((double)location.x + 0.5, (double)location.y + 0.5, (double)location.z + 0.5);
                String str = Translator.translate("hqm.locationMenu.mAway", distance);
                if (location.visible.doShowRadius()) {
                    str = str + " [" + Translator.translate("hqm.locationMenu.mRadius", location.radius) + "]";
                }
                gui.drawString(str, x + 23 + 0, y + 0 + 15, 0.7f, 0x404040);
                continue;
            }
            gui.drawString(Translator.translate("hqm.locationMenu.wrongDim"), x + 23 + 0, y + 0 + (location.radius >= 0 ? 15 : 9), 0.7f, 0x404040);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onClick(GuiQuestBook gui, EntityPlayer player, int mX, int mY, int b) {
        if (Quest.isEditing && gui.getCurrentMode() != EditMode.NORMAL) {
            Location[] locations = this.getEditFriendlyLocations(this.locations);
            block6: for (int i = 0; i < locations.length; ++i) {
                Location location = locations[i];
                int x = 180;
                int y = 95 + i * 30;
                if (!gui.inBounds(x, y, 18, 18, mX, mY)) continue;
                switch (gui.getCurrentMode()) {
                    case LOCATION: {
                        gui.setEditMenu(new GuiEditMenuLocation(gui, this, location.copy(), i, player));
                        break;
                    }
                    case ITEM: {
                        gui.setEditMenu(new GuiEditMenuItem((GuiBase)gui, player, (Object)location.iconStack, i, GuiEditMenuItem.Type.LOCATION, 1, ItemPrecision.PRECISE));
                        break;
                    }
                    case RENAME: {
                        gui.setEditMenu(new GuiEditMenuTextEditor(gui, player, this, i, location));
                        break;
                    }
                    case DELETE: {
                        if (i >= this.locations.length) break block6;
                        Location[] newLocations = new Location[this.locations.length - 1];
                        int id = 0;
                        for (int j = 0; j < this.locations.length; ++j) {
                            if (j == i) continue;
                            newLocations[id] = this.locations[j];
                            ++id;
                        }
                        this.locations = newLocations;
                        SaveHelper.add(SaveHelper.EditType.LOCATION_REMOVE);
                        break;
                    }
                }
                break;
            }
        }
    }

    @Override
    public void onUpdate(EntityPlayer player) {
    }

    @Override
    public float getCompletedRatio(String uuid) {
        int visited = 0;
        for (boolean b : ((QuestDataTaskLocation)this.getData((String)uuid)).visited) {
            if (!b) continue;
            ++visited;
        }
        return (float)visited / (float)this.locations.length;
    }

    @Override
    public void mergeProgress(String uuid, QuestDataTask own, QuestDataTask other) {
        boolean[] visited = ((QuestDataTaskLocation)own).visited;
        boolean[] otherVisited = ((QuestDataTaskLocation)other).visited;
        boolean all = true;
        for (int i = 0; i < visited.length; ++i) {
            if (otherVisited[i]) {
                visited[i] = true;
                continue;
            }
            if (visited[i]) continue;
            all = false;
        }
        if (all) {
            this.completeTask(uuid);
        }
    }

    @Override
    public void autoComplete(String uuid) {
        boolean[] visited = ((QuestDataTaskLocation)this.getData((String)uuid)).visited;
        for (int i = 0; i < visited.length; ++i) {
            visited[i] = true;
        }
    }

    @Override
    public void copyProgress(QuestDataTask own, QuestDataTask other) {
        super.copyProgress(own, other);
        boolean[] visited = ((QuestDataTaskLocation)own).visited;
        System.arraycopy(((QuestDataTaskLocation)other).visited, 0, visited, 0, visited.length);
    }

    @Override
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.side == Side.SERVER) {
            this.tick(null, false);
        }
    }

    @Override
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.side == Side.SERVER) {
            this.tick(event.player, true);
        }
    }

    public static class Location {
        private ItemStack iconStack = null;
        private String name = "New";
        private int x;
        private int y;
        private int z;
        private int radius = 3;
        private Visibility visible = Visibility.LOCATION;
        private int dimension;

        private Location copy() {
            Location location = new Location();
            location.iconStack = this.iconStack == null ? null : this.iconStack.func_77946_l();
            location.name = this.name;
            location.x = this.x;
            location.y = this.y;
            location.z = this.z;
            location.radius = this.radius;
            location.visible = this.visible;
            location.dimension = this.dimension;
            return location;
        }

        public ItemStack getIconStack() {
            return this.iconStack;
        }

        public void setIconStack(ItemStack iconStack) {
            this.iconStack = iconStack;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public int getX() {
            return this.x;
        }

        public void setX(int x) {
            this.x = x;
        }

        public int getY() {
            return this.y;
        }

        public void setY(int y) {
            this.y = y;
        }

        public int getZ() {
            return this.z;
        }

        public void setZ(int z) {
            this.z = z;
        }

        public int getRadius() {
            return this.radius;
        }

        public void setRadius(int radius) {
            this.radius = radius;
        }

        public Visibility getVisible() {
            return this.visible;
        }

        public void setVisible(Visibility visible) {
            this.visible = visible;
        }

        public int getDimension() {
            return this.dimension;
        }

        public void setDimension(int dimension) {
            this.dimension = dimension;
        }
    }

    public static enum Visibility {
        FULL("Full", true, true),
        LOCATION("Location", true, false),
        NONE("None", false, false);

        private boolean showCoordinate;
        private boolean showRadius;
        private String id;

        private Visibility(String id, boolean showCoordinate, boolean showRadius) {
            this.id = id;
            this.showCoordinate = showCoordinate;
            this.showRadius = showRadius;
        }

        public boolean doShowCoordinate() {
            return this.showCoordinate;
        }

        public boolean doShowRadius() {
            return this.showRadius;
        }

        public String getName() {
            return Translator.translate("hqm.locationMenu.vis" + this.id + ".title");
        }

        public String getDescription() {
            return Translator.translate("hqm.locationMenu.vis" + this.id + ".desc");
        }
    }
}

