/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.quests.task;

import hardcorequesting.client.interfaces.edit.GuiEditMenuItem;
import hardcorequesting.event.EventHandler;
import hardcorequesting.quests.Quest;
import hardcorequesting.quests.QuestingData;
import hardcorequesting.quests.data.QuestDataTaskItems;
import hardcorequesting.quests.task.QuestTaskItems;
import java.util.Arrays;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class QuestTaskItemsDetect
extends QuestTaskItems {
    public QuestTaskItemsDetect(Quest parent, String description, String longDescription) {
        super(parent, description, longDescription);
        this.register(EventHandler.Type.CRAFTING, EventHandler.Type.PICK_UP, EventHandler.Type.OPEN_BOOK);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected GuiEditMenuItem.Type getMenuTypeId() {
        return GuiEditMenuItem.Type.CRAFTING_TASK;
    }

    @Override
    protected void doCompletionCheck(QuestDataTaskItems data, String uuid) {
        boolean isDone = true;
        for (int i = 0; i < this.items.length; ++i) {
            QuestTaskItems.ItemRequirement item = this.items[i];
            if (item.required <= data.progress[i]) continue;
            data.progress[i] = 0;
            isDone = false;
        }
        if (isDone) {
            this.completeTask(uuid);
        }
        this.parent.sendUpdatedDataToTeam(uuid);
    }

    @Override
    public void onUpdate(EntityPlayer player) {
        this.countItems(player, null);
    }

    @Override
    public void onCrafting(PlayerEvent.ItemCraftedEvent event) {
        this.onCrafting(event.player, event.crafting, event.craftMatrix);
    }

    @Override
    public void onItemPickUp(EntityItemPickupEvent event) {
        if (event.getEntityPlayer().field_71071_by.field_70459_e) {
            this.countItems(event.getEntityPlayer(), event.getItem().func_92059_d());
        }
    }

    @Override
    public void onOpenBook(EventHandler.BookOpeningEvent event) {
        if (event.isRealName()) {
            this.countItems(event.getPlayer(), null);
        }
    }

    public void onCrafting(EntityPlayer player, ItemStack stack, IInventory craftMatrix) {
        if (player != null) {
            stack = stack.func_77946_l();
            if (stack.field_77994_a == 0) {
                stack.field_77994_a = 1;
            }
            this.countItems(player, stack);
        }
    }

    private void countItems(EntityPlayer player, ItemStack stack) {
        ItemStack[] items;
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        if (stack == null) {
            items = player.field_71071_by.field_70462_a;
        } else {
            items = new ItemStack[player.field_71071_by.field_70462_a.length + 1];
            ItemStack[] mainInventory = player.field_71071_by.field_70462_a;
            for (int i = 0; i < mainInventory.length; ++i) {
                items[i] = mainInventory[i];
            }
            items[items.length - 1] = stack;
        }
        this.countItems(items, (QuestDataTaskItems)this.getData(player), QuestingData.getUserUUID(player));
    }

    public void countItems(ItemStack[] itemsToCount, QuestDataTaskItems data, String uuid) {
        if (!this.parent.isAvailable(uuid)) {
            return;
        }
        boolean updated = false;
        if (data.progress.length < this.items.length) {
            data.progress = Arrays.copyOf(data.progress, this.items.length);
        }
        for (int i = 0; i < this.items.length; ++i) {
            QuestTaskItems.ItemRequirement item = this.items[i];
            if (!item.hasItem || item.required == data.progress[i]) continue;
            for (ItemStack stack : itemsToCount) {
                if (!item.getPrecision().areItemsSame(stack, item.getStack())) continue;
                int amount = Math.min(stack.field_77994_a, item.required - data.progress[i]);
                int n = i;
                data.progress[n] = data.progress[n] + amount;
                updated = true;
            }
        }
        if (updated) {
            this.doCompletionCheck(data, uuid);
        }
    }
}

