/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.quests.task;

import hardcorequesting.client.interfaces.edit.GuiEditMenuItem;
import hardcorequesting.quests.Quest;
import hardcorequesting.quests.QuestingData;
import hardcorequesting.quests.data.QuestDataTaskItems;
import hardcorequesting.quests.task.QuestTaskItems;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class QuestTaskItemsConsume
extends QuestTaskItems {
    public QuestTaskItemsConsume(Quest parent, String description, String longDescription) {
        super(parent, description, longDescription);
    }

    public boolean increaseFluid(FluidStack fluidStack, QuestDataTaskItems data, String uuid) {
        boolean updated = false;
        for (int i = 0; i < this.items.length; ++i) {
            QuestTaskItems.ItemRequirement item = this.items[i];
            if (item.fluid == null || item.required == data.progress[i] || fluidStack == null || !fluidStack.getFluid().getName().equals(item.fluid.getName())) continue;
            int amount = Math.min(item.required - data.progress[i], fluidStack.amount);
            int n = i;
            data.progress[n] = data.progress[n] + amount;
            fluidStack.amount -= amount;
            updated = true;
            break;
        }
        if (updated) {
            this.doCompletionCheck(data, uuid);
        }
        return updated;
    }

    @Override
    public void onUpdate(EntityPlayer player) {
        if (this.increaseItems(player.field_71071_by.field_70462_a, (QuestDataTaskItems)this.getData(player), QuestingData.getUserUUID(player))) {
            player.field_71071_by.func_70296_d();
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected GuiEditMenuItem.Type getMenuTypeId() {
        return GuiEditMenuItem.Type.CONSUME_TASK;
    }

    public boolean allowManual() {
        return true;
    }
}

