/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.quests.task;

import hardcorequesting.client.EditMode;
import hardcorequesting.client.interfaces.GuiBase;
import hardcorequesting.client.interfaces.GuiColor;
import hardcorequesting.client.interfaces.GuiQuestBook;
import hardcorequesting.client.interfaces.edit.GuiEditMenuItem;
import hardcorequesting.quests.ItemPrecision;
import hardcorequesting.quests.Quest;
import hardcorequesting.quests.QuestingData;
import hardcorequesting.quests.data.QuestDataTask;
import hardcorequesting.quests.data.QuestDataTaskItems;
import hardcorequesting.quests.task.QuestTask;
import hardcorequesting.util.SaveHelper;
import hardcorequesting.util.Translator;
import java.util.Arrays;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class QuestTaskItems
extends QuestTask {
    private static final int MAX_X = 300;
    private static final int OFFSET = 20;
    private static final int SIZE = 18;
    private static final int TEXT_HEIGHT = 9;
    ItemRequirement[] items;

    public QuestTaskItems(Quest parent, String description, String longDescription) {
        super(parent, description, longDescription);
        this.setItems(new ItemRequirement[0]);
    }

    public ItemRequirement[] getItems() {
        return this.items;
    }

    public void setItems(ItemRequirement[] items) {
        this.items = items;
        this.setPositions(this.items);
    }

    public void setItem(GuiEditMenuItem.Element element, int id, ItemPrecision precision) {
        if (element.getFluidStack() == null) {
            return;
        }
        if (id >= this.items.length) {
            this.items = this.getEditFriendlyItems(this.items);
            SaveHelper.add(SaveHelper.EditType.TASK_ITEM_CREATE);
        } else {
            SaveHelper.add(SaveHelper.EditType.TASK_ITEM_CHANGE);
        }
        if (id < this.items.length) {
            if (element instanceof GuiEditMenuItem.ElementItem) {
                GuiEditMenuItem.ElementItem item = (GuiEditMenuItem.ElementItem)element;
                this.items[id].hasItem = true;
                this.items[id].fluid = null;
                ItemStack stack = ((ItemStack)item.getFluidStack()).func_77946_l();
                stack.field_77994_a = 1;
                this.items[id].stack = stack;
            } else {
                GuiEditMenuItem.ElementFluid fluid = (GuiEditMenuItem.ElementFluid)element;
                this.items[id].hasItem = false;
                this.items[id].fluid = (Fluid)fluid.getFluidStack();
                this.items[id].stack = null;
            }
            this.items[id].required = element.getAmount();
            this.items[id].precision = precision;
            ItemRequirement.access$202(this.items[id], null);
        }
    }

    private int getProgress(EntityPlayer player, int id) {
        if (id >= this.items.length) {
            return 0;
        }
        QuestDataTaskItems data = (QuestDataTaskItems)this.getData(player);
        if (id >= data.progress.length) {
            data.progress = Arrays.copyOf(data.progress, data.progress.length + 1);
        }
        return data.progress[id];
    }

    protected void resetTask(String playerName, int id) {
        this.getData((String)playerName).completed = false;
        ((QuestDataTaskItems)this.getData((String)playerName)).progress[id] = 0;
    }

    protected void completeTask(String uuid, int id, int count) {
        QuestDataTaskItems data = (QuestDataTaskItems)this.getData(uuid);
        data.progress[id] = count;
        this.doCompletionCheck(data, uuid);
    }

    private void setPositions(ItemRequirement[] items) {
        int x = 180;
        int y = 95;
        for (ItemRequirement item : items) {
            item.x = x;
            item.y = y;
            if ((x += 20) <= 300) continue;
            x = 180;
            y += 20;
        }
    }

    private ItemRequirement[] getEditFriendlyItems(ItemRequirement[] items) {
        if (!Quest.isEditing) {
            return items;
        }
        items = Arrays.copyOf(items, items.length + 1);
        items[items.length - 1] = new ItemRequirement((ItemStack)null, 1);
        this.setPositions(items);
        return items;
    }

    @SideOnly(value=Side.CLIENT)
    protected abstract GuiEditMenuItem.Type getMenuTypeId();

    public boolean increaseItems(ItemStack[] itemsToConsume, QuestDataTaskItems data, String uuid) {
        if (!this.parent.isAvailable(uuid)) {
            return false;
        }
        boolean updated = false;
        for (int i = 0; i < this.items.length; ++i) {
            ItemRequirement item = this.items[i];
            if (i < data.progress.length) {
                if (!item.hasItem || item.required == data.progress[i]) {
                    continue;
                }
            } else {
                data.progress = Arrays.copyOf(data.progress, i);
            }
            for (int j = 0; j < itemsToConsume.length; ++j) {
                int amount;
                ItemStack stack = itemsToConsume[j];
                if (!item.precision.areItemsSame(stack, item.stack) || (amount = Math.min(stack.field_77994_a, item.required - data.progress[i])) <= 0) continue;
                stack.field_77994_a -= amount;
                if (stack.field_77994_a == 0) {
                    itemsToConsume[j] = null;
                }
                int n = i;
                data.progress[n] = data.progress[n] + amount;
                updated = true;
            }
        }
        if (updated) {
            this.doCompletionCheck(data, uuid);
        }
        return updated;
    }

    protected void doCompletionCheck(QuestDataTaskItems data, String uuid) {
        boolean isDone = true;
        for (int i = 0; i < this.items.length; ++i) {
            ItemRequirement item = this.items[i];
            if (item.required <= data.progress[i]) continue;
            isDone = false;
            break;
        }
        if (isDone) {
            this.completeTask(uuid);
        }
        this.parent.sendUpdatedDataToTeam(uuid);
    }

    @Override
    public Class<? extends QuestDataTask> getDataType() {
        return QuestDataTaskItems.class;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void draw(GuiQuestBook gui, EntityPlayer player, int mX, int mY) {
        String str;
        ItemRequirement item;
        int i;
        ItemRequirement[] items = this.getEditFriendlyItems(this.items);
        for (i = 0; i < items.length; ++i) {
            item = items[i];
            if (item.hasItem) {
                gui.drawItemStack(item.getPermutatedItem(), item.x, item.y, mX, mY, false);
            }
            str = this.getProgress(player, i) * 100 / item.required + "%";
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)200.0f);
            float textSize = 0.8f;
            gui.drawStringWithShadow(str, (int)((float)(item.x + 18) - (float)gui.getStringWidth(str) * textSize), (int)((float)(item.y + 18) - 9.0f * textSize + 2.0f), textSize, this.getProgress(player, i) == item.required ? 0x308030 : 0xFFFFFF);
            GlStateManager.func_179121_F();
        }
        for (i = 0; i < items.length; ++i) {
            item = items[i];
            if (!gui.inBounds(item.x, item.y, 18, 18, mX, mY)) continue;
            GuiQuestBook.setSelectedStack(item.getStack());
            str = "";
            if (this.getProgress(player, i) == item.required) {
                str = str + (Object)((Object)GuiColor.GREEN);
            }
            str = str + item.getDisplayName() + ": " + this.getProgress(player, i) + "/" + item.required;
            if (Quest.isEditing) {
                str = str + "\n" + (Object)((Object)GuiColor.GRAY) + item.getPrecision().getName();
            }
            if (gui.isOpBook && GuiScreen.func_146272_n()) {
                str = this.getProgress(player, i) == item.required ? str + "\n\n" + (Object)((Object)GuiColor.RED) + Translator.translate("hqm.questBook.resetTask") : str + "\n\n" + (Object)((Object)GuiColor.ORANGE) + Translator.translate("hqm.questBook.completeTask");
            }
            gui.drawMouseOver(str, mX + gui.getLeft(), mY + gui.getTop());
            break;
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onClick(GuiQuestBook gui, EntityPlayer player, int mX, int mY, int b) {
        boolean isOpBookWithShiftKeyDown;
        boolean bl = isOpBookWithShiftKeyDown = gui.isOpBook && GuiScreen.func_146272_n();
        if (Quest.isEditing || isOpBookWithShiftKeyDown) {
            ItemRequirement[] items = this.getEditFriendlyItems(this.items);
            for (int i = 0; i < items.length; ++i) {
                ItemRequirement item = items[i];
                if (!gui.inBounds(item.x, item.y, 18, 18, mX, mY)) continue;
                if (isOpBookWithShiftKeyDown) {
                    if (this.getProgress(player, i) == item.required) {
                        this.resetTask(QuestingData.getUserUUID(player), i);
                        break;
                    }
                    this.completeTask(QuestingData.getUserUUID(player), i, item.required);
                    break;
                }
                if (Quest.isEditing && gui.getCurrentMode() == EditMode.ITEM) {
                    gui.setEditMenu(new GuiEditMenuItem((GuiBase)gui, player, item.hasItem ? (item.stack != null ? item.stack.func_77946_l() : null) : item.fluid, i, this.getMenuTypeId(), item.required, item.precision));
                    break;
                }
                if (!Quest.isEditing || gui.getCurrentMode() != EditMode.DELETE || item.stack == null && item.fluid == null) break;
                ItemRequirement[] newItems = new ItemRequirement[this.items.length - 1];
                int id = 0;
                for (int j = 0; j < this.items.length; ++j) {
                    if (j == i) continue;
                    newItems[id] = this.items[j];
                    ++id;
                }
                this.setItems(newItems);
                SaveHelper.add(SaveHelper.EditType.TASK_ITEM_REMOVE);
                break;
            }
        }
    }

    @Override
    public float getCompletedRatio(String uuid) {
        QuestDataTaskItems data = (QuestDataTaskItems)this.getData(uuid);
        int done = 0;
        int total = 0;
        for (int count : data.progress) {
            done += count;
        }
        for (ItemRequirement item : this.items) {
            total += item.required;
        }
        return Math.max(0.0f, Math.min(1.0f, (float)done / (float)total));
    }

    @Override
    public void mergeProgress(String uuid, QuestDataTask own, QuestDataTask other) {
        int[] ownProgress = ((QuestDataTaskItems)own).progress;
        int[] otherProgress = ((QuestDataTaskItems)other).progress;
        boolean completed = true;
        for (int i = 0; i < ownProgress.length; ++i) {
            ownProgress[i] = Math.max(ownProgress[i], otherProgress[i]);
            if (ownProgress[i] == this.items[i].required) continue;
            completed = false;
        }
        if (completed) {
            this.completeTask(uuid);
        }
    }

    @Override
    public void autoComplete(String uuid) {
        QuestDataTaskItems data = (QuestDataTaskItems)this.getData(uuid);
        for (int i = 0; i < this.items.length; ++i) {
            data.progress[i] = this.items[i].required;
        }
    }

    @Override
    public void copyProgress(QuestDataTask own, QuestDataTask other) {
        super.copyProgress(own, other);
        int[] ownProgress = ((QuestDataTaskItems)own).progress;
        int[] otherProgress = ((QuestDataTaskItems)other).progress;
        System.arraycopy(otherProgress, 0, ownProgress, 0, ownProgress.length);
    }

    public static class ItemRequirement {
        private static int CYCLE_TIME = 2;
        public Fluid fluid;
        public int required;
        public boolean hasItem;
        private ItemStack stack;
        private ItemPrecision precision = ItemPrecision.PRECISE;
        private ItemStack[] permutations;
        private int cycleAt = -1;
        private int current = 0;
        private int last;
        private int x;
        private int y;

        public ItemRequirement(ItemStack stack, int required) {
            this.stack = stack;
            this.required = required;
            this.hasItem = true;
        }

        public ItemRequirement(Fluid fluid, int required) {
            this.fluid = fluid;
            this.required = required;
            this.hasItem = false;
        }

        public ItemPrecision getPrecision() {
            return this.precision;
        }

        public void setPrecision(ItemPrecision precision) {
            this.precision = precision;
            this.permutations = null;
        }

        public ItemStack getStack() {
            return this.stack;
        }

        public void setStack(ItemStack stack) {
            this.stack = stack;
            this.permutations = null;
        }

        private void setPermutations() {
            if (this.stack == null) {
                return;
            }
            this.permutations = this.precision.getPermutations(this.stack);
            if (this.permutations != null && this.permutations.length > 0) {
                this.last = this.permutations.length - 1;
                this.cycleAt = -1;
            }
        }

        public ItemStack getPermutatedItem() {
            if (this.permutations == null && this.precision.hasPermutations()) {
                this.setPermutations();
            }
            if (this.permutations == null || this.permutations.length < 2) {
                return this.stack != null ? this.stack : null;
            }
            int ticks = (int)(System.currentTimeMillis() / 1000L);
            if (this.cycleAt == -1) {
                this.cycleAt = ticks + CYCLE_TIME;
            }
            if (ticks >= this.cycleAt) {
                if (++this.current > this.last) {
                    this.current = 0;
                }
                while (ticks >= this.cycleAt) {
                    this.cycleAt += CYCLE_TIME;
                }
            }
            return this.permutations[this.current];
        }

        public String getDisplayName() {
            ItemStack stack = this.getPermutatedItem();
            if (this.hasItem) {
                if (stack != null) {
                    return stack.func_82833_r();
                }
                return "Nothing";
            }
            return this.fluid.getLocalizedName(null);
        }

        static /* synthetic */ ItemStack[] access$202(ItemRequirement x0, ItemStack[] x1) {
            x0.permutations = x1;
            return x1;
        }
    }
}

