/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.quests.task;

import hardcorequesting.client.interfaces.GuiColor;
import hardcorequesting.client.interfaces.GuiQuestBook;
import hardcorequesting.event.EventHandler;
import hardcorequesting.quests.Quest;
import hardcorequesting.quests.data.QuestDataTask;
import hardcorequesting.quests.data.QuestDataTaskDeath;
import hardcorequesting.quests.task.QuestTask;
import hardcorequesting.util.Translator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class QuestTaskDeath
extends QuestTask {
    private int deaths;

    public QuestTaskDeath(Quest parent, String description, String longDescription) {
        super(parent, description, longDescription);
        this.register(EventHandler.Type.DEATH);
    }

    @Override
    public Class<? extends QuestDataTask> getDataType() {
        return QuestDataTaskDeath.class;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void draw(GuiQuestBook gui, EntityPlayer player, int mX, int mY) {
        int died = ((QuestDataTaskDeath)this.getData((EntityPlayer)player)).deaths;
        gui.drawString(gui.getLinesFromText(died == this.deaths ? (Object)((Object)GuiColor.GREEN) + Translator.translate(this.deaths != 0, "hqm.deathMenu.deaths", this.deaths) : Translator.translate(this.deaths != 0, "hqm.deathMenu.deathsOutOf", died, this.deaths), 1.0f, 130), 180, 95, 1.0f, 0x404040);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onClick(GuiQuestBook gui, EntityPlayer player, int mX, int mY, int b) {
    }

    @Override
    public void onUpdate(EntityPlayer player) {
    }

    @Override
    public float getCompletedRatio(String uuid) {
        return (float)((QuestDataTaskDeath)this.getData((String)uuid)).deaths / (float)this.deaths;
    }

    @Override
    public void mergeProgress(String uuid, QuestDataTask own, QuestDataTask other) {
        ((QuestDataTaskDeath)own).deaths = Math.max(((QuestDataTaskDeath)own).deaths, ((QuestDataTaskDeath)other).deaths);
        if (((QuestDataTaskDeath)own).deaths == this.deaths) {
            this.completeTask(uuid);
        }
    }

    @Override
    public void autoComplete(String uuid) {
        this.deaths = ((QuestDataTaskDeath)this.getData((String)uuid)).deaths;
    }

    @Override
    public void copyProgress(QuestDataTask own, QuestDataTask other) {
        super.copyProgress(own, other);
        ((QuestDataTaskDeath)own).deaths = ((QuestDataTaskDeath)other).deaths;
    }

    @Override
    public void onLivingDeath(LivingDeathEvent event) {
        EntityPlayer player;
        if (event.getEntityLiving() instanceof EntityPlayerMP && this.parent.isEnabled(player = (EntityPlayer)event.getEntityLiving()) && this.parent.isAvailable(player) && this.isVisible(player) && !this.isCompleted(player)) {
            QuestDataTaskDeath deathData = (QuestDataTaskDeath)this.getData(player);
            if (deathData.deaths < this.deaths) {
                ++deathData.deaths;
                if (deathData.deaths == this.deaths) {
                    this.completeTask(player.func_110124_au());
                }
                this.parent.sendUpdatedDataToTeam(player);
            }
        }
    }

    public int getDeaths() {
        return this.deaths;
    }

    public void setDeaths(int deaths) {
        this.deaths = deaths;
    }
}

