/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.quests.task;

import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import hardcorequesting.client.ClientChange;
import hardcorequesting.client.interfaces.GuiBase;
import hardcorequesting.client.interfaces.GuiQuestBook;
import hardcorequesting.client.sounds.Sounds;
import hardcorequesting.event.EventHandler;
import hardcorequesting.io.adapter.QuestTaskAdapter;
import hardcorequesting.network.NetworkManager;
import hardcorequesting.quests.Quest;
import hardcorequesting.quests.QuestData;
import hardcorequesting.quests.QuestingData;
import hardcorequesting.quests.RepeatType;
import hardcorequesting.quests.data.QuestDataTask;
import hardcorequesting.team.RewardSetting;
import hardcorequesting.team.TeamStats;
import hardcorequesting.util.Translator;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class QuestTask {
    static final int START_X = 180;
    static final int START_Y = 95;
    public String description;
    protected Quest parent;
    private List<QuestTask> requirements;
    private String longDescription;
    private int id;
    private List<String> cachedDescription;

    public QuestTask(Quest parent, String description, String longDescription) {
        this.parent = parent;
        this.requirements = new ArrayList<QuestTask>();
        this.description = description;
        this.longDescription = longDescription;
        this.updateId();
    }

    public static void completeQuest(Quest quest, String playerUuid) {
        EntityPlayer player;
        if (!quest.isEnabled(playerUuid) || !quest.isAvailable(playerUuid)) {
            return;
        }
        for (QuestTask questTask : quest.getTasks()) {
            if (questTask.getData((String)playerUuid).completed) continue;
            return;
        }
        QuestData data = quest.getQuestData(playerUuid);
        data.completed = true;
        data.claimed = false;
        data.available = false;
        data.time = Quest.serverTicker.getHours();
        if (QuestingData.getQuestingData(playerUuid).getTeam().getRewardSetting() == RewardSetting.RANDOM) {
            int rewardId = (int)(Math.random() * (double)data.reward.length);
            data.reward[rewardId] = true;
        } else {
            for (int i = 0; i < data.reward.length; ++i) {
                data.reward[i] = true;
            }
        }
        quest.sendUpdatedDataToTeam(playerUuid);
        TeamStats.refreshTeam(QuestingData.getQuestingData(playerUuid).getTeam());
        for (Quest child : quest.getReversedRequirement()) {
            QuestTask.completeQuest(child, playerUuid);
            child.sendUpdatedDataToTeam(playerUuid);
        }
        if (quest.getRepeatInfo().getType() == RepeatType.INSTANT) {
            quest.reset(playerUuid);
        }
        if ((player = QuestingData.getPlayer(playerUuid)) instanceof EntityPlayerMP && !quest.hasReward(player)) {
            NetworkManager.sendToPlayer(ClientChange.SOUND.build((Object)Sounds.COMPLETE), (EntityPlayerMP)player);
        }
    }

    public void updateId() {
        this.id = this.parent.nextTaskId++;
    }

    public boolean isCompleted(EntityPlayer player) {
        return this.getData((EntityPlayer)player).completed;
    }

    public boolean isCompleted(String uuid) {
        return this.getData((String)uuid).completed;
    }

    public boolean isVisible(EntityPlayer player) {
        QuestTask requirement;
        Iterator<QuestTask> itr = this.requirements.iterator();
        do {
            if (itr.hasNext()) continue;
            return true;
        } while ((requirement = itr.next()).isCompleted(player) && requirement.isVisible(player));
        return false;
    }

    public Class<? extends QuestDataTask> getDataType() {
        return QuestDataTask.class;
    }

    public void write(QuestDataTask task, JsonWriter out) throws IOException {
        task.write(out);
    }

    public void read(QuestDataTask task, JsonReader in) throws IOException {
        task.update((QuestDataTask)QuestTaskAdapter.QUEST_DATA_TASK_ADAPTER.read(in));
    }

    public QuestDataTask getData(EntityPlayer player) {
        return this.getData(QuestingData.getUserUUID(player));
    }

    public QuestDataTask getData(String uuid) {
        if (this.id < 0) {
            return this.newQuestData();
        }
        QuestData questData = QuestingData.getQuestingData(uuid).getQuestData(this.parent.getId());
        if (this.id >= questData.tasks.length) {
            questData.tasks = Arrays.copyOf(questData.tasks, this.id + 1);
            questData.tasks[this.id] = this.newQuestData();
        }
        questData.tasks[this.id] = this.validateData(questData.tasks[this.id]);
        return questData.tasks[this.id];
    }

    public QuestDataTask validateData(QuestDataTask data) {
        if (data == null || data.getClass() != this.getDataType()) {
            return this.newQuestData();
        }
        return data;
    }

    private QuestDataTask newQuestData() {
        try {
            Constructor<? extends QuestDataTask> constructor = this.getDataType().getConstructor(QuestTask.class);
            QuestDataTask obj = constructor.newInstance(this);
            return obj;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public String getLangKeyDescription() {
        return this.description;
    }

    public String getDescription() {
        return Translator.translate(this.description);
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getLangKeyLongDescription() {
        return this.longDescription;
    }

    public String getLongDescription() {
        return Translator.translate(this.longDescription);
    }

    public void setLongDescription(String longDescription) {
        this.longDescription = longDescription;
        this.cachedDescription = null;
    }

    @SideOnly(value=Side.CLIENT)
    public List<String> getCachedLongDescription(GuiBase gui) {
        if (this.cachedDescription == null) {
            this.cachedDescription = gui.getLinesFromText(Translator.translate(this.longDescription), 0.7f, 130);
        }
        return this.cachedDescription;
    }

    public void completeTask(UUID uuid) {
        this.completeTask(uuid.toString());
    }

    public void completeTask(String playerName) {
        this.getData((String)playerName).completed = true;
        QuestTask.completeQuest(this.parent, playerName);
    }

    @SideOnly(value=Side.CLIENT)
    public abstract void draw(GuiQuestBook var1, EntityPlayer var2, int var3, int var4);

    @SideOnly(value=Side.CLIENT)
    public abstract void onClick(GuiQuestBook var1, EntityPlayer var2, int var3, int var4, int var5);

    public abstract void onUpdate(EntityPlayer var1);

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public Quest getParent() {
        return this.parent;
    }

    public List<QuestTask> getRequirements() {
        return this.requirements;
    }

    public void addRequirement(QuestTask task) {
        this.requirements.add(task);
    }

    public void clearRequirements() {
        this.requirements.clear();
    }

    public abstract float getCompletedRatio(String var1);

    public abstract void mergeProgress(String var1, QuestDataTask var2, QuestDataTask var3);

    public abstract void autoComplete(String var1);

    public void copyProgress(QuestDataTask own, QuestDataTask other) {
        own.completed = other.completed;
    }

    public void onDelete() {
        EventHandler.instance().remove(this);
    }

    public void register(EventHandler.Type ... types) {
        EventHandler.instance().add(this, types);
    }

    public void onServerTick(TickEvent.ServerTickEvent event) {
    }

    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
    }

    public void onLivingDeath(LivingDeathEvent event) {
    }

    public void onCrafting(PlayerEvent.ItemCraftedEvent event) {
    }

    public void onItemPickUp(EntityItemPickupEvent event) {
    }

    public void onOpenBook(EventHandler.BookOpeningEvent event) {
    }

    public void onReputationChange(EventHandler.ReputationEvent event) {
    }
}

