/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.quests.data;

import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import hardcorequesting.io.adapter.QuestTaskAdapter;
import hardcorequesting.quests.data.QuestDataTask;
import hardcorequesting.quests.task.QuestTask;
import hardcorequesting.quests.task.QuestTaskLocation;
import java.io.IOException;

public class QuestDataTaskLocation
extends QuestDataTask {
    private static final String COUNT = "count";
    private static final String VISITED = "visited";
    public boolean[] visited;

    public QuestDataTaskLocation(QuestTask task) {
        super(task);
        this.visited = new boolean[((QuestTaskLocation)task).locations.length];
    }

    protected QuestDataTaskLocation() {
        this.visited = new boolean[0];
    }

    public static QuestDataTask construct(JsonReader in) {
        QuestDataTaskLocation taskData = new QuestDataTaskLocation();
        try {
            int count = 0;
            while (in.hasNext()) {
                switch (in.nextName()) {
                    case "completed": {
                        taskData.completed = in.nextBoolean();
                        break;
                    }
                    case "count": {
                        count = in.nextInt();
                        taskData.visited = new boolean[count];
                        break;
                    }
                    case "visited": {
                        in.beginArray();
                        for (int i = 0; i < count; ++i) {
                            taskData.visited[i] = in.nextBoolean();
                        }
                        in.endArray();
                        break;
                    }
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return taskData;
    }

    @Override
    public QuestTaskAdapter.QuestDataType getDataType() {
        return QuestTaskAdapter.QuestDataType.LOCATION;
    }

    @Override
    public void write(JsonWriter out) throws IOException {
        super.write(out);
        out.name(COUNT).value((long)this.visited.length);
        out.name(VISITED).beginArray();
        for (boolean i : this.visited) {
            out.value(i);
        }
        out.endArray();
    }

    @Override
    public void update(QuestDataTask taskData) {
        super.update(taskData);
        this.visited = ((QuestDataTaskLocation)taskData).visited;
    }
}

