/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.quests.data;

import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import hardcorequesting.io.adapter.QuestTaskAdapter;
import hardcorequesting.quests.data.QuestDataTask;
import hardcorequesting.quests.task.QuestTask;
import hardcorequesting.quests.task.QuestTaskItems;
import java.io.IOException;

public class QuestDataTaskItems
extends QuestDataTask {
    private static final String COUNT = "count";
    private static final String PROGRESS = "progress";
    public int[] progress;

    public QuestDataTaskItems(QuestTask task) {
        super(task);
        this.progress = new int[((QuestTaskItems)task).getItems().length];
    }

    protected QuestDataTaskItems() {
        this.progress = new int[0];
    }

    public static QuestDataTask construct(JsonReader in) {
        QuestDataTaskItems taskData = new QuestDataTaskItems();
        try {
            int count = 0;
            while (in.hasNext()) {
                switch (in.nextName()) {
                    case "completed": {
                        taskData.completed = in.nextBoolean();
                        break;
                    }
                    case "count": {
                        count = in.nextInt();
                        taskData.progress = new int[count];
                        break;
                    }
                    case "progress": {
                        in.beginArray();
                        for (int i = 0; i < count; ++i) {
                            taskData.progress[i] = in.nextInt();
                        }
                        in.endArray();
                        break;
                    }
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return taskData;
    }

    @Override
    public QuestTaskAdapter.QuestDataType getDataType() {
        return QuestTaskAdapter.QuestDataType.ITEMS;
    }

    @Override
    public void write(JsonWriter out) throws IOException {
        super.write(out);
        out.name(COUNT).value((long)this.progress.length);
        out.name(PROGRESS).beginArray();
        for (int i : this.progress) {
            out.value((long)i);
        }
        out.endArray();
    }

    @Override
    public void update(QuestDataTask taskData) {
        super.update(taskData);
        this.progress = ((QuestDataTaskItems)taskData).progress;
    }
}

