/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.quests;

import com.mojang.authlib.GameProfile;
import hardcorequesting.bag.Group;
import hardcorequesting.bag.GroupData;
import hardcorequesting.client.sounds.SoundHandler;
import hardcorequesting.client.sounds.Sounds;
import hardcorequesting.config.ModConfig;
import hardcorequesting.death.DeathStats;
import hardcorequesting.io.SaveHandler;
import hardcorequesting.items.ModItems;
import hardcorequesting.network.NetworkManager;
import hardcorequesting.network.message.LivesUpdate;
import hardcorequesting.quests.Quest;
import hardcorequesting.quests.QuestData;
import hardcorequesting.team.PlayerEntry;
import hardcorequesting.team.Team;
import hardcorequesting.team.TeamStats;
import hardcorequesting.team.TeamUpdateSize;
import hardcorequesting.util.Translator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.UserListBansEntry;
import net.minecraft.server.management.UserListEntry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import org.apache.logging.log4j.Level;

public class QuestingData {
    public static int defaultLives;
    public static boolean autoHardcoreActivate;
    public static boolean autoQuestActivate;
    private static boolean hardcoreActive;
    private static boolean questActive;
    private static HashMap<String, QuestingData> data;
    private static List<Team> teams;
    public String selectedQuest = null;
    public int selectedTask = -1;
    public boolean playedLore;
    public boolean receivedBook;
    private Team team;
    private int lives;
    private String uuid;
    private String name;
    private Map<String, GroupData> groupData;
    private DeathStats deathStat;

    private QuestingData(String uuid) {
        this.lives = defaultLives;
        this.uuid = uuid;
        this.team = new Team(uuid);
        this.createGroupData();
        this.deathStat = new DeathStats(uuid);
        data.put(uuid, this);
    }

    public QuestingData(String uuid, int lives, int teamId, Map<String, GroupData> groupData, DeathStats deathStat) {
        this.uuid = uuid;
        this.lives = lives;
        if (teamId > -1 && teamId < QuestingData.getTeams().size()) {
            this.team = QuestingData.getTeams().get(teamId);
        }
        if (this.team == null) {
            this.team = new Team(uuid);
        }
        this.createGroupData();
        this.groupData.putAll(groupData);
        this.deathStat = deathStat == null ? new DeathStats(uuid) : deathStat;
        data.put(uuid, this);
    }

    public static HashMap<String, QuestingData> getData() {
        return data;
    }

    public static boolean isSinglePlayer() {
        return FMLCommonHandler.instance().getMinecraftServerInstance().func_71264_H();
    }

    public static boolean isHardcoreActive() {
        return hardcoreActive;
    }

    public static boolean isQuestActive() {
        return questActive;
    }

    public static void activateHardcore() {
        if (!hardcoreActive && !FMLCommonHandler.instance().getMinecraftServerInstance().func_130014_f_().func_72912_H().func_76093_s()) {
            hardcoreActive = true;
        }
    }

    public static void disableHardcore() {
        hardcoreActive = false;
    }

    public static void activateQuest(boolean giveBooks) {
        if (!questActive) {
            questActive = true;
            if (giveBooks) {
                for (GameProfile profile : FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_152600_g()) {
                    EntityPlayerMP player;
                    if (profile == null || (player = FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_177451_a(profile.getId())) == null) continue;
                    QuestingData.spawnBook((EntityPlayer)player);
                }
            }
        }
    }

    public static void deactivate() {
        if (hardcoreActive || questActive) {
            hardcoreActive = false;
            questActive = false;
            data = new HashMap();
            teams = new ArrayList<Team>();
        }
    }

    public static void saveState() {
        try {
            SaveHandler.saveQuestingState(SaveHandler.getLocalFile("state"));
        }
        catch (IOException e) {
            FMLLog.log((String)"HQM", (Level)Level.INFO, (String)"Failed to save questing state", (Object[])new Object[0]);
        }
    }

    public static void loadState(boolean remote) {
        try {
            SaveHandler.loadQuestingState(SaveHandler.getFile("state", remote));
        }
        catch (IOException e) {
            FMLLog.log((String)"HQM", (Level)Level.INFO, (String)"Failed to load questing state", (Object[])new Object[0]);
        }
    }

    public static void saveQuestingData() {
        try {
            SaveHandler.saveQuestingData(SaveHandler.getLocalFile("data"));
        }
        catch (IOException e) {
            FMLLog.log((String)"HQM", (Level)Level.INFO, (String)"Failed to save questing data", (Object[])new Object[0]);
        }
    }

    public static String saveQuestingData(EntityPlayer entity) {
        return SaveHandler.saveQuestingData(QuestingData.getQuestingData(entity));
    }

    public static void loadQuestingData(boolean remote) {
        try {
            data.clear();
            SaveHandler.loadQuestingData(SaveHandler.getFile("data", remote)).forEach(qData -> data.put(qData.getUuid(), (QuestingData)qData));
        }
        catch (IOException e) {
            FMLLog.log((String)"HQM", (Level)Level.INFO, (String)"Failed to load questing data", (Object[])new Object[0]);
        }
    }

    public static List<Team> getTeams() {
        return teams;
    }

    public static List<Team> getAllTeams() {
        ArrayList<Team> all = new ArrayList<Team>();
        all.addAll(QuestingData.getTeams());
        data.values().stream().filter(questingData -> questingData.getTeam().isSingle()).forEach(player -> all.add(player.getTeam()));
        return all;
    }

    public static QuestingData getQuestingData(EntityPlayer player) {
        return QuestingData.getQuestingData(QuestingData.getUserUUID(player));
    }

    public static String getUserUUID(EntityPlayer player) {
        return player.getPersistentID().toString();
    }

    public static QuestingData getQuestingData(String uuid) {
        if (!data.containsKey(uuid)) {
            new QuestingData(uuid);
        }
        return data.get(uuid);
    }

    public static void disableVanillaHardcore(ICommandSender sender) {
        if (sender.func_184102_h().func_130014_f_().func_72912_H().func_76093_s()) {
            sender.func_145747_a((ITextComponent)new TextComponentTranslation("hqm.message.vanillaHardcore", new Object[0]));
            try {
                ReflectionHelper.setPrivateValue(WorldInfo.class, (Object)sender.func_130014_f_().func_72912_H(), (Object)false, (int)20);
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
            if (!sender.func_184102_h().func_130014_f_().func_72912_H().func_76093_s()) {
                sender.func_145747_a((ITextComponent)new TextComponentTranslation("hqm.message.vanillaHardcoreOverride", new Object[0]));
            }
        }
    }

    public static void spawnBook(EntityPlayer player) {
        if (!Quest.isEditing && !player.field_70170_p.field_72995_K && ModConfig.spawnBook && !QuestingData.getQuestingData((EntityPlayer)player).receivedBook && QuestingData.isQuestActive()) {
            QuestingData.getQuestingData((EntityPlayer)player).receivedBook = true;
            NBTTagCompound hqmTag = new NBTTagCompound();
            if (player.getEntityData().func_74764_b("HardcoreQuesting")) {
                hqmTag = player.getEntityData().func_74775_l("HardcoreQuesting");
            }
            hqmTag.func_74757_a("questBook", true);
            player.getEntityData().func_74782_a("HardcoreQuesting", (NBTBase)hqmTag);
            ItemStack stack = new ItemStack((Item)ModItems.book);
            if (!player.field_71071_by.func_70441_a(stack)) {
                QuestingData.spawnItemAtPlayer(player, stack);
            }
        }
    }

    private static void spawnItemAtPlayer(EntityPlayer player, ItemStack stack) {
        EntityItem item = new EntityItem(player.field_70170_p, player.field_70165_t + 0.5, player.field_70163_u + 0.5, player.field_70161_v + 0.5, stack);
        player.field_70170_p.func_72838_d((Entity)item);
        if (!(player instanceof FakePlayer)) {
            item.func_70100_b_(player);
        }
    }

    public static void addTeam(Team team) {
        team.setId(teams.size());
        teams.add(team);
    }

    public static EntityPlayer getPlayerFromUsername(String playerName) {
        return FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_152612_a(playerName);
    }

    public static EntityPlayer getPlayer(String uuid) {
        if (uuid.split("-").length == 5) {
            return QuestingData.getPlayer(UUID.fromString(uuid));
        }
        return QuestingData.getPlayerFromUsername(uuid);
    }

    public static EntityPlayer getPlayer(UUID uuid) {
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        return server == null ? null : server.func_184103_al().func_177451_a(uuid);
    }

    public static void remove(EntityPlayer player) {
        data.remove(QuestingData.getUserUUID(player));
    }

    public static boolean hasData(EntityPlayer player) {
        return data.containsKey(player.func_146103_bH().getId().toString());
    }

    public static boolean hasData(UUID uuid) {
        return data.containsKey(uuid.toString());
    }

    public static boolean hasData(String uuid) {
        return data.containsKey(uuid);
    }

    public DeathStats getDeathStat() {
        return this.deathStat;
    }

    public String getUuid() {
        return this.uuid;
    }

    public String getName() {
        if (this.name == null) {
            try {
                EntityPlayer player = QuestingData.getPlayer(this.uuid);
                this.name = player != null ? player.getDisplayNameString() : "";
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
                return this.uuid != null ? this.uuid : "";
            }
        }
        return this.name;
    }

    private void createGroupData() {
        this.groupData = new HashMap<String, GroupData>();
        Group.getGroups().keySet().forEach(this::createGroupData);
    }

    private void createGroupData(String id) {
        this.groupData.put(id, new GroupData());
    }

    public int getLives() {
        boolean shareLives = this.getTeam().isSharingLives();
        return shareLives ? this.getTeam().getSharedLives() : this.getRawLives();
    }

    public int getLivesToStayAlive() {
        boolean shareLives = this.getTeam().isSharingLives();
        return shareLives ? this.getTeam().getPlayerCount() : 1;
    }

    public int getRawLives() {
        return this.lives;
    }

    public void setRawLives(int lives) {
        this.lives = lives;
    }

    public QuestData getQuestData(String id) {
        return this.getTeam().getQuestData(id);
    }

    public void setQuestData(String id, QuestData data) {
        this.getTeam().setQuestData(id, data);
    }

    public GroupData getGroupData(String id) {
        if (!this.groupData.containsKey(id)) {
            this.createGroupData(id);
        }
        return this.groupData.get(id);
    }

    public int addLives(EntityPlayer player, int amount) {
        int max = ModConfig.MAXLIVES;
        int i = this.getRawLives() + amount;
        this.lives = i <= max ? i : max;
        this.getTeam().refreshTeamLives();
        return this.lives;
    }

    public void removeLifeAndSendMessage(EntityPlayer player) {
        boolean isDead;
        boolean bl = isDead = !this.removeLives(player, 1);
        if (!isDead) {
            player.func_146105_b((ITextComponent)new TextComponentString(Translator.translate(this.getLives() != 1, "hqm.message.lostLife", this.getLives())));
        }
        if (this.getTeam().isSharingLives()) {
            for (PlayerEntry entry : this.getTeam().getPlayers()) {
                EntityPlayer other;
                if (!entry.isInTeam() || entry.getUUID().equals(QuestingData.getUserUUID(player)) || (other = QuestingData.getPlayer(entry.getUUID())) == null) continue;
                other.func_146105_b((ITextComponent)new TextComponentString(Translator.translate(this.getLives() != 1, "hqm.message.lostTeamLife", QuestingData.getUserUUID(player), isDead ? " " + Translator.translate("hqm.message.andBanned") : "", this.getLives())));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeLives(EntityPlayer player, int amount) {
        boolean shareLives = this.getTeam().isSharingLives();
        if (shareLives) {
            int dif = Math.min(this.lives - 1, amount);
            amount -= dif;
            this.lives -= dif;
            block4: while (amount > 0) {
                int players = 0;
                for (PlayerEntry entry : QuestingData.getQuestingData(player).getTeam().getPlayers()) {
                    if (entry.getUUID().equals(QuestingData.getUserUUID(player)) || QuestingData.getQuestingData(entry.getUUID()).getRawLives() <= 1) continue;
                    ++players;
                }
                if (players == 0) break;
                int id = (int)(Math.random() * (double)players);
                for (PlayerEntry entry : QuestingData.getQuestingData(player).getTeam().getPlayers()) {
                    if (entry.getUUID().equals(QuestingData.getUserUUID(player)) || QuestingData.getQuestingData(entry.getUUID()).getRawLives() <= 1) continue;
                    if (id == 0) {
                        --QuestingData.getQuestingData((String)entry.getUUID()).lives;
                        --amount;
                        continue block4;
                    }
                    --id;
                }
            }
            this.lives -= amount;
        } else {
            this.lives = this.getRawLives() - amount;
        }
        if (player instanceof EntityPlayerMP) {
            NetworkManager.sendToPlayer(new LivesUpdate(this.uuid, this.lives), (EntityPlayerMP)player);
        }
        this.getTeam().refreshTeamLives();
        try {
            boolean bl;
            if (this.getLives() < this.getLivesToStayAlive()) {
                this.outOfLives(player);
                bl = false;
                return bl;
            }
            bl = true;
            return bl;
        }
        finally {
            TeamStats.refreshTeam(this.team);
        }
    }

    public void die(EntityPlayer player) {
        if (!QuestingData.isHardcoreActive()) {
            return;
        }
        this.removeLifeAndSendMessage(player);
    }

    private void outOfLives(EntityPlayer playerEntity) {
        QuestingData data = QuestingData.getQuestingData(playerEntity);
        Team team = data.getTeam();
        if (!team.isSingle() && !teams.isEmpty()) {
            team.removePlayer(QuestingData.getUserUUID(playerEntity));
            if (team.getPlayerCount() == 0) {
                team.deleteTeam();
            } else {
                team.refreshTeamData(TeamUpdateSize.ALL);
            }
        }
        playerEntity.field_71071_by.func_174888_l();
        MinecraftServer mcServer = playerEntity.func_184102_h();
        if (mcServer.func_71264_H() && playerEntity.func_70005_c_().equals(mcServer.func_71214_G())) {
            ((EntityPlayerMP)playerEntity).field_71135_a.func_147360_c(Translator.translate("hqm.message.gameOver"));
        } else {
            String setBanReason = "Out of lives in Hardcore Questing mode";
            String setBannedBy = "HQM";
            UserListBansEntry userlistbansentry = new UserListBansEntry(playerEntity.func_146103_bH(), (Date)null, setBannedBy, (Date)null, setBanReason);
            mcServer.func_184103_al().func_152608_h().func_152687_a((UserListEntry)userlistbansentry);
            ((EntityPlayerMP)playerEntity).field_71135_a.func_147360_c(Translator.translate("hqm.message.gameOver"));
            SoundHandler.playToAll(Sounds.DEATH);
        }
    }

    public Team getTeam() {
        if (!this.team.isSingle() && !QuestingData.getTeams().isEmpty()) {
            this.team = QuestingData.getTeams().get(this.team.getId());
        }
        return this.team;
    }

    public void setTeam(Team team) {
        if (team == null) {
            team = new Team(this.uuid);
        }
        this.team = team;
    }

    public Map<String, GroupData> getGroupData() {
        return this.groupData;
    }

    static {
        data = new HashMap();
        teams = new ArrayList<Team>();
    }
}

