/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.quests;

import hardcorequesting.quests.Quest;
import hardcorequesting.quests.RepeatType;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class QuestTicker {
    private int hours;
    private int ticks;

    public QuestTicker(boolean isClient) {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void tick(TickEvent.ServerTickEvent event) {
        this.tick(false);
    }

    @SubscribeEvent
    public void tick(TickEvent.ClientTickEvent event) {
        this.tick(true);
    }

    public void tick(boolean isClient) {
        if (++this.ticks == 1000) {
            this.ticks = 0;
            ++this.hours;
            if (!isClient) {
                for (Quest quest : Quest.getQuests().values()) {
                    int total = quest.getRepeatInfo().getDays() * 24 + quest.getRepeatInfo().getHours();
                    if (quest.getRepeatInfo().getType() == RepeatType.INTERVAL) {
                        if (total == 0 || this.hours % total != 0) continue;
                        quest.resetAll();
                        continue;
                    }
                    if (quest.getRepeatInfo().getType() != RepeatType.TIME) continue;
                    quest.resetOnTime(this.hours - total);
                }
            }
        }
    }

    public int getHours() {
        return this.hours;
    }
}

