/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.quests;

import hardcorequesting.client.EditMode;
import hardcorequesting.client.interfaces.GuiBase;
import hardcorequesting.client.interfaces.GuiColor;
import hardcorequesting.client.interfaces.GuiQuestBook;
import hardcorequesting.client.interfaces.ResourceHelper;
import hardcorequesting.client.interfaces.ScrollBar;
import hardcorequesting.client.interfaces.edit.GuiEditMenuItem;
import hardcorequesting.client.interfaces.edit.GuiEditMenuParentCount;
import hardcorequesting.client.interfaces.edit.GuiEditMenuRepeat;
import hardcorequesting.client.interfaces.edit.GuiEditMenuTextEditor;
import hardcorequesting.client.interfaces.edit.GuiEditMenuTrigger;
import hardcorequesting.io.SaveHandler;
import hardcorequesting.io.adapter.QuestAdapter;
import hardcorequesting.quests.ItemPrecision;
import hardcorequesting.quests.Quest;
import hardcorequesting.quests.task.QuestTask;
import hardcorequesting.reputation.ReputationBar;
import hardcorequesting.util.OPBookHelper;
import hardcorequesting.util.SaveHelper;
import hardcorequesting.util.Translator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.Level;
import org.lwjgl.input.Keyboard;

public class QuestSet {
    private static final int LINE_2_X = 10;
    private static final int LINE_2_Y = 12;
    private static final int INFO_Y = 100;
    private String name;
    private String description;
    private List<String> cachedDescription;
    private Map<String, Quest> quests;
    private List<ReputationBar> reputationBars;
    private int id;

    public QuestSet(String name, String description) {
        this.name = name;
        this.description = description;
        this.quests = new HashMap<String, Quest>();
        this.reputationBars = new ArrayList<ReputationBar>();
        this.id = Quest.getQuestSets().size();
    }

    public static void loadAll(boolean remote) {
        try {
            SaveHandler.loadAllQuestSets(SaveHandler.getFolder(remote));
            QuestAdapter.postLoad();
            QuestSet.orderAll(remote);
        }
        catch (IOException e) {
            FMLLog.log((String)"HQM", (Level)Level.INFO, (String)"Failed loading quest sets", (Object[])new Object[0]);
        }
    }

    public static void saveAll() {
        try {
            SaveHandler.saveAllQuestSets(SaveHandler.getLocalFolder());
        }
        catch (IOException e) {
            FMLLog.log((String)"HQM", (Level)Level.INFO, (String)"Failed saving quest sets", (Object[])new Object[0]);
        }
    }

    public static void saveAllDefault() {
        try {
            SaveHandler.saveAllQuestSets(SaveHandler.getDefaultFolder());
        }
        catch (IOException e) {
            FMLLog.log((String)"HQM", (Level)Level.INFO, (String)"Failed saving quest sets", (Object[])new Object[0]);
        }
    }

    public static void orderAll(boolean remote) {
        try {
            final List<String> order = SaveHandler.loadQuestSetOrder(SaveHandler.getFile("sets", remote));
            if (!order.isEmpty()) {
                Quest.getQuestSets().sort(new Comparator<QuestSet>(){

                    @Override
                    public int compare(QuestSet s1, QuestSet s2) {
                        if (s1.equals(s2)) {
                            return 0;
                        }
                        int is1 = order.indexOf(s1.getName());
                        int is2 = order.indexOf(s2.getName());
                        if (is1 == -1) {
                            return is2 == -1 ? s1.getName().compareTo(s2.getName()) : 1;
                        }
                        if (is2 == -1) {
                            return -1;
                        }
                        if (is1 == is2) {
                            return 0;
                        }
                        return is1 < is2 ? -1 : 1;
                    }
                });
            }
        }
        catch (IOException e) {
            FMLLog.log((String)"HQM", (Level)Level.INFO, (String)"Failed ordering quest sets", (Object[])new Object[0]);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void drawOverview(GuiQuestBook gui, ScrollBar setScroll, ScrollBar descriptionScroll, int x, int y) {
        EntityPlayer player = gui.getPlayer();
        List<QuestSet> questSets = Quest.getQuestSets();
        int start = setScroll.isVisible(gui) ? Math.round((float)(Quest.getQuestSets().size() - 7) * setScroll.getScroll()) : 0;
        HashMap<Quest, Boolean> isVisibleCache = new HashMap<Quest, Boolean>();
        HashMap<Quest, Boolean> isLinkFreeCache = new HashMap<Quest, Boolean>();
        for (int i = start; i < Math.min(start + 7, questSets.size()); ++i) {
            QuestSet questSet = questSets.get(i);
            int setY = 20 + (i - start) * 29;
            int total = questSet.getQuests().size();
            boolean enabled = questSet.isEnabled(player, isVisibleCache, isLinkFreeCache);
            int completedCount = enabled ? questSet.getCompletedCount(player, isVisibleCache, isLinkFreeCache) : 0;
            boolean completed = true;
            int unclaimed = 0;
            for (Quest quest : questSet.getQuests().values()) {
                if (completed && !quest.isCompleted(player) && quest.isLinkFree(player, isLinkFreeCache)) {
                    completed = false;
                }
                if (!quest.isCompleted(player) || !quest.hasReward(player)) continue;
                ++unclaimed;
            }
            boolean selected = questSet == GuiQuestBook.selectedSet;
            boolean inBounds = gui.inBounds(25, setY, gui.getStringWidth(questSet.getName(i)), 9, x, y);
            int color = gui.modifyingQuestSet == questSet ? 0x4040DD : (enabled ? (completed ? (selected ? (inBounds ? 0x40BB40 : 0x40A040) : (inBounds ? 0x10A010 : 0x107010)) : (selected ? (inBounds ? 0xAAAAAA : 0x888888) : (inBounds ? 0x666666 : 0x404040))) : 0xDDDDDD);
            gui.drawString(questSet.getName(i), 25, setY, color);
            String info = enabled ? (completed ? Translator.translate("hqm.questBook.allQuests") : Translator.translate("hqm.questBook.percentageQuests", completedCount * 100 / total)) : Translator.translate("hqm.questBook.locked");
            gui.drawString(info, 35, setY + 12, 0.7f, color);
            if (!enabled || unclaimed == 0) continue;
            String toClaim = GuiColor.PURPLE.toString() + Translator.translate(unclaimed != 1, "hqm.questBook.unclaimedRewards", unclaimed);
            gui.drawString(toClaim, 35, setY + 12 + 8, 0.7f, -1);
        }
        if (Quest.isEditing && gui.getCurrentMode() == EditMode.CREATE) {
            gui.drawString(gui.getLinesFromText(Translator.translate("hqm.questBook.createNewSet"), 0.7f, 130), 180, 20, 0.7f, 0x404040);
        } else {
            if (GuiQuestBook.selectedSet != null) {
                int startLine = descriptionScroll.isVisible(gui) ? Math.round((float)(GuiQuestBook.selectedSet.getDescription(gui).size() - 7) * descriptionScroll.getScroll()) : 0;
                gui.drawString(GuiQuestBook.selectedSet.getDescription(gui), startLine, 7, 180, 20, 0.7f, 0x404040);
            }
            QuestSet.drawQuestInfo(gui, GuiQuestBook.selectedSet, 180, GuiQuestBook.selectedSet == null ? 20 : 100, isVisibleCache, isLinkFreeCache);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void drawQuestInfo(GuiQuestBook gui, QuestSet set, int x, int y) {
        QuestSet.drawQuestInfo(gui, set, x, y, new HashMap<Quest, Boolean>(), new HashMap<Quest, Boolean>());
    }

    @SideOnly(value=Side.CLIENT)
    private static void drawQuestInfo(GuiQuestBook gui, QuestSet set, int x, int y, HashMap<Quest, Boolean> isVisibleCache, HashMap<Quest, Boolean> isLinkFreeCache) {
        int completed = 0;
        int reward = 0;
        int enabled = 0;
        int total = 0;
        int realTotal = 0;
        EntityPlayer player = gui.getPlayer();
        for (Quest quest : Quest.getQuests().values()) {
            if (set != null && !quest.hasSet(set)) continue;
            ++realTotal;
            if (!quest.isVisible(player, isVisibleCache, isLinkFreeCache)) continue;
            ++total;
            if (!quest.isEnabled(player, isVisibleCache, isLinkFreeCache)) continue;
            ++enabled;
            if (!quest.isCompleted(player)) continue;
            ++completed;
            if (!quest.hasReward(player)) continue;
            ++reward;
        }
        ArrayList<String> info = new ArrayList<String>();
        info.add(GuiColor.GRAY.toString() + Translator.translate(total != 1, "hqm.questBook.totalQuests", total));
        info.add(GuiColor.CYAN.toString() + Translator.translate(enabled != 1, "hqm.questBook.unlockedQuests", enabled));
        info.add(GuiColor.GREEN.toString() + Translator.translate(completed != 1, "hqm.questBook.completedQuests", completed));
        info.add(GuiColor.LIGHT_BLUE.toString() + Translator.translate(enabled - completed != 1, "hqm.questBook.totalQuests", enabled - completed));
        if (reward > 0) {
            info.add(GuiColor.PURPLE.toString() + Translator.translate(reward != 1, "hqm.questBook.unclaimedQuests", reward));
        }
        if (Quest.isEditing && !GuiScreen.func_146271_m()) {
            info.add(GuiColor.LIGHT_GRAY.toString() + Translator.translate(realTotal != 1, "hqm.questBook.inclInvisiQuests", realTotal));
        }
        gui.drawString(info, x, y, 0.7f, 0x404040);
    }

    @SideOnly(value=Side.CLIENT)
    public static void mouseClickedOverview(GuiQuestBook gui, ScrollBar setScroll, int x, int y) {
        List<QuestSet> questSets = Quest.getQuestSets();
        int start = setScroll.isVisible(gui) ? Math.round((float)(Quest.getQuestSets().size() - 7) * setScroll.getScroll()) : 0;
        HashMap<Quest, Boolean> isVisibleCache = new HashMap<Quest, Boolean>();
        HashMap<Quest, Boolean> isLinkFreeCache = new HashMap<Quest, Boolean>();
        block6: for (int i = start; i < Math.min(start + 7, questSets.size()); ++i) {
            int setY = 20 + (i - start) * 29;
            QuestSet questSet = questSets.get(i);
            if (!gui.inBounds(25, setY, gui.getStringWidth(questSet.getName(i)), 9, x, y)) continue;
            switch (gui.getCurrentMode()) {
                case DELETE: {
                    if (!questSet.getQuests().isEmpty()) break block6;
                    for (int j = questSet.getId() + 1; j < Quest.getQuestSets().size(); ++j) {
                        Quest.getQuestSets().get(j).decreaseId();
                    }
                    Quest.getQuestSets().remove(questSet);
                    SaveHelper.add(SaveHelper.EditType.SET_REMOVE);
                    break;
                }
                case SWAP_SELECT: {
                    gui.modifyingQuestSet = gui.modifyingQuestSet == questSet ? null : questSet;
                    break;
                }
                case RENAME: {
                    gui.setEditMenu(new GuiEditMenuTextEditor(gui, gui.getPlayer(), questSet, true));
                    break;
                }
                default: {
                    if (Quest.isEditing) break block6;
                    if (!questSet.isEnabled(gui.getPlayer(), isVisibleCache, isLinkFreeCache)) break;
                }
                case NORMAL: {
                    GuiQuestBook.selectedSet = GuiQuestBook.selectedSet == questSet ? null : questSet;
                    break;
                }
            }
            break;
        }
        if (Quest.isEditing && gui.getCurrentMode() == EditMode.RENAME && gui.inBounds(180, 20, 130, 44, x, y)) {
            gui.setEditMenu(new GuiEditMenuTextEditor(gui, gui.getPlayer(), GuiQuestBook.selectedSet, false));
        }
    }

    public Map<String, Quest> getQuests() {
        return this.quests;
    }

    public List<ReputationBar> getReputationBars() {
        this.validateBars();
        return this.reputationBars;
    }

    private void validateBars() {
        ArrayList<ReputationBar> toRemove = new ArrayList<ReputationBar>();
        for (ReputationBar reputationBar : this.reputationBars) {
            if (reputationBar.isValid()) continue;
            toRemove.add(reputationBar);
        }
        this.reputationBars.removeAll(toRemove);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getFilename() {
        return this.name.replaceAll(" ", "_");
    }

    public String getName(int i) {
        return i + 1 + ". " + this.name;
    }

    @SideOnly(value=Side.CLIENT)
    public List<String> getDescription(GuiBase gui) {
        if (this.cachedDescription == null) {
            this.cachedDescription = gui.getLinesFromText(this.description, 0.7f, 130);
        }
        return this.cachedDescription;
    }

    public boolean isEnabled(EntityPlayer player) {
        return this.isEnabled(player, new HashMap<Quest, Boolean>(), new HashMap<Quest, Boolean>());
    }

    private boolean isEnabled(EntityPlayer player, Map<Quest, Boolean> isVisibleCache, Map<Quest, Boolean> isLinkFreeCache) {
        if (this.quests.isEmpty()) {
            return false;
        }
        for (Quest quest : this.quests.values()) {
            if (!quest.isEnabled(player, isVisibleCache, isLinkFreeCache)) continue;
            return true;
        }
        return false;
    }

    public boolean isCompleted(EntityPlayer player) {
        if (this.quests.isEmpty()) {
            return false;
        }
        for (Quest quest : this.quests.values()) {
            if (quest.isCompleted(player)) continue;
            return false;
        }
        return true;
    }

    public void removeQuest(Quest quest) {
        this.quests.remove(quest.getId());
    }

    public void addQuest(Quest quest) {
        this.quests.put(quest.getId(), quest);
    }

    public void removeRepBar(ReputationBar repBar) {
        this.reputationBars.remove(repBar);
    }

    public void addRepBar(ReputationBar repBar) {
        if (repBar == null) {
            return;
        }
        repBar.setQuestSet(this.id);
        this.reputationBars.add(repBar);
    }

    public int getCompletedCount(EntityPlayer player) {
        return this.getCompletedCount(player, new HashMap<Quest, Boolean>(), new HashMap<Quest, Boolean>());
    }

    private int getCompletedCount(EntityPlayer player, Map<Quest, Boolean> isVisibleCache, Map<Quest, Boolean> isLinkFreeCache) {
        int count = 0;
        for (Quest quest : this.quests.values()) {
            if (!quest.isCompleted(player) || !quest.isEnabled(player, isVisibleCache, isLinkFreeCache)) continue;
            ++count;
        }
        return count;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
        this.cachedDescription = null;
    }

    public int getId() {
        return this.id;
    }

    public void decreaseId() {
        --this.id;
        for (ReputationBar reputationBar : this.reputationBars) {
            reputationBar.setQuestSet(this.id);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void draw(GuiQuestBook gui, int x0, int y0, int x, int y) {
        int color;
        if (gui.isOpBook) {
            gui.drawString(gui.getLinesFromText(Translator.translate("hqm.questBook.shiftSetReset"), 0.7f, 130), 184, 192, 0.7f, 0x707070);
        }
        EntityPlayer player = gui.getPlayer();
        for (ReputationBar bar : this.getReputationBars()) {
            bar.draw(gui, x, y, player);
        }
        HashMap<Quest, Boolean> isVisibleCache = new HashMap<Quest, Boolean>();
        HashMap<Quest, Boolean> isLinkFreeCache = new HashMap<Quest, Boolean>();
        for (Quest child : this.getQuests().values()) {
            if (!Quest.isEditing && !child.isVisible(player, isVisibleCache, isLinkFreeCache)) continue;
            for (Quest parent : child.getRequirements()) {
                if (!Quest.isEditing && !parent.isVisible(player, isVisibleCache, isLinkFreeCache) || !parent.hasSameSetAs(child)) continue;
                color = Quest.isEditing && (!child.isVisible(player, isVisibleCache, isLinkFreeCache) || !parent.isVisible(player, isVisibleCache, isLinkFreeCache)) ? 0x55404040 : -12566464;
                gui.drawLine(gui.getLeft() + parent.getGuiCenterX(), gui.getTop() + parent.getGuiCenterY(), gui.getLeft() + child.getGuiCenterX(), gui.getTop() + child.getGuiCenterY(), 5, color);
            }
        }
        if (Quest.isEditing) {
            for (Quest child : this.getQuests().values()) {
                for (Quest parent : child.getOptionLinks()) {
                    if (!parent.hasSameSetAs(child)) continue;
                    color = !child.isVisible(player, isVisibleCache, isLinkFreeCache) || !parent.isVisible(player, isVisibleCache, isLinkFreeCache) ? 1430274269 : -12566307;
                    gui.drawLine(gui.getLeft() + parent.getGuiCenterX(), gui.getTop() + parent.getGuiCenterY(), gui.getLeft() + child.getGuiCenterX(), gui.getTop() + child.getGuiCenterY(), 5, color);
                }
            }
        }
        for (Quest quest : this.getQuests().values()) {
            if (!Quest.isEditing && !quest.isVisible(player, isVisibleCache, isLinkFreeCache)) continue;
            GlStateManager.func_179094_E();
            GlStateManager.func_179147_l();
            GlStateManager.func_179112_b((int)770, (int)771);
            gui.applyColor(quest == gui.modifyingQuest ? -4456517 : quest.getColorFilter(player, gui.getTick()));
            ResourceHelper.bindResource(GuiBase.MAP_TEXTURE);
            gui.drawRect(quest.getGuiX(), quest.getGuiY(), quest.getGuiU(), quest.getGuiV(player, x, y), quest.getGuiW(), quest.getGuiH());
            int iconX = quest.getGuiCenterX() - 8;
            int iconY = quest.getGuiCenterY() - 8;
            if (quest.useBigIcon()) {
                ++iconX;
                ++iconY;
            }
            gui.drawItemStack(quest.getIconStack(), iconX, iconY, true);
            GlStateManager.func_179121_F();
        }
        for (Quest quest : this.getQuests().values()) {
            boolean editing;
            boolean bl = editing = Quest.isEditing && !GuiScreen.func_146271_m();
            if (!editing && !quest.isVisible(player, isVisibleCache, isLinkFreeCache) || !quest.isMouseInObject(x, y)) continue;
            boolean shouldDrawText = false;
            boolean enabled = quest.isEnabled(player, isVisibleCache, isLinkFreeCache);
            String txt = "";
            if (enabled || editing) {
                txt = txt + quest.getName();
            }
            if (!enabled) {
                if (editing) {
                    txt = txt + "\n";
                }
                txt = txt + (Object)((Object)GuiColor.GRAY) + Translator.translate("hqm.questBook.lockedQuest");
            }
            if (!enabled || editing) {
                int allowedUncompleted;
                int totalParentCount = 0;
                int totalCompletedCount = 0;
                int parentCount = 0;
                int completed = 0;
                ArrayList<Quest> externalQuests = new ArrayList<Quest>();
                for (Quest quest2 : quest.getRequirements()) {
                    ++totalParentCount;
                    boolean isCompleted = quest2.isCompleted(player);
                    if (isCompleted) {
                        ++totalCompletedCount;
                    }
                    if (quest2.hasSameSetAs(quest)) continue;
                    externalQuests.add(quest2);
                    ++parentCount;
                    if (!isCompleted) continue;
                    ++completed;
                }
                if (editing && totalParentCount > 0) {
                    txt = txt + "\n" + (Object)((Object)GuiColor.GRAY) + Translator.translate(totalParentCount != 1, "hqm.questBook.parentCount", totalParentCount - totalCompletedCount, totalParentCount);
                    if (Keyboard.isKeyDown((int)19)) {
                        txt = txt + " [" + Translator.translate("hqm.questBook.holding", "R") + "]";
                        for (Quest quest3 : quest.getRequirements()) {
                            txt = txt + "\n" + (Object)((Object)GuiColor.GRAY) + quest3.getName();
                            if (!quest3.isCompleted(player)) continue;
                            txt = txt + " " + (Object)((Object)GuiColor.WHITE) + " [" + Translator.translate("hqm.questBook.completed") + "]";
                        }
                    } else {
                        txt = txt + " [" + Translator.translate("hqm.questBook.hold", "R") + "]";
                    }
                }
                int n = allowedUncompleted = quest.getUseModifiedParentRequirement() ? Math.max(0, quest.getRequirements().size() - quest.getParentRequirementCount()) : 0;
                if (parentCount - completed > allowedUncompleted || editing && parentCount > 0) {
                    txt = txt + "\n" + (Object)((Object)GuiColor.PINK) + Translator.translate(totalParentCount != 1, "hqm.questBook.parentCountElsewhere", totalParentCount - totalCompletedCount, totalParentCount);
                    shouldDrawText = true;
                    if (editing) {
                        if (Keyboard.isKeyDown((int)18)) {
                            txt = txt + " [" + Translator.translate("hqm.questBook.holding", "E") + "]";
                            for (Quest parent : externalQuests) {
                                txt = txt + "\n" + (Object)((Object)GuiColor.PINK) + parent.getName() + " (" + parent.getQuestSet().getName() + ")";
                                if (!parent.isCompleted(player)) continue;
                                txt = txt + " " + (Object)((Object)GuiColor.WHITE) + " [" + Translator.translate("hqm.questBook.completed") + "]";
                            }
                        } else {
                            txt = txt + " [" + Translator.translate("hqm.questBook.hold", "E") + "]";
                        }
                    }
                }
                if (editing && quest.getUseModifiedParentRequirement()) {
                    txt = txt + "\n" + (Object)((Object)GuiColor.MAGENTA);
                    int n2 = quest.getParentRequirementCount();
                    txt = n2 < quest.getRequirements().size() ? txt + Translator.translate(n2 != 1, "hqm.questBook.reqOnly", n2) : (n2 > quest.getRequirements().size() ? txt + Translator.translate(n2 != 1, "hqm.questBook.reqMore", n2) : txt + Translator.translate(n2 != 1, "hqm.questBook.reqAll", n2));
                }
            }
            if (enabled || editing) {
                String repeatMessage;
                if (quest.isCompleted(player)) {
                    txt = txt + "\n" + (Object)((Object)GuiColor.GREEN) + Translator.translate("hqm.questBook.completed");
                }
                if (quest.hasReward(player)) {
                    txt = txt + "\n" + (Object)((Object)GuiColor.PURPLE) + Translator.translate("hqm.questBook.unclaimedReward");
                }
                String string = repeatMessage = enabled ? quest.getRepeatInfo().getMessage(quest, player) : quest.getRepeatInfo().getShortMessage();
                if (repeatMessage != null) {
                    txt = txt + "\n" + repeatMessage;
                }
                if (editing) {
                    int totalTasks = 0;
                    int completedTasks = 0;
                    for (QuestTask task : quest.getTasks()) {
                        ++totalTasks;
                        if (!task.isCompleted(player)) continue;
                        ++completedTasks;
                    }
                    if (totalTasks == 0) {
                        txt = txt + "\n" + (Object)((Object)GuiColor.RED) + Translator.translate("hqm.questBook.noTasks");
                    } else {
                        txt = txt + "\n" + (Object)((Object)GuiColor.CYAN) + Translator.translate("hqm.questBook.completedTasks", completedTasks, totalTasks);
                        if (Keyboard.isKeyDown((int)20)) {
                            txt = txt + " [" + Translator.translate("hqm.questBook.holding", "T") + "]";
                            for (QuestTask task : quest.getTasks()) {
                                txt = txt + "\n" + (Object)((Object)GuiColor.CYAN) + task.getDescription();
                                if (!task.isCompleted(player)) continue;
                                txt = txt + (Object)((Object)GuiColor.WHITE) + " [" + Translator.translate("hqm.questBook.completed") + "]";
                            }
                        } else {
                            txt = txt + " [" + Translator.translate("hqm.questBook.holding", "T") + "]";
                        }
                    }
                    String triggerMessage = quest.getTriggerType().getMessage(quest);
                    if (triggerMessage != null) {
                        txt = txt + "\n" + triggerMessage;
                    }
                    if (!quest.isVisible(player, isVisibleCache, isLinkFreeCache)) {
                        String invisibilityMessage;
                        if (quest.isLinkFree(player, isLinkFreeCache)) {
                            boolean parentInvisible = false;
                            for (Quest parent : quest.getRequirements()) {
                                if (parent.isVisible(player, isVisibleCache, isLinkFreeCache)) continue;
                                parentInvisible = true;
                                break;
                            }
                            switch (quest.getTriggerType()) {
                                case ANTI_TRIGGER: {
                                    invisibilityMessage = Translator.translate("hqm.questBook.invisLocked");
                                    break;
                                }
                                case QUEST_TRIGGER: {
                                    invisibilityMessage = Translator.translate("hqm.questBook.invisPerm");
                                    parentInvisible = false;
                                    break;
                                }
                                case TASK_TRIGGER: {
                                    invisibilityMessage = Translator.translate(quest.getTriggerTasks() != 1, "hqm.questBook.invisCount", quest.getTriggerTasks());
                                    break;
                                }
                                default: {
                                    invisibilityMessage = null;
                                }
                            }
                            if (parentInvisible) {
                                String string2 = Translator.translate("hqm.questBook.invisInherit");
                                invisibilityMessage = invisibilityMessage == null ? string2 : string2 + " " + Translator.translate("hqm.questBook.and") + " " + invisibilityMessage;
                            }
                        } else {
                            invisibilityMessage = Translator.translate("hqm.questBook.invisOption");
                        }
                        if (invisibilityMessage != null) {
                            txt = txt + "\n" + (Object)((Object)GuiColor.LIGHT_BLUE) + invisibilityMessage;
                        }
                    }
                    ArrayList<String> ids = new ArrayList<String>();
                    for (Quest quest4 : quest.getOptionLinks()) {
                        ids.add(quest4.getId());
                    }
                    for (Quest quest5 : quest.getReversedOptionLinks()) {
                        String id = quest5.getId();
                        if (ids.contains(id)) continue;
                        ids.add(id);
                    }
                    int optionLinks = ids.size();
                    if (optionLinks > 0) {
                        txt = txt + "\n" + (Object)((Object)GuiColor.BLUE) + Translator.translate(optionLinks != 1, "hqm.questBook.optionLinks", optionLinks);
                        if (Keyboard.isKeyDown((int)24)) {
                            txt = txt + " [" + Translator.translate("hqm.questBook.holding", "O") + "]";
                            for (String id : ids) {
                                Quest option = Quest.getQuest(id);
                                txt = txt + "\n" + (Object)((Object)GuiColor.BLUE) + option.getName();
                                if (option.hasSameSetAs(quest)) continue;
                                txt = txt + " (" + option.getQuestSet().getName() + ")";
                            }
                        } else {
                            txt = txt + " [" + Translator.translate("hqm.questBook.hold", "O") + "]";
                        }
                    }
                }
                ArrayList<Quest> externalQuests = new ArrayList<Quest>();
                int childCount = 0;
                for (Quest child : quest.getReversedRequirement()) {
                    if (quest.hasSameSetAs(child)) continue;
                    ++childCount;
                    externalQuests.add(child);
                }
                if (childCount > 0) {
                    txt = txt + "\n" + (Object)((Object)GuiColor.PINK) + Translator.translate(childCount != 1, "hqm.questBook.childUnlocks", childCount);
                    if (editing) {
                        if (Keyboard.isKeyDown((int)22)) {
                            txt = txt + " [" + Translator.translate("hqm.questBook.holding", "U") + "]";
                            for (Quest child : externalQuests) {
                                txt = txt + "\n" + (Object)((Object)GuiColor.PINK) + child.getName() + " (" + child.getQuestSet().getName() + ")";
                            }
                        } else {
                            txt = txt + " [" + Translator.translate("hqm.questBook.hold", "U") + "]";
                        }
                    }
                }
                shouldDrawText = true;
            }
            if (editing) {
                txt = txt + "\n\n" + (Object)((Object)GuiColor.GRAY) + Translator.translate("hqm.questBook.ctrlNonEditor");
            }
            if (gui.isOpBook && GuiScreen.func_146272_n()) {
                txt = quest.isCompleted(player) ? txt + "\n\n" + (Object)((Object)GuiColor.RED) + Translator.translate("hqm.questBook.resetQuest") : txt + "\n\n" + (Object)((Object)GuiColor.ORANGE) + Translator.translate("hqm.questBook.completeQuest");
            }
            if (!shouldDrawText) break;
            gui.drawMouseOver(txt, x0, y0);
            break;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void mouseClicked(GuiQuestBook gui, int x, int y) {
        block30: {
            EntityPlayer player;
            block29: {
                player = gui.getPlayer();
                if (!Quest.isEditing || gui.getCurrentMode() != EditMode.CREATE && gui.getCurrentMode() != EditMode.REP_BAR_CREATE) break block29;
                switch (gui.getCurrentMode()) {
                    case CREATE: {
                        if (x > 0) {
                            Quest newQuest = new Quest("Unnamed", "Unnamed quest", 0, 0, false);
                            newQuest.setGuiCenterX(x);
                            newQuest.setGuiCenterY(y);
                            newQuest.setQuestSet(this);
                            SaveHelper.add(SaveHelper.EditType.QUEST_CREATE);
                            break;
                        }
                        break block30;
                    }
                    case REP_BAR_CREATE: {
                        gui.setEditMenu(new ReputationBar.EditGui(gui, player, x, y, this.getId()));
                        break;
                    }
                }
                break block30;
            }
            HashMap<Quest, Boolean> isVisibleCache = new HashMap<Quest, Boolean>();
            HashMap<Quest, Boolean> isLinkFreeCache = new HashMap<Quest, Boolean>();
            block17: for (Quest quest : this.getQuests().values()) {
                if (!Quest.isEditing && !quest.isVisible(player, isVisibleCache, isLinkFreeCache) || !quest.isMouseInObject(x, y)) continue;
                if (Quest.isEditing && gui.getCurrentMode() != EditMode.NORMAL) {
                    switch (gui.getCurrentMode()) {
                        case MOVE: {
                            gui.modifyingQuest = quest;
                            SaveHelper.add(SaveHelper.EditType.QUEST_MOVE);
                            break;
                        }
                        case REQUIREMENT: {
                            if (gui.modifyingQuest == quest) {
                                if (GuiScreen.func_146272_n()) {
                                    gui.modifyingQuest.clearRequirements();
                                }
                                gui.modifyingQuest = null;
                                break;
                            }
                            if (gui.modifyingQuest == null) {
                                gui.modifyingQuest = quest;
                                break;
                            }
                            gui.modifyingQuest.addRequirement(quest.getId());
                            break;
                        }
                        case SIZE: {
                            int cX = quest.getGuiCenterX();
                            int cY = quest.getGuiCenterY();
                            quest.setBigIcon(!quest.useBigIcon());
                            quest.setGuiCenterX(cX);
                            quest.setGuiCenterY(cY);
                            SaveHelper.add(SaveHelper.EditType.QUEST_SIZE_CHANGE);
                            break;
                        }
                        case ITEM: {
                            gui.setEditMenu(new GuiEditMenuItem((GuiBase)gui, player, (Object)quest.getIconStack(), quest.getId(), GuiEditMenuItem.Type.QUEST_ICON, 1, ItemPrecision.PRECISE));
                            break;
                        }
                        case DELETE: {
                            Quest.removeQuest(quest);
                            SaveHelper.add(SaveHelper.EditType.QUEST_REMOVE);
                            break;
                        }
                        case SWAP: {
                            if (gui.modifyingQuestSet == null || gui.modifyingQuestSet == this) break block17;
                            quest.setQuestSet(gui.modifyingQuestSet);
                            SaveHelper.add(SaveHelper.EditType.QUEST_CHANGE_SET);
                            break;
                        }
                        case REPEATABLE: {
                            gui.setEditMenu(new GuiEditMenuRepeat(gui, player, quest));
                            break;
                        }
                        case REQUIRED_PARENTS: {
                            gui.setEditMenu(new GuiEditMenuParentCount((GuiBase)gui, player, quest));
                            break;
                        }
                        case QUEST_SELECTION: {
                            Quest.selectedQuestId = quest.getId();
                            break;
                        }
                        case QUEST_OPTION: {
                            if (gui.modifyingQuest == quest) {
                                if (GuiScreen.func_146272_n()) {
                                    gui.modifyingQuest.clearOptionLinks();
                                }
                                gui.modifyingQuest = null;
                                break;
                            }
                            if (gui.modifyingQuest == null) {
                                gui.modifyingQuest = quest;
                                break;
                            }
                            gui.modifyingQuest.addOptionLink(quest.getId());
                            break;
                        }
                        case TRIGGER: {
                            gui.setEditMenu(new GuiEditMenuTrigger(gui, player, quest));
                            break;
                        }
                    }
                    break;
                }
                if (gui.isOpBook && GuiScreen.func_146272_n()) {
                    OPBookHelper.reverseQuestCompletion(quest, player);
                    break;
                }
                GuiQuestBook.selectedQuest = quest;
                quest.onOpen(gui, player);
                break;
            }
        }
        if (Quest.isEditing) {
            for (ReputationBar reputationBar : new ArrayList<ReputationBar>(this.getReputationBars())) {
                reputationBar.mouseClicked(gui, x, y);
            }
        }
    }
}

