/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.quests;

import hardcorequesting.HardcoreQuesting;
import hardcorequesting.bag.Group;
import hardcorequesting.bag.GroupTier;
import hardcorequesting.client.interfaces.GuiQuestBook;
import hardcorequesting.client.interfaces.edit.GuiEditMenuItem;
import hardcorequesting.client.sounds.SoundHandler;
import hardcorequesting.death.DeathStats;
import hardcorequesting.io.SaveHandler;
import hardcorequesting.network.NetworkManager;
import hardcorequesting.network.message.DeathStatsMessage;
import hardcorequesting.network.message.PlayerDataSyncMessage;
import hardcorequesting.network.message.QuestLineSyncMessage;
import hardcorequesting.quests.Quest;
import hardcorequesting.quests.QuestSet;
import hardcorequesting.quests.QuestingData;
import hardcorequesting.reputation.Reputation;
import hardcorequesting.team.Team;
import hardcorequesting.util.SaveHelper;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.Level;

public class QuestLine {
    public static boolean doServerSync;
    private static QuestLine config;
    private static QuestLine server;
    private static QuestLine world;
    private static boolean hasLoadedMainSound;
    public final List<GroupTier> tiers = new ArrayList<GroupTier>();
    public final Map<String, Group> groups = new ConcurrentHashMap<String, Group>();
    public List<QuestSet> questSets;
    public Map<String, Quest> quests;
    public String mainDescription = "No description";
    public List<String> cachedMainDescription;
    public String mainPath;
    @SideOnly(value=Side.CLIENT)
    public ResourceLocation front;

    public QuestLine() {
        GroupTier.initBaseTiers(this);
    }

    public static QuestLine getActiveQuestLine() {
        return server != null ? server : (world != null ? world : config);
    }

    public static void receiveServerSync(boolean local, boolean remote) {
        if (!hasLoadedMainSound) {
            SoundHandler.loadLoreReading(QuestLine.config.mainPath);
            hasLoadedMainSound = true;
        }
        GuiQuestBook.resetBookPosition();
        if (!local) {
            QuestLine.reset();
            server = new QuestLine();
            QuestLine.server.mainPath = QuestLine.config.mainPath;
            QuestLine.server.quests = new ConcurrentHashMap<String, Quest>();
            QuestLine.server.questSets = new ArrayList<QuestSet>();
        }
        QuestLine.loadAll(true, remote);
        SoundHandler.loadLoreReading(QuestLine.getActiveQuestLine().mainPath);
    }

    public static void reset() {
        server = null;
        world = null;
        SaveHandler.clearRemoteFolder();
    }

    public static void sendServerSync(EntityPlayer player) {
        if (player instanceof EntityPlayerMP) {
            EntityPlayerMP playerMP = (EntityPlayerMP)player;
            boolean side = HardcoreQuesting.loadingSide.isServer();
            if (FMLCommonHandler.instance().getMinecraftServerInstance().func_71264_H()) {
                NetworkManager.sendToPlayer(new PlayerDataSyncMessage(true, false, player), playerMP);
            } else {
                if (doServerSync) {
                    NetworkManager.sendToPlayer(new QuestLineSyncMessage(), playerMP);
                }
                NetworkManager.sendToPlayer(new PlayerDataSyncMessage(false, side, player), playerMP);
            }
            NetworkManager.sendToPlayer(new DeathStatsMessage(side), playerMP);
        }
    }

    public static void loadWorldData(File worldPath, boolean isClient) {
        File pathFile = new File(worldPath, "hqm");
        String path = pathFile.getAbsolutePath() + File.separator;
        if (!pathFile.exists()) {
            pathFile.mkdirs();
        }
        world = new QuestLine();
        QuestLine.init(path, isClient);
    }

    public static void saveDescription() {
        try {
            SaveHandler.saveDescription(SaveHandler.getLocalFile("description.txt"), QuestLine.getActiveQuestLine().mainDescription);
        }
        catch (IOException e) {
            FMLLog.log((String)"HQM", (Level)Level.INFO, (String)"Failed to load questing state", (Object[])new Object[0]);
        }
    }

    public static void saveDescriptionDefault() {
        try {
            SaveHandler.saveDescription(SaveHandler.getDefaultFile("description.txt"), QuestLine.getActiveQuestLine().mainDescription);
        }
        catch (IOException e) {
            FMLLog.log((String)"HQM", (Level)Level.INFO, (String)"Failed to load questing state", (Object[])new Object[0]);
        }
    }

    public static void loadDescription(boolean remote) {
        try {
            QuestLine.getActiveQuestLine().mainDescription = SaveHandler.loadDescription(SaveHandler.getFile("description.txt", remote));
            QuestLine.getActiveQuestLine().cachedMainDescription = null;
        }
        catch (IOException e) {
            FMLLog.log((String)"HQM", (Level)Level.INFO, (String)"Failed to load questing state", (Object[])new Object[0]);
        }
    }

    public static void saveAll() {
        QuestingData.saveState();
        QuestLine.saveDescription();
        DeathStats.saveAll();
        Reputation.saveAll();
        GroupTier.saveAll();
        QuestSet.saveAll();
        Team.saveAll();
        QuestingData.saveQuestingData();
        if (Quest.saveDefault && Quest.isEditing) {
            QuestLine.saveDescriptionDefault();
            Reputation.saveAllDefault();
            GroupTier.saveAllDefault();
            QuestSet.saveAllDefault();
        }
        SaveHelper.onSave();
    }

    public static void loadAll(boolean isClient, boolean remote) {
        QuestingData.loadState(remote);
        QuestLine.loadDescription(remote);
        DeathStats.loadAll(isClient, remote);
        Reputation.loadAll(remote);
        GroupTier.loadAll(remote);
        Team.loadAll(isClient, remote);
        QuestSet.loadAll(remote);
        QuestingData.loadQuestingData(remote);
        SaveHelper.onLoad();
        if (isClient) {
            GuiEditMenuItem.Search.initItems();
        }
    }

    public static void init(String path) {
        QuestLine.getActiveQuestLine().mainPath = path;
        QuestLine.getActiveQuestLine().quests = new ConcurrentHashMap<String, Quest>();
        QuestLine.getActiveQuestLine().questSets = new ArrayList<QuestSet>();
    }

    public static void init(String path, boolean isClient) {
        QuestLine.init(path);
        QuestLine.loadAll(isClient, false);
    }

    public static void copyDefaults(File worldPath) {
        File path = new File(worldPath, "hqm");
        if (!path.exists()) {
            path.mkdirs();
        }
        SaveHandler.copyFolder(SaveHandler.getDefaultFolder(), path);
    }

    static {
        config = new QuestLine();
    }
}

