/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.quests;

import hardcorequesting.client.ClientChange;
import hardcorequesting.client.EditMode;
import hardcorequesting.client.interfaces.GuiBase;
import hardcorequesting.client.interfaces.GuiColor;
import hardcorequesting.client.interfaces.GuiQuestBook;
import hardcorequesting.client.interfaces.LargeButton;
import hardcorequesting.client.interfaces.ResourceHelper;
import hardcorequesting.client.interfaces.ScrollBar;
import hardcorequesting.client.interfaces.edit.GuiEditMenuDeathTask;
import hardcorequesting.client.interfaces.edit.GuiEditMenuItem;
import hardcorequesting.client.interfaces.edit.GuiEditMenuReputationKillTask;
import hardcorequesting.client.interfaces.edit.GuiEditMenuReputationReward;
import hardcorequesting.client.interfaces.edit.GuiEditMenuTextEditor;
import hardcorequesting.client.sounds.SoundHandler;
import hardcorequesting.client.sounds.Sounds;
import hardcorequesting.event.EventHandler;
import hardcorequesting.network.NetworkManager;
import hardcorequesting.network.message.QuestDataUpdateMessage;
import hardcorequesting.quests.ItemPrecision;
import hardcorequesting.quests.QuestData;
import hardcorequesting.quests.QuestLine;
import hardcorequesting.quests.QuestSet;
import hardcorequesting.quests.QuestTicker;
import hardcorequesting.quests.QuestingData;
import hardcorequesting.quests.RepeatInfo;
import hardcorequesting.quests.RepeatType;
import hardcorequesting.quests.TriggerType;
import hardcorequesting.quests.data.QuestDataTask;
import hardcorequesting.quests.reward.CommandRewardList;
import hardcorequesting.quests.reward.ItemStackRewardList;
import hardcorequesting.quests.reward.ReputationReward;
import hardcorequesting.quests.task.QuestTask;
import hardcorequesting.quests.task.QuestTaskDeath;
import hardcorequesting.quests.task.QuestTaskItems;
import hardcorequesting.quests.task.QuestTaskItemsConsume;
import hardcorequesting.quests.task.QuestTaskItemsConsumeQDS;
import hardcorequesting.quests.task.QuestTaskItemsCrafting;
import hardcorequesting.quests.task.QuestTaskItemsDetect;
import hardcorequesting.quests.task.QuestTaskLocation;
import hardcorequesting.quests.task.QuestTaskMob;
import hardcorequesting.quests.task.QuestTaskReputationKill;
import hardcorequesting.quests.task.QuestTaskReputationTarget;
import hardcorequesting.reputation.Reputation;
import hardcorequesting.team.PlayerEntry;
import hardcorequesting.team.RewardSetting;
import hardcorequesting.team.Team;
import hardcorequesting.util.SaveHelper;
import hardcorequesting.util.Translator;
import java.awt.Polygon;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Tuple;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class Quest {
    private static final int VISIBLE_DESCRIPTION_LINES = 7;
    private static final int VISIBLE_TASKS = 3;
    private static final int START_X = 20;
    private static final int TEXT_HEIGHT = 9;
    private static final int TASK_LABEL_START_Y = 100;
    private static final int TASK_MARGIN = 2;
    private static final int TITLE_START_Y = 15;
    private static final int DESCRIPTION_START_Y = 30;
    private static final int TASK_DESCRIPTION_X = 180;
    private static final int TASK_DESCRIPTION_Y = 20;
    private static final int REWARD_STR_Y = 140;
    private static final int REWARD_Y = 150;
    private static final int REWARD_Y_OFFSET = 40;
    private static final int REWARD_OFFSET = 20;
    private static final int ITEM_SIZE = 18;
    private static final int REPUTATION_X = 142;
    private static final int REPUTATION_Y = 133;
    private static final int REPUTATION_Y_LOWER = 150;
    private static final int REPUTATION_SIZE = 16;
    private static final int REPUTATION_SRC_X = 30;
    private static final int REPUTATION_SRC_Y = 82;
    private static final int MAX_REWARD_SLOTS = 7;
    private static final int MAX_SELECT_REWARD_SLOTS = 4;
    public static boolean isEditing = false;
    public static boolean saveDefault = true;
    public static boolean useDefault = true;
    public static String selectedQuestId;
    public static QuestTicker clientTicker;
    public static QuestTicker serverTicker;
    private final List<LargeButton> buttons = new ArrayList<LargeButton>();
    private final ScrollBar descriptionScroll;
    private final ScrollBar taskDescriptionScroll;
    private final ScrollBar taskScroll;
    private final List<ScrollBar> scrollBars = new ArrayList<ScrollBar>();
    public int nextTaskId;
    private String uuid;
    private String name;
    private String description;
    private List<String> requirement;
    private List<String> reversedRequirement;
    private List<String> optionLinks;
    private List<String> reversedOptionLinks;
    private List<QuestTask> tasks;
    private List<String> cachedDescription;
    private List<ReputationReward> reputationRewards;
    private QuestTask selectedTask;
    private ItemStackRewardList rewards;
    private ItemStackRewardList rewardChoices;
    private CommandRewardList commandRewardList;
    private RepeatInfo repeatInfo = new RepeatInfo(RepeatType.NONE, 0, 0);
    private TriggerType triggerType = TriggerType.NONE;
    private int triggerTasks = 1;
    private boolean useModifiedParentRequirement;
    private int parentRequirementCount;
    private int x;
    private int y;
    private boolean isBig;
    private ItemStack iconStack = null;
    private QuestSet set;
    private int selectedReward = -1;
    private ParentEvaluator enabledParentEvaluator = new ParentEvaluator(){

        @Override
        protected boolean isValid(String playerName, Quest parent, Map<Quest, Boolean> isVisibleCache, Map<Quest, Boolean> isLinkFreeCache) {
            return parent.isCompleted(playerName);
        }
    };
    private ParentEvaluator linkParentEvaluator = new ParentEvaluator(){

        @Override
        protected boolean isValid(String playerName, Quest parent, Map<Quest, Boolean> isVisibleCache, Map<Quest, Boolean> isLinkFreeCache) {
            return parent.isLinkFree(playerName, isLinkFreeCache);
        }
    };
    private ParentEvaluator visibleParentEvaluator = new ParentEvaluator(){

        @Override
        protected boolean isValid(String playerName, Quest parent, Map<Quest, Boolean> isVisibleCache, Map<Quest, Boolean> isLinkFreeCache) {
            return parent.isVisible(playerName, isVisibleCache, isLinkFreeCache) || parent.isCompleted(playerName);
        }
    };

    public Quest(String name, String description, int x, int y, boolean isBig) {
        this.buttons.add(new LargeButton("hqm.quest.claim", 100, 190){

            @Override
            public boolean isEnabled(GuiBase gui, EntityPlayer player) {
                return Quest.this.canPlayerClaimReward(player);
            }

            @Override
            public boolean isVisible(GuiBase gui, EntityPlayer player) {
                return Quest.this.hasReward(player);
            }

            @Override
            public void onClick(GuiBase gui, EntityPlayer player) {
                NetworkManager.sendToServer(ClientChange.CLAIM_QUEST.build(new Tuple((Object)Quest.this.getId(), (Object)(Quest.this.rewardChoices.isEmpty() ? -1 : Quest.this.selectedReward))));
            }
        });
        this.buttons.add(new LargeButton("hqm.quest.manualSubmit", 185, 200){

            @Override
            public boolean isEnabled(GuiBase gui, EntityPlayer player) {
                return ((QuestTaskItemsConsume)Quest.this.selectedTask).allowManual();
            }

            @Override
            public boolean isVisible(GuiBase gui, EntityPlayer player) {
                return Quest.this.selectedTask != null && Quest.this.selectedTask instanceof QuestTaskItemsConsume && !Quest.this.selectedTask.isCompleted(player);
            }

            @Override
            public void onClick(GuiBase gui, EntityPlayer player) {
                NetworkManager.sendToServer(ClientChange.UPDATE_TASK.build(Quest.this.selectedTask));
            }
        });
        this.buttons.add(new LargeButton("hqm.quest.manualDetect", 185, 200){

            @Override
            public boolean isEnabled(GuiBase gui, EntityPlayer player) {
                return true;
            }

            @Override
            public boolean isVisible(GuiBase gui, EntityPlayer player) {
                return Quest.this.selectedTask != null && Quest.this.selectedTask instanceof QuestTaskItemsDetect && !Quest.this.selectedTask.isCompleted(player);
            }

            @Override
            public void onClick(GuiBase gui, EntityPlayer player) {
                NetworkManager.sendToServer(ClientChange.UPDATE_TASK.build(Quest.this.selectedTask));
            }
        });
        this.buttons.add(new LargeButton("hqm.quest.requirement", 185, 200){

            @Override
            @SideOnly(value=Side.CLIENT)
            public boolean isEnabled(GuiBase gui, EntityPlayer player) {
                return true;
            }

            @Override
            @SideOnly(value=Side.CLIENT)
            public boolean isVisible(GuiBase gui, EntityPlayer player) {
                return Quest.this.selectedTask != null && Quest.this.selectedTask instanceof QuestTaskDeath && isEditing;
            }

            @Override
            @SideOnly(value=Side.CLIENT)
            public void onClick(GuiBase gui, EntityPlayer player) {
                gui.setEditMenu(new GuiEditMenuDeathTask(gui, player, (QuestTaskDeath)Quest.this.selectedTask));
            }
        });
        this.buttons.add(new LargeButton("hqm.quest.requirement", 250, 95){

            @Override
            @SideOnly(value=Side.CLIENT)
            public boolean isEnabled(GuiBase gui, EntityPlayer player) {
                return true;
            }

            @Override
            @SideOnly(value=Side.CLIENT)
            public boolean isVisible(GuiBase gui, EntityPlayer player) {
                return Quest.this.selectedTask != null && Quest.this.selectedTask instanceof QuestTaskReputationKill && isEditing;
            }

            @Override
            @SideOnly(value=Side.CLIENT)
            public void onClick(GuiBase gui, EntityPlayer player) {
                gui.setEditMenu(new GuiEditMenuReputationKillTask(gui, player, (QuestTaskReputationKill)Quest.this.selectedTask));
            }
        });
        this.buttons.add(new LargeButton("hqm.quest.selectTask", 250, 200){

            @Override
            public boolean isEnabled(GuiBase gui, EntityPlayer player) {
                return QuestingData.getQuestingData((EntityPlayer)player).selectedQuest.equals(Quest.this.getId()) && QuestingData.getQuestingData((EntityPlayer)player).selectedTask == Quest.this.selectedTask.getId();
            }

            @Override
            public boolean isVisible(GuiBase gui, EntityPlayer player) {
                return Quest.this.selectedTask != null && Quest.this.selectedTask instanceof QuestTaskItemsConsume && !Quest.this.selectedTask.isCompleted(player);
            }

            @Override
            public void onClick(GuiBase gui, EntityPlayer player) {
                QuestingData.getQuestingData((EntityPlayer)player).selectedQuest = Quest.this.getId();
                QuestingData.getQuestingData((EntityPlayer)player).selectedTask = Quest.this.selectedTask.getId();
                NetworkManager.sendToServer(ClientChange.SELECT_QUEST.build(Quest.this.selectedTask));
            }
        });
        int itemIds = 0;
        for (final TaskType taskType : TaskType.values()) {
            this.buttons.add(new LargeButton(taskType.getLangKeyName(), taskType.getLangKeyDescription(), 185 + taskType.ordinal() % 2 * 65, 50 + taskType.ordinal() / 2 * 35){

                @Override
                public boolean isEnabled(GuiBase gui, EntityPlayer player) {
                    return true;
                }

                @Override
                public boolean isVisible(GuiBase gui, EntityPlayer player) {
                    return isEditing && Quest.this.selectedTask == null && ((GuiQuestBook)gui).getCurrentMode() == EditMode.TASK;
                }

                @Override
                public void onClick(GuiBase gui, EntityPlayer player) {
                    taskType.addTask(Quest.this);
                }
            });
            if (!QuestTaskItems.class.isAssignableFrom(taskType.clazz)) continue;
            this.buttons.add(new LargeButton(taskType.getLangKeyName(), taskType.getLangKeyDescription(), 185 + itemIds % 2 * 65, 50 + itemIds / 2 * 35){

                @Override
                public boolean isEnabled(GuiBase gui, EntityPlayer player) {
                    return Quest.this.selectedTask instanceof QuestTaskItems;
                }

                @Override
                public boolean isVisible(GuiBase gui, EntityPlayer player) {
                    return isEditing && Quest.this.selectedTask != null && ((GuiQuestBook)gui).getCurrentMode() == EditMode.CHANGE_TASK;
                }

                @Override
                public void onClick(GuiBase gui, EntityPlayer player) {
                    TaskType oldTaskType = TaskType.getType(Quest.this.selectedTask.getClass());
                    if (oldTaskType == null) {
                        return;
                    }
                    --Quest.this.nextTaskId;
                    Class clazz = taskType.clazz;
                    try {
                        Constructor constructor = clazz.getConstructor(Quest.class, String.class, String.class);
                        QuestTask task = (QuestTask)constructor.newInstance(this, taskType.getLangKeyName(), taskType.getLangKeyDescription());
                        Quest.this.selectedTask.getRequirements().forEach(task::addRequirement);
                        for (QuestTask questTask : Quest.this.tasks) {
                            List<QuestTask> requirements = questTask.getRequirements();
                            for (int j = 0; j < requirements.size(); ++j) {
                                if (!requirements.get(j).equals(Quest.this.selectedTask)) continue;
                                requirements.set(j, task);
                            }
                        }
                        for (int j = 0; j < Quest.this.tasks.size(); ++j) {
                            if (!((QuestTask)Quest.this.tasks.get(j)).equals(Quest.this.selectedTask)) continue;
                            Quest.this.tasks.set(j, task);
                            break;
                        }
                        if (!Quest.this.selectedTask.getLangKeyDescription().equals(oldTaskType.getLangKeyName())) {
                            task.setDescription(Quest.this.selectedTask.getLangKeyDescription());
                        }
                        if (!Quest.this.selectedTask.getLangKeyLongDescription().equals(oldTaskType.getLangKeyDescription())) {
                            task.setLongDescription(Quest.this.selectedTask.getLangKeyLongDescription());
                        }
                        ((QuestTaskItems)task).setItems(((QuestTaskItems)Quest.this.selectedTask).getItems());
                        task.setId(Quest.this.selectedTask.getId());
                        Quest.this.selectedTask = task;
                        SaveHelper.add(SaveHelper.EditType.TASK_CHANGE_TYPE);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            });
            ++itemIds;
        }
        this.descriptionScroll = new ScrollBar(155, 28, 64, 249, 102, 20){

            @Override
            public boolean isVisible(GuiBase gui) {
                return Quest.this.getCachedDescription(gui).size() > 7;
            }
        };
        this.scrollBars.add(this.descriptionScroll);
        this.taskDescriptionScroll = new ScrollBar(312, 18, 64, 249, 102, 180){

            @Override
            public boolean isVisible(GuiBase gui) {
                return Quest.this.selectedTask != null && Quest.this.selectedTask.getCachedLongDescription(gui).size() > 7;
            }
        };
        this.scrollBars.add(this.taskDescriptionScroll);
        this.taskScroll = new ScrollBar(155, 100, 29, 242, 102, 20){

            @Override
            public boolean isVisible(GuiBase gui) {
                return Quest.this.tasks.size() > 3 && Quest.this.getVisibleTasks(gui) > 3;
            }
        };
        this.scrollBars.add(this.taskScroll);
        do {
            this.uuid = UUID.randomUUID().toString();
        } while (Quest.getQuests().containsKey(this.uuid));
        this.name = name;
        this.x = x;
        this.y = y;
        this.isBig = isBig;
        this.description = description;
        this.requirement = new ArrayList<String>();
        this.reversedRequirement = new ArrayList<String>();
        this.optionLinks = new ArrayList<String>();
        this.reversedOptionLinks = new ArrayList<String>();
        this.tasks = new ArrayList<QuestTask>();
        this.rewards = new ItemStackRewardList();
        this.rewardChoices = new ItemStackRewardList();
        this.commandRewardList = new CommandRewardList();
        QuestLine.getActiveQuestLine().quests.put(this.getId(), this);
    }

    public static Map<String, Quest> getQuests() {
        return QuestLine.getActiveQuestLine().quests;
    }

    public static List<QuestSet> getQuestSets() {
        return QuestLine.getActiveQuestLine().questSets;
    }

    @SideOnly(value=Side.CLIENT)
    public static List<String> getMainDescription(GuiBase gui) {
        if (QuestLine.getActiveQuestLine().cachedMainDescription == null) {
            QuestLine.getActiveQuestLine().cachedMainDescription = gui.getLinesFromText(QuestLine.getActiveQuestLine().mainDescription, 0.7f, 130);
        }
        return QuestLine.getActiveQuestLine().cachedMainDescription;
    }

    public static String getRawMainDescription() {
        return QuestLine.getActiveQuestLine().mainDescription;
    }

    public static void setMainDescription(String mainDescription) {
        QuestLine.getActiveQuestLine().mainDescription = mainDescription;
        QuestLine.getActiveQuestLine().cachedMainDescription = null;
    }

    public static Quest getQuest(String id) {
        return QuestLine.getActiveQuestLine().quests.get(id);
    }

    public static void addItems(EntityPlayer player, List<ItemStack> itemsToAdd) {
        block0: for (int i = 0; i < player.field_71071_by.field_70462_a.length; ++i) {
            Iterator<ItemStack> iterator = itemsToAdd.iterator();
            while (iterator.hasNext()) {
                int amount;
                ItemStack nextStack = iterator.next();
                ItemStack stack = player.field_71071_by.func_70301_a(i);
                if (stack == null) {
                    amount = Math.min(nextStack.func_77976_d(), nextStack.field_77994_a);
                    ItemStack copyStack = nextStack.func_77946_l();
                    copyStack.field_77994_a = amount;
                    player.field_71071_by.func_70441_a(copyStack);
                    nextStack.field_77994_a -= amount;
                    if (nextStack.field_77994_a > 0) continue block0;
                    iterator.remove();
                    continue block0;
                }
                if (!stack.func_77969_a(nextStack) || !ItemStack.func_77970_a((ItemStack)nextStack, (ItemStack)stack)) continue;
                amount = Math.min(nextStack.func_77976_d() - stack.field_77994_a, nextStack.field_77994_a);
                stack.field_77994_a += amount;
                nextStack.field_77994_a -= amount;
                if (nextStack.field_77994_a > 0) continue block0;
                iterator.remove();
                continue block0;
            }
        }
    }

    public static void removeQuest(Quest quest) {
        for (String requirement : quest.requirement) {
            Quest.getQuest((String)requirement).reversedRequirement.remove(quest.getId());
        }
        for (String optionLink : quest.optionLinks) {
            Quest.getQuest((String)optionLink).reversedOptionLinks.remove(quest.getId());
        }
        quest.tasks.forEach(QuestTask::onDelete);
        quest.setQuestSet(null);
        QuestLine.getActiveQuestLine().quests.remove(quest.getId());
        for (Quest other : QuestLine.getActiveQuestLine().quests.values()) {
            String element;
            Iterator<String> iterator = other.requirement.iterator();
            while (iterator.hasNext()) {
                element = iterator.next();
                if (!element.equals(quest.getId())) continue;
                iterator.remove();
            }
            iterator = other.optionLinks.iterator();
            while (iterator.hasNext()) {
                element = iterator.next();
                if (!element.equals(quest.getId())) continue;
                iterator.remove();
            }
        }
    }

    public void setX(int x) {
        this.x = x;
    }

    public void setY(int y) {
        this.y = y;
    }

    public ItemStack[] getReward() {
        return this.rewards.toArray();
    }

    public void setReward(ItemStack[] reward) {
        this.rewards.set(reward);
    }

    public ItemStack[] getRewardChoice() {
        return this.rewardChoices.toArray();
    }

    public void setRewardChoice(ItemStack[] rewardChoice) {
        this.rewardChoices.set(rewardChoice);
    }

    public String[] getCommandRewardsAsStrings() {
        return this.commandRewardList.asStrings();
    }

    public void setCommandRewards(String[] commands) {
        this.commandRewardList.set(commands);
    }

    public void addCommand(String command) {
        this.commandRewardList.add(command);
    }

    public void editCommand(int id, String command) {
        this.commandRewardList.set(id, command);
    }

    public void removeCommand(int id) {
        this.commandRewardList.remove(id);
    }

    public RepeatInfo getRepeatInfo() {
        return this.repeatInfo;
    }

    public void setRepeatInfo(RepeatInfo repeatInfo) {
        this.repeatInfo = repeatInfo;
    }

    public void addRequirement(String id) {
        if (this.lookForId(id, false) || this.lookForId(id, true)) {
            return;
        }
        Quest quest = QuestLine.getActiveQuestLine().quests.get(id);
        if (quest != null) {
            this.requirement.add(quest.getId());
            quest.reversedRequirement.add(this.getId());
            SaveHelper.add(SaveHelper.EditType.REQUIREMENT_CHANGE);
        }
    }

    private boolean lookForId(String id, boolean reversed) {
        List<String> quests = reversed ? this.reversedRequirement : this.requirement;
        for (String questId : quests) {
            if (!questId.equals(id) && !QuestLine.getActiveQuestLine().quests.get(questId).lookForId(id, reversed)) continue;
            return true;
        }
        return false;
    }

    public void clearRequirements() {
        SaveHelper.add(SaveHelper.EditType.REQUIREMENT_REMOVE, this.requirement.size());
        for (String questId : this.requirement) {
            QuestLine.getActiveQuestLine().quests.get((Object)questId).reversedRequirement.remove(this.getId());
        }
        this.requirement.clear();
    }

    public void addOptionLink(String id) {
        for (String questId : this.optionLinks) {
            if (!questId.equals(id)) continue;
            return;
        }
        for (String questId : this.reversedOptionLinks) {
            if (!questId.equals(id)) continue;
            return;
        }
        Quest quest = QuestLine.getActiveQuestLine().quests.get(id);
        if (quest != null) {
            SaveHelper.add(SaveHelper.EditType.OPTION_CHANGE);
            this.optionLinks.add(quest.getId());
            quest.reversedOptionLinks.add(this.getId());
        }
    }

    public void clearOptionLinks() {
        SaveHelper.add(SaveHelper.EditType.OPTION_REMOVE, this.optionLinks.size());
        for (String questId : this.reversedOptionLinks) {
            QuestLine.getActiveQuestLine().quests.get((Object)questId).optionLinks.remove(this.getId());
        }
        for (String questId : this.optionLinks) {
            QuestLine.getActiveQuestLine().quests.get((Object)questId).reversedOptionLinks.remove(this.getId());
        }
        this.reversedRequirement.clear();
        this.optionLinks.clear();
    }

    public QuestData getQuestData(EntityPlayer player) {
        return QuestingData.getQuestingData(player).getQuestData(this.getId());
    }

    public QuestData getQuestData(String uuid) {
        return QuestingData.getQuestingData(uuid).getQuestData(this.getId());
    }

    public void setQuestData(EntityPlayer player, QuestData data) {
        QuestingData.getQuestingData(player).setQuestData(this.getId(), data);
    }

    public String getId() {
        return this.uuid;
    }

    public void setId(String id) {
        if (this.getQuestSet() != null) {
            this.getQuestSet().removeQuest(this);
        }
        Quest.getQuests().remove(this.getId());
        this.uuid = id;
        Quest.getQuests().put(this.getId(), this);
        if (this.getQuestSet() != null) {
            this.getQuestSet().addQuest(this);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isVisible(EntityPlayer player) {
        return this.isVisible(QuestingData.getUserUUID(player));
    }

    boolean isVisible(EntityPlayer player, Map<Quest, Boolean> isVisibleCache, Map<Quest, Boolean> isLinkFreeCache) {
        return this.isVisible(QuestingData.getUserUUID(player), isVisibleCache, isLinkFreeCache);
    }

    public boolean isVisible(String playerName) {
        return this.isVisible(playerName, new HashMap<Quest, Boolean>(), new HashMap<Quest, Boolean>());
    }

    boolean isVisible(String playerName, Map<Quest, Boolean> isVisibleCache, Map<Quest, Boolean> isLinkFreeCache) {
        Boolean cachedResult = isVisibleCache.get(this);
        if (cachedResult != null) {
            return cachedResult;
        }
        boolean result = this.triggerType.isQuestVisible(this, playerName) && this.isLinkFree(playerName, isLinkFreeCache) && this.visibleParentEvaluator.isValid(playerName, isVisibleCache, isLinkFreeCache);
        isVisibleCache.put(this, result);
        return result;
    }

    public boolean isEnabled(EntityPlayer player) {
        return this.isEnabled(QuestingData.getUserUUID(player));
    }

    boolean isEnabled(EntityPlayer player, Map<Quest, Boolean> isVisibleCache, Map<Quest, Boolean> isLinkFreeCache) {
        return this.isEnabled(QuestingData.getUserUUID(player), true, isVisibleCache, isLinkFreeCache);
    }

    public boolean isEnabled(String playerName) {
        return this.isEnabled(playerName, true);
    }

    public boolean isEnabled(String playerName, boolean requiresVisible) {
        return this.isEnabled(playerName, requiresVisible, new HashMap<Quest, Boolean>(), new HashMap<Quest, Boolean>());
    }

    boolean isEnabled(String playerName, boolean requiresVisible, Map<Quest, Boolean> isVisibleCache, Map<Quest, Boolean> isLinkFreeCache) {
        return this.set != null && this.isLinkFree(playerName, isLinkFreeCache) && (!requiresVisible || this.triggerType.doesWorkAsInvisible() || this.isVisible(playerName, isVisibleCache, isLinkFreeCache)) && this.enabledParentEvaluator.isValid(playerName, isVisibleCache, isLinkFreeCache);
    }

    public boolean isLinkFree(EntityPlayer player) {
        return this.isLinkFree(QuestingData.getUserUUID(player), new HashMap<Quest, Boolean>());
    }

    boolean isLinkFree(EntityPlayer player, Map<Quest, Boolean> cache) {
        return this.isLinkFree(QuestingData.getUserUUID(player), cache);
    }

    public boolean isLinkFree(String playerName) {
        return this.isLinkFree(playerName, new HashMap<Quest, Boolean>());
    }

    boolean isLinkFree(String playerName, Map<Quest, Boolean> cache) {
        Boolean cachedResult = cache.get(this);
        if (cachedResult != null) {
            return cachedResult;
        }
        boolean result = true;
        for (String optionLink : this.optionLinks) {
            if (!QuestLine.getActiveQuestLine().quests.get(optionLink).isCompleted(playerName)) continue;
            result = false;
            break;
        }
        if (result) {
            for (String optionLink : this.reversedOptionLinks) {
                if (!QuestLine.getActiveQuestLine().quests.get(optionLink).isCompleted(playerName)) continue;
                result = false;
                break;
            }
        }
        if (result) {
            result = this.linkParentEvaluator.isValid(playerName, null, cache);
        }
        cache.put(this, result);
        return result;
    }

    public List<ReputationReward> getReputationRewards() {
        return this.reputationRewards;
    }

    public void setReputationRewards(List<ReputationReward> reputationRewards) {
        this.reputationRewards = reputationRewards;
    }

    public boolean isAvailable(EntityPlayer player) {
        return this.isAvailable(QuestingData.getUserUUID(player));
    }

    public boolean isCompleted(EntityPlayer player) {
        return this.isCompleted(QuestingData.getUserUUID(player));
    }

    public boolean isAvailable(String playerName) {
        QuestData data = this.getQuestData(playerName);
        return data != null && data.available;
    }

    public boolean isCompleted(String playerName) {
        QuestData data = this.getQuestData(playerName);
        return data != null && data.completed;
    }

    public List<Quest> getRequirements() {
        return QuestLine.getActiveQuestLine().quests.values().stream().filter(quest -> this.requirement.contains(quest.getId())).collect(Collectors.toList());
    }

    public int getGuiX() {
        return this.x;
    }

    public int getGuiY() {
        return this.y;
    }

    public int getGuiU() {
        return this.isBig ? 195 : 170;
    }

    public int getGuiV(EntityPlayer player, int x, int y) {
        return this.isEnabled(player) && this.isMouseInObject(x, y) ? this.getGuiH() : 0;
    }

    public int getGuiW() {
        return this.isBig ? 31 : 25;
    }

    public int getGuiH() {
        return this.isBig ? 37 : 30;
    }

    public int getGuiCenterX() {
        return this.getGuiX() + this.getGuiW() / 2;
    }

    public void setGuiCenterX(int x) {
        this.x = x - this.getGuiW() / 2;
    }

    public int getGuiCenterY() {
        return this.getGuiY() + this.getGuiH() / 2;
    }

    public void setGuiCenterY(int y) {
        this.y = y - this.getGuiH() / 2;
    }

    public ItemStack getIconStack() {
        return this.iconStack;
    }

    public void setIconStack(ItemStack iconStack) {
        this.iconStack = iconStack;
        if (iconStack != null) {
            iconStack.field_77994_a = 1;
        }
    }

    public boolean useBigIcon() {
        return this.isBig;
    }

    public TriggerType getTriggerType() {
        return this.triggerType;
    }

    public void setTriggerType(TriggerType triggerType) {
        this.triggerType = triggerType;
    }

    public int getTriggerTasks() {
        return this.triggerTasks;
    }

    public void setTriggerTasks(int triggerTasks) {
        this.triggerTasks = triggerTasks;
    }

    @SideOnly(value=Side.CLIENT)
    public int getColorFilter(EntityPlayer player, int tick) {
        if (isEditing && !this.isVisible(player)) {
            return 0x55FFFFFF;
        }
        if (!this.isEnabled(player)) {
            return -7829368;
        }
        if (!this.isAvailable(player) && !this.hasReward(player)) {
            return this.getRepeatInfo().getType() == RepeatType.NONE ? -1 : -52;
        }
        int componentBase = 187;
        int componentVariable = (int)(Math.abs(Math.sin((float)tick / 5.0f)) * 68.0);
        int component = componentBase + componentVariable;
        int red = this.hasReward(player) ? componentBase : component;
        int green = this.hasReward(player) ? component * 3 / 4 : component;
        int blue = component;
        return 0xFF000000 | red << 16 | green << 8 | blue;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isMouseInObject(int x, int y) {
        if (this.getGuiX() > x || x > this.getGuiX() + this.getGuiW() || this.getGuiY() > y || y > this.getGuiY() + this.getGuiH()) {
            return false;
        }
        Polygon poly = new Polygon();
        if (this.isBig) {
            poly.addPoint(this.getGuiX() + 1, this.getGuiY() + 10);
            poly.addPoint(this.getGuiX() + 15, this.getGuiY() + 1);
            poly.addPoint(this.getGuiX() + 30, this.getGuiY() + 10);
            poly.addPoint(this.getGuiX() + 30, this.getGuiY() + 27);
            poly.addPoint(this.getGuiX() + 15, this.getGuiY() + 36);
            poly.addPoint(this.getGuiX() + 1, this.getGuiY() + 27);
        } else {
            poly.addPoint(this.getGuiX() + 1, this.getGuiY() + 8);
            poly.addPoint(this.getGuiX() + 12, this.getGuiY() + 2);
            poly.addPoint(this.getGuiX() + 23, this.getGuiY() + 8);
            poly.addPoint(this.getGuiX() + 23, this.getGuiY() + 8);
            poly.addPoint(this.getGuiX() + 23, this.getGuiY() + 21);
            poly.addPoint(this.getGuiX() + 12, this.getGuiY() + 27);
            poly.addPoint(this.getGuiX() + 1, this.getGuiY() + 21);
        }
        return poly.contains(x, y);
    }

    @SideOnly(value=Side.CLIENT)
    private List<String> getCachedDescription(GuiBase gui) {
        if (this.cachedDescription == null) {
            this.cachedDescription = gui.getLinesFromText(this.description, 0.7f, 130);
        }
        return this.cachedDescription;
    }

    @SideOnly(value=Side.CLIENT)
    public void drawMenu(GuiQuestBook gui, EntityPlayer player, int mX, int mY) {
        if (!isEditing && this.selectedTask != null && !this.selectedTask.isVisible(player)) {
            this.selectedTask = this.tasks.size() > 0 ? this.tasks.get(0) : null;
        }
        gui.drawString(this.name, 20, 15, 0x404040);
        int startLine = this.descriptionScroll.isVisible(gui) ? Math.round((float)(this.getCachedDescription(gui).size() - 7) * this.descriptionScroll.getScroll()) : 0;
        gui.drawString(this.getCachedDescription(gui), startLine, 7, 20, 30, 0.7f, 0x404040);
        int id = 0;
        int start = this.taskScroll.isVisible(gui) ? Math.round((float)(this.getVisibleTasks(gui) - 3) * this.taskScroll.getScroll()) : 0;
        int end = Math.min(start + 3, this.tasks.size());
        for (int i = start; i < end; ++i) {
            QuestTask task = this.tasks.get(i);
            boolean isVisible = task.isVisible(player);
            if (!isVisible && !isEditing) continue;
            boolean completed = task.isCompleted(player);
            int yPos = this.getTaskY(gui, id);
            boolean inBounds = gui.inBounds(20, yPos, gui.getStringWidth(task.getDescription()), 9, mX, mY);
            boolean isSelected = task == this.selectedTask;
            gui.drawString(task.getDescription(), 20, yPos, completed ? (isSelected ? (inBounds ? 0x40BB40 : 0x40A040) : (inBounds ? 0x10A010 : 0x107010)) : (isSelected ? (inBounds ? 0xAAAAAA : 0x888888) : (inBounds ? 0x666666 : (isVisible ? 0x404040 : 0xDDDDDD))));
            ++id;
        }
        if (this.selectedReward != -1 && !this.hasReward(player)) {
            this.selectedReward = -1;
        }
        if (!this.rewards.isEmpty() || isEditing) {
            gui.drawString(Translator.translate("hqm.quest.rewards"), 20, 140, 0x404040);
            this.drawRewards(gui, this.rewards.toArray(), 150, -1, mX, mY, 4);
            if (!this.rewardChoices.isEmpty() || isEditing) {
                gui.drawString(Translator.translate("hqm.quest.pickOne"), 20, 180, 0x404040);
                this.drawRewards(gui, this.rewardChoices.toArray(), 190, this.selectedReward, mX, mY, 7);
            }
        } else if (!this.rewardChoices.isEmpty()) {
            gui.drawString(Translator.translate("hqm.quest.pickOneReward"), 20, 140, 0x404040);
            this.drawRewards(gui, this.rewardChoices.toArray(), 150, this.selectedReward, mX, mY, 7);
        }
        for (LargeButton button : this.buttons) {
            button.draw(gui, player, mX, mY);
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ResourceHelper.bindResource(GuiQuestBook.MAP_TEXTURE);
        for (ScrollBar scrollBar : this.scrollBars) {
            scrollBar.draw(gui);
        }
        boolean claimed = this.getQuestData((EntityPlayer)player).claimed;
        int y = this.rewards == null || this.rewards.size() <= 7 - (isEditing ? 2 : 1) ? 150 : 133;
        boolean hover = gui.inBounds(142, y, 16, 16, mX, mY);
        if (this.reputationRewards != null || isEditing) {
            int foregroundIndex;
            int backgroundIndex;
            if (this.reputationRewards == null) {
                claimed = true;
            }
            int n = claimed ? 2 : (backgroundIndex = hover ? 1 : 0);
            if (claimed) {
                foregroundIndex = 3;
            } else {
                boolean positive = false;
                boolean negative = false;
                for (ReputationReward reputationReward : this.reputationRewards) {
                    if (reputationReward.getValue() < 0) {
                        negative = true;
                        continue;
                    }
                    if (reputationReward.getValue() <= 0) continue;
                    positive = true;
                }
                foregroundIndex = negative == positive ? 2 : (positive ? 0 : 1);
            }
            gui.drawRect(142, y, 30 + backgroundIndex * 16, 82, 16, 16);
            gui.drawRect(142, y, 30 + (foregroundIndex += 3) * 16, 82, 16, 16);
        }
        if (this.selectedTask != null) {
            if (isEditing && gui.getCurrentMode() == EditMode.CHANGE_TASK) {
                if (this.selectedTask instanceof QuestTaskItems) {
                    gui.drawString(gui.getLinesFromText(Translator.translate("hqm.quest.itemTaskChangeTo"), 0.7f, 130), 180, 20, 0.7f, 0x404040);
                } else {
                    gui.drawString(gui.getLinesFromText(Translator.translate("hqm.quest.itemTaskTypeOnly"), 0.7f, 130), 180, 20, 0.7f, 0x404040);
                }
            } else {
                List<String> description = this.selectedTask.getCachedLongDescription(gui);
                int taskStartLine = this.taskDescriptionScroll.isVisible(gui) ? Math.round((float)(description.size() - 7) * this.taskDescriptionScroll.getScroll()) : 0;
                gui.drawString(description, taskStartLine, 7, 180, 20, 0.7f, 0x404040);
                this.selectedTask.draw(gui, player, mX, mY);
            }
        } else if (isEditing && gui.getCurrentMode() == EditMode.TASK) {
            gui.drawString(gui.getLinesFromText(Translator.translate("hqm.quest.createTasks"), 0.7f, 130), 180, 20, 0.7f, 0x404040);
        } else if (isEditing && gui.getCurrentMode() == EditMode.CHANGE_TASK) {
            gui.drawString(gui.getLinesFromText(Translator.translate("hqm.quest.itemTaskTypeChange"), 0.7f, 130), 180, 20, 0.7f, 0x404040);
        }
        if (!this.rewards.isEmpty() || isEditing) {
            this.drawRewardMouseOver(gui, this.rewards.toArray(), 150, -1, mX, mY);
            if (!this.rewardChoices.isEmpty() || isEditing) {
                this.drawRewardMouseOver(gui, this.rewardChoices.toArray(), 190, this.selectedReward, mX, mY);
            }
        } else if (!this.rewardChoices.isEmpty()) {
            this.drawRewardMouseOver(gui, this.rewardChoices.toArray(), 150, this.selectedReward, mX, mY);
        }
        for (LargeButton button : this.buttons) {
            button.drawMouseOver(gui, player, mX, mY);
        }
        if (this.reputationRewards != null && hover) {
            ArrayList<String> str = new ArrayList<String>();
            for (ReputationReward reputationReward : this.reputationRewards) {
                if (reputationReward.getValue() == 0 || reputationReward.getReward() == null || !((Reputation)reputationReward.getReward()).isValid()) continue;
                str.add(reputationReward.getLabel());
            }
            List<String> commentLines = gui.getLinesFromText(Translator.translate("hqm.quest.partyRepReward" + (claimed ? "Claimed" : "")), 1.0f, 200);
            if (commentLines != null) {
                str.add("");
                for (String commentLine : commentLines) {
                    str.add((Object)((Object)GuiColor.GRAY) + commentLine);
                }
            }
            gui.drawMouseOver(str, mX + gui.getLeft(), mY + gui.getTop());
        }
    }

    @SideOnly(value=Side.CLIENT)
    private int getVisibleTasks(GuiBase gui) {
        if (isEditing) {
            return this.tasks.size();
        }
        int count = 0;
        for (QuestTask task : this.tasks) {
            if (!task.isVisible(((GuiQuestBook)gui).getPlayer())) continue;
            ++count;
        }
        return count;
    }

    private boolean canPlayerClaimReward(EntityPlayer player) {
        return this.hasReward(player) && (this.rewardChoices.isEmpty() || this.selectedReward != -1) && this.isEnabled(player);
    }

    public boolean hasReward(EntityPlayer player) {
        return this.getQuestData(player).getReward(player) && (!this.rewards.isEmpty() || !this.rewardChoices.isEmpty()) || this.getQuestData(player).canClaim() && (this.reputationRewards != null || !this.commandRewardList.isEmpty());
    }

    @SideOnly(value=Side.CLIENT)
    private void drawRewards(GuiQuestBook gui, ItemStack[] rewards, int y, int selected, int mX, int mY, int max) {
        rewards = this.getEditFriendlyRewards(rewards, max);
        for (int i = 0; i < rewards.length; ++i) {
            gui.drawItemStack(rewards[i], 20 + i * 20, y, mX, mY, selected == i);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void drawRewardMouseOver(GuiQuestBook gui, ItemStack[] rewards, int y, int selected, int mX, int mY) {
        if (rewards != null) {
            for (int i = 0; i < rewards.length; ++i) {
                if (!gui.inBounds(20 + i * 20, y, 18, 18, mX, mY)) continue;
                if (rewards[i] == null) break;
                GuiQuestBook.setSelectedStack(rewards[i]);
                List<String> str = new ArrayList<String>();
                try {
                    if (isEditing && !GuiQuestBook.func_146271_m()) {
                        str = rewards[i].func_82840_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g, Minecraft.func_71410_x().field_71474_y.field_82882_x);
                        str.add("");
                        str.add((Object)((Object)GuiColor.GRAY) + Translator.translate("hqm.quest.crtlNonEditor"));
                    } else {
                        str.add(rewards[i].func_82833_r());
                    }
                }
                catch (Throwable ignored) {
                    break;
                }
                if (selected == i) {
                    str.add((Object)((Object)GuiColor.GREEN) + Translator.translate("hqm.quest.selected"));
                }
                gui.drawMouseOver(str, gui.getLeft() + mX, gui.getTop() + mY);
                break;
            }
        }
    }

    private ItemStack[] getEditFriendlyRewards(ItemStack[] rewards, int max) {
        if (rewards == null) {
            return new ItemStack[1];
        }
        if (isEditing && rewards.length < max) {
            return Arrays.copyOf(rewards, rewards.length + 1);
        }
        return rewards;
    }

    @SideOnly(value=Side.CLIENT)
    private void handleRewardClick(GuiQuestBook gui, EntityPlayer player, ItemStack[] rawRewards, int y, boolean canSelect, int mX, int mY) {
        ItemStack[] rewards = this.getEditFriendlyRewards(rawRewards, canSelect ? 4 : 7);
        for (int i = 0; i < rewards.length; ++i) {
            ItemStack[] newRewards;
            if (!gui.inBounds(20 + i * 20, y, 18, 18, mX, mY)) continue;
            if (canSelect && (!isEditing || gui.getCurrentMode() == EditMode.NORMAL)) {
                if (this.selectedReward == i) {
                    this.selectedReward = -1;
                    break;
                }
                if (rewards[i] == null) break;
                this.selectedReward = i;
                break;
            }
            if (isEditing && gui.getCurrentMode() == EditMode.ITEM) {
                gui.setEditMenu(new GuiEditMenuItem((GuiBase)gui, player, (Object)rewards[i], i, canSelect ? GuiEditMenuItem.Type.PICK_REWARD : GuiEditMenuItem.Type.REWARD, rewards[i] == null ? 1 : rewards[i].field_77994_a, ItemPrecision.PRECISE));
                break;
            }
            if (!isEditing || gui.getCurrentMode() != EditMode.DELETE || rewards[i] == null) break;
            if (rawRewards.length == 1) {
                newRewards = null;
                if (canSelect) {
                    this.selectedReward = -1;
                }
            } else {
                newRewards = new ItemStack[rawRewards.length - 1];
                int id = 0;
                for (int j = 0; j < rawRewards.length; ++j) {
                    if (j == i) continue;
                    newRewards[id] = rawRewards[j];
                    ++id;
                }
                if (canSelect && this.selectedReward != -1) {
                    if (this.selectedReward == i) {
                        this.selectedReward = -1;
                    } else if (this.selectedReward > i) {
                        --this.selectedReward;
                    }
                }
            }
            if (canSelect) {
                this.rewardChoices.set(newRewards);
            } else {
                this.rewards.set(newRewards);
            }
            SaveHelper.add(SaveHelper.EditType.REWARD_REMOVE);
            break;
        }
    }

    @SideOnly(value=Side.CLIENT)
    private int getTaskY(GuiQuestBook gui, int id) {
        return 100 + id * 11;
    }

    @SideOnly(value=Side.CLIENT)
    public void onClick(GuiQuestBook gui, EntityPlayer player, int mX, int mY, int b) {
        if (b == 1) {
            gui.loadMap();
        } else {
            int id = 0;
            int start = this.taskScroll.isVisible(gui) ? Math.round((float)(this.getVisibleTasks(gui) - 3) * this.taskScroll.getScroll()) : 0;
            int end = Math.min(start + 3, this.tasks.size());
            for (int i = start; i < end; ++i) {
                QuestTask task = this.tasks.get(i);
                if (!task.isVisible(player) && !isEditing) continue;
                if (gui.inBounds(20, this.getTaskY(gui, id), gui.getStringWidth(task.getDescription()), 9, mX, mY)) {
                    if (isEditing && gui.getCurrentMode() != EditMode.NORMAL) {
                        if (gui.getCurrentMode() == EditMode.RENAME) {
                            gui.setEditMenu(new GuiEditMenuTextEditor(gui, player, task, true));
                            break;
                        }
                        if (gui.getCurrentMode() != EditMode.DELETE) break;
                        if (i + 1 < this.tasks.size()) {
                            this.tasks.get(i + 1).clearRequirements();
                            if (i > 0) {
                                this.tasks.get(i + 1).addRequirement(this.tasks.get(i - 1));
                            }
                        }
                        if (this.selectedTask == task) {
                            this.selectedTask = null;
                        }
                        task.onDelete();
                        this.tasks.remove(i);
                        this.nextTaskId = 0;
                        for (QuestTask questTask : this.tasks) {
                            questTask.updateId();
                        }
                        this.addTaskData(this.getQuestData(player));
                        SaveHelper.add(SaveHelper.EditType.TASK_REMOVE);
                        break;
                    }
                    if (task == this.selectedTask) {
                        this.selectedTask = null;
                        break;
                    }
                    this.selectedTask = task;
                    this.taskDescriptionScroll.resetScroll();
                    break;
                }
                ++id;
            }
            for (ScrollBar scrollBar : this.scrollBars) {
                scrollBar.onClick(gui, mX, mY);
            }
            if (!this.rewards.isEmpty() || isEditing) {
                this.handleRewardClick(gui, player, this.rewards.toArray(), 150, false, mX, mY);
                if (!this.rewardChoices.isEmpty() || isEditing) {
                    this.handleRewardClick(gui, player, this.rewardChoices.toArray(), 190, true, mX, mY);
                }
            } else if (!this.rewardChoices.isEmpty()) {
                this.handleRewardClick(gui, player, this.rewardChoices.toArray(), 150, true, mX, mY);
            }
            if (this.selectedTask != null) {
                this.selectedTask.onClick(gui, player, mX, mY, b);
            }
            for (LargeButton button : this.buttons) {
                if (!button.inButtonBounds(gui, mX, mY) || !button.isVisible(gui, player) || !button.isEnabled(gui, player)) continue;
                button.onClick(gui, player);
                break;
            }
            if (gui.getCurrentMode() == EditMode.RENAME) {
                if (gui.inBounds(20, 15, 140, 9, mX, mY)) {
                    gui.setEditMenu(new GuiEditMenuTextEditor(gui, player, this, true));
                } else if (gui.inBounds(20, 30, 130, 44, mX, mY)) {
                    gui.setEditMenu(new GuiEditMenuTextEditor(gui, player, this, false));
                } else if (this.selectedTask != null && gui.inBounds(180, 20, 130, 44, mX, mY)) {
                    gui.setEditMenu(new GuiEditMenuTextEditor(gui, player, this.selectedTask, false));
                }
            }
            if (isEditing && this.selectedTask != null && gui.getCurrentMode() == EditMode.TASK) {
                this.selectedTask = null;
            }
            if (isEditing && gui.getCurrentMode() == EditMode.REPUTATION_REWARD) {
                int y;
                int n = this.rewards == null || this.rewards.size() <= 7 - (isEditing ? 2 : 1) ? 150 : (y = 133);
                if (gui.inBounds(142, y, 16, 16, mX, mY)) {
                    gui.setEditMenu(new GuiEditMenuReputationReward((GuiBase)gui, player, this.reputationRewards));
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void onDrag(GuiQuestBook gui, EntityPlayer player, int mX, int mY, int b) {
        for (ScrollBar scrollBar : this.scrollBars) {
            scrollBar.onDrag(gui, mX, mY);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void onRelease(GuiQuestBook gui, EntityPlayer player, int mX, int mY, int b) {
        for (ScrollBar scrollBar : this.scrollBars) {
            scrollBar.onRelease(gui, mX, mY);
        }
    }

    public QuestData createData(int players) {
        QuestData data = new QuestData(players);
        if (!this.addTaskData(data)) {
            return null;
        }
        return data;
    }

    public boolean addTaskData(QuestData data) {
        data.tasks = new QuestDataTask[this.tasks.size()];
        for (int i = 0; i < this.tasks.size(); ++i) {
            try {
                QuestDataTask obj;
                Constructor<? extends QuestDataTask> constructor = this.tasks.get(i).getDataType().getConstructor(QuestTask.class);
                data.tasks[i] = obj = constructor.newInstance(this.tasks.get(i));
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return false;
            }
        }
        return true;
    }

    public void initRewards(int players, QuestData data) {
        data.reward = new boolean[players];
    }

    public List<QuestTask> getTasks() {
        return this.tasks;
    }

    public void sendUpdatedDataToTeam(EntityPlayer player) {
        this.sendUpdatedDataToTeam(QuestingData.getQuestingData(player).getTeam());
    }

    public void sendUpdatedDataToTeam(String uuid) {
        this.sendUpdatedDataToTeam(QuestingData.getQuestingData(uuid).getTeam());
    }

    public void sendUpdatedDataToTeam(Team team) {
        for (PlayerEntry entry : team.getPlayers()) {
            this.sendUpdatedData(entry.getPlayerMP());
        }
    }

    private void sendUpdatedData(EntityPlayerMP player) {
        if (player == null) {
            return;
        }
        QuestDataUpdateMessage update = new QuestDataUpdateMessage(this.getId(), QuestingData.getQuestingData((EntityPlayer)player).getTeam().getPlayerCount(), QuestingData.getQuestingData((EntityPlayer)player).getQuestData(this.getId()));
        NetworkManager.sendToPlayer(update, player);
    }

    public void claimReward(EntityPlayer player, int selectedReward) {
        if (this.hasReward(player)) {
            boolean sentInfo = false;
            if (!(!this.getQuestData(player).getReward(player) || this.rewards.isEmpty() && this.rewardChoices.isEmpty())) {
                ArrayList<ItemStack> items = new ArrayList<ItemStack>();
                if (!this.rewards.isEmpty()) {
                    for (ItemStack stack : this.rewards.toArray()) {
                        items.add(stack.func_77946_l());
                    }
                }
                if (!this.rewardChoices.isEmpty()) {
                    if (selectedReward >= 0 && selectedReward < this.rewardChoices.size()) {
                        items.add(((ItemStack)this.rewardChoices.getReward(selectedReward)).func_77946_l());
                    } else {
                        return;
                    }
                }
                ArrayList<ItemStack> itemsToAdd = new ArrayList<ItemStack>();
                for (ItemStack stack : items) {
                    boolean added = false;
                    for (ItemStack stack1 : itemsToAdd) {
                        if (!stack.func_77969_a(stack1) || !ItemStack.func_77970_a((ItemStack)stack, (ItemStack)stack1)) continue;
                        stack1.field_77994_a += stack.field_77994_a;
                        added = true;
                        break;
                    }
                    if (added) continue;
                    itemsToAdd.add(stack.func_77946_l());
                }
                ArrayList<ItemStack> itemsToCheck = new ArrayList<ItemStack>();
                for (ItemStack stack : itemsToAdd) {
                    itemsToCheck.add(stack.func_77946_l());
                }
                block4: for (int i = 0; i < player.field_71071_by.field_70462_a.length; ++i) {
                    for (ItemStack stack1 : itemsToCheck) {
                        if (stack1.field_77994_a <= 0) continue;
                        ItemStack stack = player.field_71071_by.field_70462_a[i];
                        if (stack == null) {
                            stack1.field_77994_a -= stack1.func_77976_d();
                            continue block4;
                        }
                        if (!stack.func_77969_a(stack1) || !ItemStack.func_77970_a((ItemStack)stack1, (ItemStack)stack)) continue;
                        stack1.field_77994_a = stack1.field_77994_a - stack1.func_77976_d() - stack.field_77994_a;
                        continue block4;
                    }
                }
                boolean valid = true;
                for (ItemStack stack : itemsToCheck) {
                    if (stack.field_77994_a <= 0) continue;
                    valid = false;
                    break;
                }
                if (valid) {
                    Quest.addItems(player, itemsToAdd);
                    player.field_71071_by.func_70296_d();
                    QuestData data = this.getQuestData(player);
                    Team team = QuestingData.getQuestingData(player).getTeam();
                    if (!team.isSingle() && team.getRewardSetting() == RewardSetting.ANY) {
                        for (int i = 0; i < data.reward.length; ++i) {
                            data.reward[i] = false;
                        }
                        this.sendUpdatedDataToTeam(player);
                    } else {
                        data.claimReward(player);
                        if (player instanceof EntityPlayerMP) {
                            this.sendUpdatedData((EntityPlayerMP)player);
                        }
                    }
                    sentInfo = true;
                } else {
                    return;
                }
            }
            if (this.reputationRewards != null && this.getQuestData(player).canClaim()) {
                this.getQuestData((EntityPlayer)player).claimed = true;
                QuestingData.getQuestingData(player).getTeam().receiveAndSyncReputation(this, this.reputationRewards);
                EventHandler.instance().onEvent(new EventHandler.ReputationEvent(player));
                sentInfo = true;
            }
            if (this.commandRewardList != null && this.getQuestData(player).canClaim()) {
                this.getQuestData((EntityPlayer)player).claimed = true;
                this.commandRewardList.executeAll(player);
                sentInfo = true;
            }
            if (sentInfo) {
                SoundHandler.play(Sounds.COMPLETE, player);
            }
        }
    }

    public void setBigIcon(boolean b) {
        this.isBig = b;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
        this.cachedDescription = null;
    }

    public void setItem(GuiEditMenuItem.Element element, int id, GuiEditMenuItem.Type type, ItemPrecision precision, EntityPlayer player) {
        if (type == GuiEditMenuItem.Type.REWARD || type == GuiEditMenuItem.Type.PICK_REWARD) {
            ItemStack stack;
            if (element instanceof GuiEditMenuItem.ElementItem && (stack = (ItemStack)((GuiEditMenuItem.ElementItem)element).getFluidStack()) != null) {
                stack.field_77994_a = Math.min(127, element.getAmount());
                this.setReward(stack, id, type == GuiEditMenuItem.Type.REWARD);
            }
        } else if (this.selectedTask != null && this.selectedTask instanceof QuestTaskItems) {
            ((QuestTaskItems)this.selectedTask).setItem(element, id, precision);
        } else if (this.selectedTask != null && this.selectedTask instanceof QuestTaskLocation && type == GuiEditMenuItem.Type.LOCATION) {
            ((QuestTaskLocation)this.selectedTask).setIcon(id, (ItemStack)element.getFluidStack(), player);
        } else if (this.selectedTask != null && this.selectedTask instanceof QuestTaskMob && type == GuiEditMenuItem.Type.MOB) {
            ((QuestTaskMob)this.selectedTask).setIcon(id, (ItemStack)element.getFluidStack(), player);
        }
    }

    private void setReward(ItemStack stack, int id, boolean isStandardReward) {
        ItemStackRewardList rewardList;
        ItemStackRewardList itemStackRewardList = rewardList = isStandardReward ? this.rewards : this.rewardChoices;
        if (id < rewardList.size()) {
            rewardList.set(id, stack);
            SaveHelper.add(SaveHelper.EditType.REWARD_CHANGE);
        } else {
            SaveHelper.add(SaveHelper.EditType.REWARD_CREATE);
            rewardList.add(stack);
        }
    }

    public boolean hasSameSetAs(Quest child) {
        return child.set.equals(this.set);
    }

    @SideOnly(value=Side.CLIENT)
    public void onScroll(GuiQuestBook gui, int x, int y, int scroll) {
        for (ScrollBar scrollBar : this.scrollBars) {
            scrollBar.onScroll(gui, x, y, scroll);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void onOpen(GuiQuestBook gui, EntityPlayer player) {
        if (this.selectedTask == null) {
            for (QuestTask task : this.tasks) {
                if (task.isCompleted(player)) continue;
                this.selectedTask = task;
                break;
            }
        }
        if (this.selectedTask == null && this.tasks.size() > 0) {
            this.selectedTask = this.tasks.get(0);
        }
        QuestingData.getQuestingData((EntityPlayer)player).selectedQuest = this.getId();
        int n = QuestingData.getQuestingData((EntityPlayer)player).selectedTask = this.selectedTask == null ? -1 : this.selectedTask.getId();
        if (this.selectedTask != null) {
            NetworkManager.sendToServer(ClientChange.SELECT_QUEST.build(this.selectedTask));
        }
    }

    public boolean hasSet(QuestSet selectedSet) {
        return this.set != null && this.set.equals(selectedSet);
    }

    public void mergeProgress(String playerName, QuestData own, QuestData other) {
        if (other.completed) {
            own.completed = true;
            if (other.available && !own.claimed) {
                own.available = true;
            }
        }
        for (int i = 0; i < own.tasks.length; ++i) {
            QuestTask task = this.tasks.get(i);
            own.tasks[i] = task.validateData(own.tasks[i]);
            task.mergeProgress(playerName, own.tasks[i], task.validateData(other.tasks[i]));
        }
    }

    public void copyProgress(QuestData own, QuestData other) {
        own.completed = other.completed;
        own.available = other.available;
        for (int i = 0; i < own.tasks.length; ++i) {
            QuestTask task = this.tasks.get(i);
            own.tasks[i] = task.validateData(own.tasks[i]);
            task.copyProgress(own.tasks[i], task.validateData(other.tasks[i]));
        }
    }

    public void completeQuest(EntityPlayer player) {
        for (QuestTask task : this.tasks) {
            task.autoComplete(QuestingData.getUserUUID(player));
            task.getData((EntityPlayer)player).completed = true;
        }
        QuestTask.completeQuest(this, QuestingData.getUserUUID(player));
    }

    public void reset(String playerName) {
        this.reset(this.getQuestData(playerName));
    }

    public void reset(QuestData data) {
        data.available = true;
        this.addTaskData(data);
    }

    public void resetAll() {
        for (Team team : QuestingData.getAllTeams()) {
            QuestData data = team.getQuestData(this.getId());
            if (data == null || data.available) continue;
            this.reset(data);
            this.sendUpdatedDataToTeam(team);
        }
    }

    public void resetOnTime(int time) {
        for (Team team : QuestingData.getAllTeams()) {
            QuestData data = team.getQuestData(this.getId());
            if (data == null || data.available || data.time > time) continue;
            this.reset(data);
            this.sendUpdatedDataToTeam(team);
        }
    }

    public float getProgress(Team team) {
        String name = team.getPlayers().get(0).getUUID();
        float data = 0.0f;
        for (QuestTask task : this.tasks) {
            data += task.getCompletedRatio(name);
        }
        return data / (float)this.tasks.size();
    }

    public List<Quest> getOptionLinks() {
        return QuestLine.getActiveQuestLine().quests.values().stream().filter(quest -> this.optionLinks.contains(quest.getId())).collect(Collectors.toList());
    }

    public List<Quest> getReversedOptionLinks() {
        return QuestLine.getActiveQuestLine().quests.values().stream().filter(quest -> this.reversedOptionLinks.contains(quest.getId())).collect(Collectors.toList());
    }

    public boolean getUseModifiedParentRequirement() {
        return this.useModifiedParentRequirement;
    }

    public void setUseModifiedParentRequirement(boolean useModifiedParentRequirement) {
        this.useModifiedParentRequirement = useModifiedParentRequirement;
    }

    public int getParentRequirementCount() {
        return this.parentRequirementCount;
    }

    public void setParentRequirementCount(int parentRequirementCount) {
        this.parentRequirementCount = parentRequirementCount;
    }

    public QuestSet getQuestSet() {
        return this.set;
    }

    public void setQuestSet(QuestSet set) {
        if (this.set != null) {
            this.set.removeQuest(this);
        }
        this.set = set;
        if (this.set != null) {
            this.set.addQuest(this);
        }
    }

    public List<Quest> getReversedRequirement() {
        return QuestLine.getActiveQuestLine().quests.values().stream().filter(quest -> this.reversedRequirement.contains(quest.getId())).collect(Collectors.toList());
    }

    private abstract class ParentEvaluator {
        private ParentEvaluator() {
        }

        protected abstract boolean isValid(String var1, Quest var2, Map<Quest, Boolean> var3, Map<Quest, Boolean> var4);

        private boolean isValid(String playerName, Map<Quest, Boolean> isVisibleCache, Map<Quest, Boolean> isLinkFreeCache) {
            int requiredAmount;
            int parents = Quest.this.getRequirements().size();
            int n = requiredAmount = Quest.this.useModifiedParentRequirement ? Quest.this.parentRequirementCount : parents;
            if (requiredAmount > parents) {
                return false;
            }
            int allowedUncompleted = parents - requiredAmount;
            int uncompleted = 0;
            for (Quest quest : Quest.this.getRequirements()) {
                if (this.isValid(playerName, quest, isVisibleCache, isLinkFreeCache) || ++uncompleted <= allowedUncompleted) continue;
                return false;
            }
            return true;
        }
    }

    public static enum TaskType {
        CONSUME(QuestTaskItemsConsume.class, "consume"),
        CRAFT(QuestTaskItemsCrafting.class, "craft"),
        LOCATION(QuestTaskLocation.class, "location"),
        CONSUME_QDS(QuestTaskItemsConsumeQDS.class, "consumeQDS"),
        DETECT(QuestTaskItemsDetect.class, "detect"),
        KILL(QuestTaskMob.class, "kill"),
        DEATH(QuestTaskDeath.class, "death"),
        REPUTATION(QuestTaskReputationTarget.class, "reputation"),
        REPUTATION_KILL(QuestTaskReputationKill.class, "reputationKill");

        private final Class<? extends QuestTask> clazz;
        private final String id;

        private TaskType(Class<? extends QuestTask> clazz, String id) {
            this.clazz = clazz;
            this.id = id;
        }

        public static TaskType getType(Class<? extends QuestTask> clazz) {
            for (TaskType type : TaskType.values()) {
                if (type.clazz != clazz) continue;
                return type;
            }
            return CONSUME;
        }

        public QuestTask addTask(Quest quest) {
            QuestTask prev = quest.getTasks().size() > 0 ? quest.getTasks().get(quest.getTasks().size() - 1) : null;
            try {
                Constructor<? extends QuestTask> ex = this.clazz.getConstructor(Quest.class, String.class, String.class);
                QuestTask task = ex.newInstance(quest, this.getName(), this.getDescription());
                if (prev != null) {
                    task.addRequirement(prev);
                }
                quest.getTasks().add(task);
                SaveHelper.add(SaveHelper.EditType.TASK_CREATE);
                return task;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }

        public String getLangKeyDescription() {
            return "hqm.taskType." + this.id + ".desc";
        }

        public String getLangKeyName() {
            return "hqm.taskType." + this.id + ".title";
        }

        public String getDescription() {
            return Translator.translate(this.getLangKeyDescription());
        }

        public String getName() {
            return Translator.translate(this.getLangKeyName());
        }
    }
}

