/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.quests;

import com.google.common.collect.ImmutableList;
import hardcorequesting.util.OreDictionaryHelper;
import hardcorequesting.util.Translator;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.item.ItemStack;

public abstract class ItemPrecision {
    public static final ItemPrecision PRECISE = new ItemPrecision("precise"){

        @Override
        protected boolean same(ItemStack stack1, ItemStack stack2) {
            return stack1.func_77973_b() == stack2.func_77973_b() && stack1.func_77952_i() == stack2.func_77952_i() && ItemStack.func_77970_a((ItemStack)stack1, (ItemStack)stack2);
        }
    };
    public static final ItemPrecision NBT_FUZZY = new ItemPrecision("nbtFuzzy"){

        @Override
        protected boolean same(ItemStack stack1, ItemStack stack2) {
            return stack1.func_77973_b() == stack2.func_77973_b() && stack1.func_77952_i() == stack2.func_77952_i();
        }
    };
    public static final ItemPrecision FUZZY = new ItemPrecision("fuzzy", true){

        @Override
        protected boolean same(ItemStack stack1, ItemStack stack2) {
            return stack1.func_77973_b() == stack2.func_77973_b();
        }

        @Override
        public ItemStack[] getPermutations(ItemStack stack) {
            ArrayList items = new ArrayList();
            stack.func_77973_b().func_150895_a(stack.func_77973_b(), null, items);
            return items.toArray(new ItemStack[items.size()]);
        }
    };
    public static final ItemPrecision ORE_DICTIONARY = new ItemPrecision("oreDict", true){

        @Override
        protected boolean same(ItemStack stack1, ItemStack stack2) {
            return OreDictionaryHelper.match(stack1, stack2) || PRECISE.same(stack1, stack2);
        }

        @Override
        public ItemStack[] getPermutations(ItemStack stack) {
            return OreDictionaryHelper.getPermutations(stack);
        }
    };
    private static final LinkedHashMap<String, ItemPrecision> precisionTypes = new LinkedHashMap();
    protected boolean hasPermutations = false;
    private String tag;

    public ItemPrecision(String tag) {
        this.tag = tag;
    }

    public ItemPrecision(String tag, boolean hasPermutations) {
        this(tag);
        this.hasPermutations = hasPermutations;
    }

    public static boolean registerPrecisionType(String uniqueID, ItemPrecision p) {
        if (uniqueID == null || p == null) {
            return false;
        }
        if (!precisionTypes.containsKey(uniqueID)) {
            precisionTypes.put(uniqueID, p);
            return true;
        }
        return false;
    }

    public static ImmutableList<ItemPrecision> getPrecisionTypes() {
        return ImmutableList.copyOf(precisionTypes.values());
    }

    public static ItemPrecision getPrecisionType(String uniqueID) {
        return precisionTypes.containsKey(uniqueID) ? precisionTypes.get(uniqueID) : PRECISE;
    }

    public static ItemPrecision getOldPrecisionType(int ordinal) {
        switch (ordinal) {
            case 1: {
                return NBT_FUZZY;
            }
            case 2: {
                return FUZZY;
            }
            case 3: {
                return ORE_DICTIONARY;
            }
        }
        return PRECISE;
    }

    public static String getUniqueID(ItemPrecision p) {
        for (Map.Entry<String, ItemPrecision> entry : precisionTypes.entrySet()) {
            if (entry.getValue() != p) continue;
            return entry.getKey();
        }
        return "PRECISE";
    }

    protected abstract boolean same(ItemStack var1, ItemStack var2);

    public final boolean areItemsSame(ItemStack stack1, ItemStack stack2) {
        return stack1 == null && stack2 == null || stack1 != null && stack2 != null && this.same(stack1, stack2);
    }

    public String toString() {
        return this.tag;
    }

    public String getLocalizationTag() {
        return "hqm.precision." + this.tag;
    }

    public String getName() {
        return Translator.translate(this.getLocalizationTag());
    }

    public boolean hasPermutations() {
        return this.hasPermutations;
    }

    public ItemStack[] getPermutations(ItemStack stack) {
        return new ItemStack[0];
    }

    static {
        ItemPrecision.registerPrecisionType("PRECISE", PRECISE);
        ItemPrecision.registerPrecisionType("NBT_FUZZY", NBT_FUZZY);
        ItemPrecision.registerPrecisionType("FUZZY", FUZZY);
        ItemPrecision.registerPrecisionType("ORE_DICTIONARY", ORE_DICTIONARY);
    }
}

