/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.network.message;

import hardcorequesting.team.Team;
import hardcorequesting.team.TeamStats;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class TeamStatsMessage
implements IMessage {
    private List<TeamStats> stats;

    public TeamStatsMessage() {
    }

    public TeamStatsMessage(Team team) {
        this.stats = new ArrayList<TeamStats>();
        this.stats.add(team.toStat());
    }

    public TeamStatsMessage(List<Team> teams) {
        this.stats = teams.stream().map(Team::toStat).collect(Collectors.toList());
    }

    public void fromBytes(ByteBuf buf) {
        int size = buf.readInt();
        this.stats = new ArrayList<TeamStats>();
        for (int i = 0; i < size; ++i) {
            int ssize = buf.readInt();
            String name = null;
            if (ssize != -1) {
                name = new String(buf.readBytes(ssize).array());
            }
            int players = buf.readInt();
            int lives = buf.readInt();
            float progress = buf.readFloat();
            this.stats.add(new TeamStats(name, players, lives, progress));
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.stats.size());
        for (TeamStats teamStats : this.stats) {
            if (teamStats.getName() != null) {
                buf.writeInt(teamStats.getName().getBytes().length);
                buf.writeBytes(teamStats.getName().getBytes());
            } else {
                buf.writeInt(-1);
            }
            buf.writeInt(teamStats.getPlayers());
            buf.writeInt(teamStats.getLives());
            buf.writeFloat(teamStats.getProgress());
        }
    }

    public static class Handler
    implements IMessageHandler<TeamStatsMessage, IMessage> {
        public IMessage onMessage(TeamStatsMessage message, MessageContext ctx) {
            Minecraft.func_71410_x().func_152344_a(() -> this.handle(message, ctx));
            return null;
        }

        private void handle(TeamStatsMessage message, MessageContext ctx) {
            if (message.stats.size() == 1) {
                TeamStats.updateTeam((TeamStats)message.stats.get(0));
            } else {
                TeamStats.updateTeams(message.stats);
            }
        }
    }
}

