/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.network.message;

import hardcorequesting.team.TeamAction;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class TeamMessage
implements IMessage {
    private TeamAction action;
    private String data;

    public TeamMessage() {
    }

    public TeamMessage(TeamAction action, String data) {
        this.action = action;
        this.data = data;
    }

    public void fromBytes(ByteBuf buf) {
        this.action = TeamAction.values()[buf.readInt()];
        int size = buf.readInt();
        this.data = new String(buf.readBytes(size).array());
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.action.ordinal());
        buf.writeInt(this.data.getBytes().length);
        buf.writeBytes(this.data.getBytes());
    }

    public static class Handler
    implements IMessageHandler<TeamMessage, IMessage> {
        public IMessage onMessage(TeamMessage message, MessageContext ctx) {
            FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> this.handle(message, ctx));
            return null;
        }

        private void handle(TeamMessage message, MessageContext ctx) {
            message.action.process((EntityPlayer)ctx.getServerHandler().field_147369_b, message.data);
        }
    }
}

