/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.network.message;

import hardcorequesting.HardcoreQuesting;
import hardcorequesting.io.adapter.QuestDataAdapter;
import hardcorequesting.quests.Quest;
import hardcorequesting.quests.QuestData;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class QuestDataUpdateMessage
implements IMessage {
    private String id;
    private String data;
    private int players;

    public QuestDataUpdateMessage() {
    }

    public QuestDataUpdateMessage(String id, int players, QuestData data) {
        try {
            this.id = id;
            this.data = QuestDataAdapter.QUEST_DATA_ADAPTER.toJson((Object)data);
            this.players = players;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void fromBytes(ByteBuf buf) {
        this.players = buf.readInt();
        int size = buf.readInt();
        this.id = new String(buf.readBytes(size).array());
        size = buf.readInt();
        this.data = new String(buf.readBytes(size).array());
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.players);
        buf.writeInt(this.id.getBytes().length);
        buf.writeBytes(this.id.getBytes());
        buf.writeInt(this.data.getBytes().length);
        buf.writeBytes(this.data.getBytes());
    }

    public static class Handler
    implements IMessageHandler<QuestDataUpdateMessage, IMessage> {
        public IMessage onMessage(QuestDataUpdateMessage message, MessageContext ctx) {
            Minecraft.func_71410_x().func_152344_a(() -> this.handle(message, ctx));
            return null;
        }

        private void handle(QuestDataUpdateMessage message, MessageContext ctx) {
            try {
                QuestData data = (QuestData)QuestDataAdapter.QUEST_DATA_ADAPTER.fromJson(message.data);
                Quest quest = Quest.getQuest(message.id);
                if (quest != null) {
                    quest.setQuestData(HardcoreQuesting.proxy.getPlayer(ctx), data);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

