/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.network.message;

import hardcorequesting.io.SaveHandler;
import hardcorequesting.quests.QuestLine;
import hardcorequesting.quests.QuestingData;
import hardcorequesting.team.Team;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.io.PrintWriter;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PlayerDataSyncMessage
implements IMessage {
    private boolean local;
    private boolean serverWorld;
    private boolean questing;
    private boolean hardcore;
    private String team;
    private String data;

    public PlayerDataSyncMessage() {
    }

    public PlayerDataSyncMessage(boolean local, boolean serverWorld, EntityPlayer player) {
        this.local = local;
        this.serverWorld = serverWorld;
        this.questing = QuestingData.isQuestActive();
        this.hardcore = QuestingData.isHardcoreActive();
        this.team = Team.saveTeam(player);
        this.data = QuestingData.saveQuestingData(player);
    }

    public void fromBytes(ByteBuf buf) {
        this.local = buf.readBoolean();
        this.serverWorld = buf.readBoolean();
        this.questing = buf.readBoolean();
        this.hardcore = buf.readBoolean();
        int size = buf.readInt();
        this.team = new String(buf.readBytes(size).array());
        size = buf.readInt();
        this.data = new String(buf.readBytes(size).array());
    }

    public void toBytes(ByteBuf buf) {
        buf.writeBoolean(this.local);
        buf.writeBoolean(this.serverWorld);
        buf.writeBoolean(this.questing);
        buf.writeBoolean(this.hardcore);
        buf.writeInt(this.team.getBytes().length);
        buf.writeBytes(this.team.getBytes());
        buf.writeInt(this.data.getBytes().length);
        buf.writeBytes(this.data.getBytes());
    }

    public static class Handler
    implements IMessageHandler<PlayerDataSyncMessage, IMessage> {
        public IMessage onMessage(PlayerDataSyncMessage message, MessageContext ctx) {
            Minecraft.func_71410_x().func_152344_a(() -> this.handle(message, ctx));
            return null;
        }

        private void handle(PlayerDataSyncMessage message, MessageContext ctx) {
            if (!QuestLine.doServerSync) {
                SaveHandler.copyFolder(SaveHandler.getDefaultFolder(), SaveHandler.getRemoteFolder());
            }
            try {
                try (PrintWriter out = new PrintWriter(SaveHandler.getRemoteFile("teams"));){
                    out.print("[");
                    out.print(message.team);
                    out.print("]");
                }
                out = new PrintWriter(SaveHandler.getRemoteFile("data"));
                var4_5 = null;
                try {
                    out.print("[");
                    out.print(message.data);
                    out.print("]");
                }
                catch (Throwable throwable) {
                    var4_5 = throwable;
                    throw throwable;
                }
                finally {
                    if (out != null) {
                        if (var4_5 != null) {
                            try {
                                out.close();
                            }
                            catch (Throwable throwable) {
                                var4_5.addSuppressed(throwable);
                            }
                        } else {
                            out.close();
                        }
                    }
                }
                out = new PrintWriter(SaveHandler.getRemoteFile("state"));
                var4_5 = null;
                try {
                    out.print(SaveHandler.saveQuestingState(message.questing, message.hardcore));
                }
                catch (Throwable throwable) {
                    var4_5 = throwable;
                    throw throwable;
                }
                finally {
                    if (out != null) {
                        if (var4_5 != null) {
                            try {
                                out.close();
                            }
                            catch (Throwable throwable) {
                                var4_5.addSuppressed(throwable);
                            }
                        } else {
                            out.close();
                        }
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            QuestLine.receiveServerSync(message.local, message.serverWorld);
        }
    }
}

