/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.network.message;

import hardcorequesting.death.DeathStats;
import hardcorequesting.io.SaveHandler;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.io.PrintWriter;
import net.minecraft.client.Minecraft;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class DeathStatsMessage
implements IMessage {
    private boolean local;
    private String deaths;

    public DeathStatsMessage() {
    }

    public DeathStatsMessage(boolean local) {
        this.local = local;
        if (local) {
            DeathStats.saveAll();
        }
        this.deaths = SaveHandler.saveDeaths();
    }

    public void fromBytes(ByteBuf buf) {
        this.local = buf.readBoolean();
        if (this.local) {
            return;
        }
        int size = buf.readInt();
        this.deaths = new String(buf.readBytes(size).array());
    }

    public void toBytes(ByteBuf buf) {
        buf.writeBoolean(this.local);
        if (this.local) {
            return;
        }
        buf.writeInt(this.deaths.getBytes().length);
        buf.writeBytes(this.deaths.getBytes());
    }

    public static class Handler
    implements IMessageHandler<DeathStatsMessage, IMessage> {
        public IMessage onMessage(DeathStatsMessage message, MessageContext ctx) {
            Minecraft.func_71410_x().func_152344_a(() -> this.handle(message, ctx));
            return null;
        }

        private void handle(DeathStatsMessage message, MessageContext ctx) {
            if (!message.local) {
                try (PrintWriter out = new PrintWriter(SaveHandler.getRemoteFile("deaths"));){
                    out.print(message.deaths);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            DeathStats.loadAll(true, !message.local);
        }
    }
}

