/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.network;

import com.google.gson.stream.JsonWriter;
import hardcorequesting.network.message.BlockSyncMessage;
import hardcorequesting.network.message.BlockSyncMessageClient;
import hardcorequesting.network.message.ClientUpdateMessage;
import hardcorequesting.network.message.CloseBookMessage;
import hardcorequesting.network.message.DeathStatsMessage;
import hardcorequesting.network.message.LivesUpdate;
import hardcorequesting.network.message.OpActionMessage;
import hardcorequesting.network.message.OpenGuiMessage;
import hardcorequesting.network.message.PlayerDataSyncMessage;
import hardcorequesting.network.message.QuestDataUpdateMessage;
import hardcorequesting.network.message.QuestLineSyncMessage;
import hardcorequesting.network.message.SoundMessage;
import hardcorequesting.network.message.TeamErrorMessage;
import hardcorequesting.network.message.TeamMessage;
import hardcorequesting.network.message.TeamStatsMessage;
import hardcorequesting.network.message.TeamUpdateMessage;
import hardcorequesting.tileentity.IBlockSync;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;

public class NetworkManager {
    private static final SimpleNetworkWrapper WRAPPER = new SimpleNetworkWrapper("hcQuesting");
    private static int id = 0;

    public static void init() {
        WRAPPER.registerMessage(OpenGuiMessage.Handler.class, OpenGuiMessage.class, id++, Side.CLIENT);
        WRAPPER.registerMessage(CloseBookMessage.Handler.class, CloseBookMessage.class, id++, Side.CLIENT);
        WRAPPER.registerMessage(QuestLineSyncMessage.Handler.class, QuestLineSyncMessage.class, id++, Side.CLIENT);
        WRAPPER.registerMessage(PlayerDataSyncMessage.Handler.class, PlayerDataSyncMessage.class, id++, Side.CLIENT);
        WRAPPER.registerMessage(TeamStatsMessage.Handler.class, TeamStatsMessage.class, id++, Side.CLIENT);
        WRAPPER.registerMessage(TeamErrorMessage.Handler.class, TeamErrorMessage.class, id++, Side.CLIENT);
        WRAPPER.registerMessage(QuestDataUpdateMessage.Handler.class, QuestDataUpdateMessage.class, id++, Side.CLIENT);
        WRAPPER.registerMessage(DeathStatsMessage.Handler.class, DeathStatsMessage.class, id++, Side.CLIENT);
        WRAPPER.registerMessage(TeamUpdateMessage.Handler.class, TeamUpdateMessage.class, id++, Side.CLIENT);
        WRAPPER.registerMessage(SoundMessage.Handler.class, SoundMessage.class, id++, Side.CLIENT);
        WRAPPER.registerMessage(LivesUpdate.Handler.class, LivesUpdate.class, id++, Side.CLIENT);
        WRAPPER.registerMessage(BlockSyncMessageClient.Handler.class, BlockSyncMessageClient.class, id++, Side.CLIENT);
        WRAPPER.registerMessage(BlockSyncMessage.Handler.class, BlockSyncMessage.class, id++, Side.SERVER);
        WRAPPER.registerMessage(TeamMessage.Handler.class, TeamMessage.class, id++, Side.SERVER);
        WRAPPER.registerMessage(ClientUpdateMessage.Handler.class, ClientUpdateMessage.class, id++, Side.SERVER);
        WRAPPER.registerMessage(OpActionMessage.Handler.class, OpActionMessage.class, id++, Side.SERVER);
    }

    public static void sendToPlayer(IMessage message, EntityPlayerMP player) {
        WRAPPER.sendTo(message, player);
    }

    public static void sendToAllPlayers(IMessage message) {
        WRAPPER.sendToAll(message);
    }

    public static void sendToServer(IMessage message) {
        WRAPPER.sendToServer(message);
    }

    public static void sendToPlayersAround(IMessage message, TileEntity te, double radius) {
        WRAPPER.sendToAllAround(message, NetworkManager.asTarget(te, radius));
    }

    public static NetworkRegistry.TargetPoint asTarget(TileEntity te, double radius) {
        return new NetworkRegistry.TargetPoint(te.func_145831_w().field_73011_w.getDimension(), (double)te.func_174877_v().func_177958_n(), (double)te.func_174877_v().func_177956_o(), (double)te.func_174877_v().func_177952_p(), radius);
    }

    public static <T extends TileEntity> void sendBlockUpdate(T block, EntityPlayer player, int type) {
        StringWriter data = new StringWriter();
        boolean onServer = !block.func_145831_w().field_72995_K;
        try {
            JsonWriter writer = new JsonWriter((Writer)data);
            writer.beginObject();
            ((IBlockSync)block).writeData(player, onServer, type, writer);
            writer.endObject();
            writer.close();
        }
        catch (IOException e) {
            return;
        }
        if (!onServer) {
            NetworkManager.sendToServer(new BlockSyncMessageClient(block, type, data.toString()));
        } else {
            BlockSyncMessage message = new BlockSyncMessage(block, type, data.toString());
            if (player instanceof EntityPlayerMP) {
                NetworkManager.sendToPlayer(message, (EntityPlayerMP)player);
            } else {
                NetworkManager.sendToPlayersAround(message, block, 128.0);
            }
        }
    }
}

