/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.items;

import hardcorequesting.HardcoreQuesting;
import hardcorequesting.client.interfaces.GuiColor;
import hardcorequesting.client.interfaces.GuiType;
import hardcorequesting.commands.CommandHandler;
import hardcorequesting.items.ModItems;
import hardcorequesting.network.NetworkManager;
import hardcorequesting.quests.QuestingData;
import hardcorequesting.util.Translator;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemQuestBook
extends Item {
    private static final String NBT_PLAYER = "UseAsPlayer";

    public ItemQuestBook() {
        this.func_77637_a(HardcoreQuesting.HQMTab);
        this.func_77625_d(1);
        this.setRegistryName("quest_book");
        this.func_77655_b("hqm:quest_book");
    }

    public static ItemStack getOPBook(EntityPlayer player) {
        ItemStack stack = new ItemStack((Item)ModItems.book, 1, 1);
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74778_a(NBT_PLAYER, player.getPersistentID().toString());
        stack.func_77982_d(nbt);
        return stack;
    }

    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        ModelLoader.setCustomModelResourceLocation((Item)this, (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)this, (int)1, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack item, World world, EntityPlayer player, EnumHand hand) {
        if (!world.field_72995_K && player instanceof EntityPlayerMP) {
            ItemStack stack = player.func_184586_b(hand);
            if (!QuestingData.isQuestActive()) {
                player.func_146105_b(Translator.translateToIChatComponent("hqm.message.noQuestYet", new Object[0]));
            } else if (stack.func_77952_i() == 1) {
                NBTTagCompound compound = stack.func_77978_p();
                if (compound != null && compound.func_74764_b(NBT_PLAYER)) {
                    UUID uuid;
                    String uuidS = compound.func_74779_i(NBT_PLAYER);
                    try {
                        uuid = UUID.fromString(uuidS);
                    }
                    catch (IllegalArgumentException e) {
                        compound.func_82580_o(NBT_PLAYER);
                        return new ActionResult(EnumActionResult.FAIL, (Object)stack);
                    }
                    if (QuestingData.hasData(uuid) && CommandHandler.isOwnerOrOp((ICommandSender)player)) {
                        EntityPlayer subject = QuestingData.getPlayer(uuid);
                        if (subject instanceof EntityPlayerMP) {
                            QuestingData.getQuestingData(subject).getTeam().getEntry(subject.func_110124_au().toString()).setBookOpen(true);
                            NetworkManager.sendToPlayer(GuiType.BOOK.build(Boolean.TRUE.toString()), (EntityPlayerMP)subject);
                        }
                    } else {
                        player.func_146105_b(Translator.translateToIChatComponent("hqm.message.bookNoPermission", new Object[0]));
                    }
                }
            } else {
                QuestingData.getQuestingData(player).getTeam().getEntry(player.func_110124_au().toString()).setBookOpen(true);
                NetworkManager.sendToPlayer(GuiType.BOOK.build(Boolean.FALSE.toString()), (EntityPlayerMP)player);
            }
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)item);
    }

    public String func_77667_c(ItemStack stack) {
        return super.func_77667_c(stack) + "_" + stack.func_77952_i();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List tooltip, boolean extraInfo) {
        if (stack.func_77952_i() == 1) {
            NBTTagCompound compound = stack.func_77978_p();
            if (compound != null && compound.func_74764_b(NBT_PLAYER)) {
                EntityPlayer useAsPlayer = QuestingData.getPlayer(compound.func_74779_i(NBT_PLAYER));
                tooltip.add(Translator.translate("item.hqm:quest_book_1.useAs", useAsPlayer == null ? "INVALID" : useAsPlayer.getDisplayNameString()));
            } else {
                tooltip.add((Object)((Object)GuiColor.RED) + Translator.translate("item.hqm:quest_book_1.invalid"));
            }
        }
    }

    public boolean func_77636_d(ItemStack stack) {
        return stack.func_77952_i() == 1;
    }
}

