/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.items;

import hardcorequesting.HardcoreQuesting;
import hardcorequesting.client.sounds.SoundHandler;
import hardcorequesting.client.sounds.Sounds;
import hardcorequesting.config.ModConfig;
import hardcorequesting.death.DeathType;
import hardcorequesting.items.ItemInfo;
import hardcorequesting.quests.QuestingData;
import hardcorequesting.util.Translator;
import java.util.List;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemHeart
extends Item {
    public ItemHeart() {
        this.func_77627_a(true);
        this.func_77656_e(0);
        this.func_77625_d(64);
        this.func_77637_a(HardcoreQuesting.HQMTab);
        this.setRegistryName("hearts");
        this.func_77655_b("hqm:hearts");
    }

    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        for (int i = 0; i < ItemInfo.HEART_ICONS.length; ++i) {
            ModelLoader.setCustomModelResourceLocation((Item)this, (int)i, (ModelResourceLocation)new ModelResourceLocation("hardcorequesting:" + ItemInfo.HEART_ICONS[i], "inventory"));
        }
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack stack, World world, EntityPlayer player, EnumHand hand) {
        if (!world.field_72995_K) {
            stack = player.func_184586_b(hand);
            if (stack.func_77952_i() == 3) {
                if (!QuestingData.isHardcoreActive()) {
                    player.func_146105_b((ITextComponent)new TextComponentTranslation("hqm.message.noHardcoreYet", new Object[0]));
                } else if (QuestingData.getQuestingData(player).getRawLives() < ModConfig.MAXLIVES) {
                    QuestingData.getQuestingData(player).addLives(player, 1);
                    player.func_146105_b((ITextComponent)new TextComponentTranslation("hqm.message.addOne", new Object[0]));
                    int lives = QuestingData.getQuestingData(player).getLives();
                    player.func_146105_b((ITextComponent)new TextComponentTranslation("hqm.message.haveRemaining", new Object[]{lives}));
                    SoundHandler.play(Sounds.LIFE, player);
                    if (!player.field_71075_bZ.field_75098_d) {
                        --stack.field_77994_a;
                    }
                } else {
                    player.func_146105_b((ITextComponent)new TextComponentTranslation("hqm.message.haveMaxLives", new Object[0]));
                }
            }
            if (stack.func_77952_i() == 4) {
                if (!QuestingData.isHardcoreActive()) {
                    player.func_146105_b((ITextComponent)new TextComponentTranslation("hqm.message.noHardcoreYet", new Object[0]));
                } else {
                    SoundHandler.play(Sounds.ROTTEN, player);
                    player.func_146105_b((ITextComponent)new TextComponentTranslation("hqm.message.eatRottenHearth", new Object[0]));
                    QuestingData.getQuestingData(player).removeLifeAndSendMessage(player);
                    DeathType.HQM.onDeath(player);
                    if (!player.field_71075_bZ.field_75098_d) {
                        --stack.field_77994_a;
                    }
                }
            }
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    public String func_77667_c(ItemStack stack) {
        int i = MathHelper.func_76125_a((int)stack.func_77952_i(), (int)0, (int)15);
        return super.func_77658_a() + "_" + ItemInfo.HEART_ICONS[i];
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int par4, boolean par5) {
        if (entity instanceof EntityPlayer) {
            EntityPlayer entityPlayer = (EntityPlayer)entity;
            if (stack.func_77952_i() == 3 && ModConfig.ROTTIMER) {
                NBTTagCompound tagCompound = stack.func_77978_p();
                if (tagCompound == null) {
                    tagCompound = new NBTTagCompound();
                    stack.func_77982_d(tagCompound);
                }
                if (!tagCompound.func_74764_b("RotTime")) {
                    int rot = ModConfig.MAXROT * 20;
                    tagCompound.func_74768_a("MaxRot", rot);
                    tagCompound.func_74768_a("RotTime", rot);
                } else {
                    int newRot = tagCompound.func_74762_e("RotTime");
                    if (newRot <= 0) {
                        stack.func_77964_b(4);
                        entityPlayer.func_146105_b((ITextComponent)new TextComponentTranslation("hqm.message.hearthDecay", new Object[0]));
                    } else {
                        tagCompound.func_74768_a("RotTime", newRot - 1);
                    }
                }
            }
        }
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List<String> tooltip, boolean extraInfo) {
        super.func_77624_a(stack, player, tooltip, extraInfo);
        if (stack.func_77952_i() == 3) {
            tooltip.add(Translator.translate("item.hqm:hearts_heart.tooltip"));
            if (ModConfig.ROTTIMER) {
                NBTTagCompound tagCompound = stack.func_77978_p();
                if (tagCompound == null) {
                    tagCompound = new NBTTagCompound();
                    stack.func_77982_d(tagCompound);
                }
                if (tagCompound.func_74764_b("RotTime")) {
                    int rot = tagCompound.func_74762_e("RotTime");
                    int maxRot = tagCompound.func_74762_e("MaxRot");
                    float percentage = rot * 100 / maxRot;
                    tooltip.add(Translator.translate("item.hqm:hearts_heart.freshness", Float.valueOf(percentage)));
                }
            }
        }
        if (stack.func_77952_i() == 4) {
            tooltip.add(Translator.translate("item.hqm:hearts_rottenheart.tooltip"));
        }
    }

    public boolean func_77636_d(ItemStack stack) {
        return stack.func_77952_i() == 3 || stack.func_77952_i() == 4;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs creativeTabs, List<ItemStack> stackList) {
        for (int x = 0; x < ItemInfo.HEART_ICONS.length; ++x) {
            stackList.add(new ItemStack((Item)this, 1, x));
        }
    }
}

