/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.items;

import hardcorequesting.HardcoreQuesting;
import hardcorequesting.bag.BagTier;
import hardcorequesting.bag.Group;
import hardcorequesting.client.interfaces.GuiType;
import hardcorequesting.client.sounds.SoundHandler;
import hardcorequesting.client.sounds.Sounds;
import hardcorequesting.network.NetworkManager;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemBag
extends Item {
    public static boolean displayGui;

    public ItemBag() {
        this.func_77627_a(true);
        this.func_77656_e(0);
        this.func_77625_d(64);
        this.func_77637_a(HardcoreQuesting.HQMTab);
        this.setRegistryName("bags");
        this.func_77655_b("hqm:bags");
    }

    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        for (int i = 0; i < BagTier.values().length; ++i) {
            ModelLoader.setCustomModelResourceLocation((Item)this, (int)i, (ModelResourceLocation)new ModelResourceLocation("hardcorequesting:bags", "inventory"));
        }
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack stack, World world, EntityPlayer player, EnumHand hand) {
        if (!world.field_72995_K) {
            stack = player.func_184586_b(hand);
            int dmg = stack.func_77952_i();
            if (dmg >= 0 && dmg < BagTier.values().length) {
                int totalWeight = 0;
                for (Group group : Group.getGroups().values()) {
                    if (!group.isValid(player)) continue;
                    totalWeight += group.getTier().getWeights()[dmg];
                }
                if (totalWeight > 0) {
                    int rng = (int)(Math.random() * (double)totalWeight);
                    for (Group group : Group.getGroups().values()) {
                        if (!group.isValid(player)) continue;
                        int weight = group.getTier().getWeights()[dmg];
                        if (rng < weight) {
                            group.open(player);
                            player.field_71071_by.func_70296_d();
                            this.openClientInterface(player, group.getId(), dmg);
                            world.func_184133_a(player, player.func_180425_c(), Sounds.BAG.getSound(), SoundCategory.MASTER, 1.0f, 1.0f);
                            break;
                        }
                        rng -= weight;
                    }
                }
            }
            --stack.field_77994_a;
        }
        return super.func_77659_a(stack, world, player, hand);
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List tooltip, boolean extraInfo) {
        super.func_77624_a(stack, player, tooltip, extraInfo);
        int dmg = stack.func_77952_i();
        if (dmg >= 0 && dmg < BagTier.values().length) {
            BagTier tier = BagTier.values()[dmg];
            tooltip.add((Object)((Object)tier.getColor()) + tier.getName());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tabs, List<ItemStack> stackList) {
        for (int i = 0; i < BagTier.values().length; ++i) {
            stackList.add(new ItemStack((Item)this, 1, i));
        }
    }

    private void openClientInterface(EntityPlayer player, String id, int bag) {
        ArrayList<String> data = new ArrayList<String>();
        data.add(id);
        data.add("" + bag);
        data.addAll(Group.getGroups().values().stream().filter(group -> group.getLimit() != 0).map(group -> group.getRetrievalCount(player) + "").collect(Collectors.toList()));
        if (displayGui && player instanceof EntityPlayerMP) {
            NetworkManager.sendToPlayer(GuiType.BAG.build(data.toArray(new String[data.size()])), (EntityPlayerMP)player);
        }
        SoundHandler.play(Sounds.BAG, player);
    }
}

