/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.io.adapter;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import hardcorequesting.io.adapter.QuestDataAdapter;
import hardcorequesting.quests.QuestData;
import hardcorequesting.quests.QuestingData;
import hardcorequesting.reputation.Reputation;
import hardcorequesting.team.LifeSetting;
import hardcorequesting.team.PlayerEntry;
import hardcorequesting.team.RewardSetting;
import hardcorequesting.team.Team;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TeamAdapter {
    private static Map<Team, List<Integer>> invitesMap = new HashMap<Team, List<Integer>>();
    public static final TypeAdapter<Team> TEAM_ADAPTER = new TypeAdapter<Team>(){
        private static final String ID = "id";
        private static final String NAME = "name";
        private static final String LIFE_SETTING = "lifeSetting";
        private static final String REWARD_SETTING = "rewardSetting";
        private static final String PLAYERS = "players";
        private static final String REPUTATIONS = "reputations";
        private static final String REP_ID = "reputationId";
        private static final String REP_VAL = "reputationValue";
        private static final String QUEST_DATA_LIST = "questDataList";
        private static final String QUEST_ID = "questId";
        private static final String QUEST_DATA = "questData";
        private static final String INVITES = "invites";

        public void write(JsonWriter out, Team value) throws IOException {
            out.beginObject();
            out.name(ID).value((long)value.getId());
            out.name(NAME).value(value.getName());
            out.name(LIFE_SETTING).value(value.getLifeSetting().name());
            out.name(REWARD_SETTING).value(value.getRewardSetting().name());
            out.name(PLAYERS).beginArray();
            for (PlayerEntry playerEntry : value.getPlayers()) {
                playerEntry.write(out);
            }
            out.endArray();
            out.name(REPUTATIONS).beginArray();
            for (Reputation reputation : Reputation.getReputations().values()) {
                out.beginObject();
                out.name(REP_ID).value(reputation.getId());
                out.name(REP_VAL).value((long)value.getReputation(reputation));
                out.endObject();
            }
            out.endArray();
            out.name(QUEST_DATA_LIST).beginArray();
            for (Map.Entry entry : value.getQuestData().entrySet()) {
                out.beginObject();
                out.name(QUEST_ID).value((String)entry.getKey());
                out.name(QUEST_DATA);
                QuestDataAdapter.QUEST_DATA_ADAPTER.write(out, entry.getValue());
                out.endObject();
            }
            out.endArray();
            out.name(INVITES).beginArray();
            for (Team team : value.getInvites()) {
                out.value((long)team.getId());
            }
            out.endArray();
            out.endObject();
        }

        public Team read(JsonReader in) throws IOException {
            in.beginObject();
            Team team = new Team(null);
            ArrayList<Integer> invites = new ArrayList<Integer>();
            while (in.hasNext()) {
                switch (in.nextName()) {
                    case "id": {
                        team.setId(in.nextInt());
                        break;
                    }
                    case "name": {
                        if (team.getId() == -1) {
                            in.nextNull();
                            team.setName(null);
                            break;
                        }
                        team.setName(in.nextString());
                        break;
                    }
                    case "lifeSetting": {
                        team.setLifeSetting(LifeSetting.valueOf(in.nextString()));
                        break;
                    }
                    case "rewardSetting": {
                        team.setRewardSetting(RewardSetting.valueOf(in.nextString()));
                        break;
                    }
                    case "players": {
                        in.beginArray();
                        while (in.hasNext()) {
                            team.addPlayer(PlayerEntry.read(in));
                        }
                        in.endArray();
                        break;
                    }
                    case "reputations": {
                        String id;
                        in.beginArray();
                        while (in.hasNext()) {
                            in.beginObject();
                            id = null;
                            int val = 0;
                            while (in.hasNext()) {
                                switch (in.nextName()) {
                                    case "reputationId": {
                                        id = in.nextString();
                                        break;
                                    }
                                    case "reputationValue": {
                                        val = in.nextInt();
                                        break;
                                    }
                                }
                            }
                            team.setReputation(id, (Integer)val);
                            in.endObject();
                        }
                        in.endArray();
                        break;
                    }
                    case "questDataList": {
                        String id;
                        in.beginArray();
                        while (in.hasNext()) {
                            in.beginObject();
                            id = null;
                            QuestData data = null;
                            while (in.hasNext()) {
                                switch (in.nextName()) {
                                    case "questId": {
                                        id = in.nextString();
                                        break;
                                    }
                                    case "questData": {
                                        data = (QuestData)QuestDataAdapter.QUEST_DATA_ADAPTER.read(in);
                                        break;
                                    }
                                }
                            }
                            if (id != null && data != null) {
                                team.getQuestData().put(id, data);
                            }
                            in.endObject();
                        }
                        in.endArray();
                        break;
                    }
                    case "invites": {
                        in.beginArray();
                        while (in.hasNext()) {
                            invites.add(in.nextInt());
                        }
                        in.endArray();
                        break;
                    }
                }
            }
            in.endObject();
            if (invites.size() > 0) {
                invitesMap.put(team, invites);
            }
            return team;
        }
    };

    public static void clearInvitesMap() {
        invitesMap.clear();
    }

    public static void commitInvitesMap() {
        if (invitesMap.size() > 0) {
            HashMap tempMap = new HashMap();
            QuestingData.getTeams().stream().filter(team -> team != null).forEach(team -> tempMap.put(team.getId(), team));
            for (Team team2 : QuestingData.getTeams()) {
                List<Integer> invites = invitesMap.get(team2);
                if (invites == null) continue;
                invites.forEach(id -> {
                    if (tempMap.containsKey(id)) {
                        team2.getInvites().add((Team)tempMap.get(id));
                    }
                });
            }
        }
        TeamAdapter.clearInvitesMap();
    }
}

