/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.io.adapter;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import hardcorequesting.reputation.Reputation;
import hardcorequesting.reputation.ReputationMarker;
import java.io.IOException;
import java.util.ArrayList;

public class ReputationAdapter {
    private static final TypeAdapter<ReputationMarker> REPUTATION_MARKER_ADAPTER = new TypeAdapter<ReputationMarker>(){
        private static final String NAME = "name";
        private static final String VALUE = "value";

        public void write(JsonWriter out, ReputationMarker value) throws IOException {
            out.beginObject();
            out.name(NAME).value(value.getName());
            out.name(VALUE).value((long)value.getValue());
            out.endObject();
        }

        public ReputationMarker read(JsonReader in) throws IOException {
            in.beginObject();
            String name = "Unnamed";
            int value = 0;
            while (in.hasNext()) {
                switch (in.nextName()) {
                    case "name": {
                        name = in.nextString();
                        break;
                    }
                    case "value": {
                        value = in.nextInt();
                    }
                }
            }
            in.endObject();
            return new ReputationMarker(name, value, false);
        }
    };
    public static final TypeAdapter<Reputation> REPUTATION_ADAPTER = new TypeAdapter<Reputation>(){
        private static final String ID = "id";
        private static final String NAME = "name";
        private static final String NEUTRAL = "neutral";
        private static final String MARKERS = "markers";

        public void write(JsonWriter out, Reputation value) throws IOException {
            out.beginObject();
            out.name(ID).value(value.getId());
            out.name(NAME).value(value.getName());
            out.name(NEUTRAL).value(value.getNeutralName());
            if (value.getMarkerCount() > 0) {
                out.name(MARKERS).beginArray();
                for (int i = 0; i < value.getMarkerCount(); ++i) {
                    REPUTATION_MARKER_ADAPTER.write(out, (Object)value.getMarker(i));
                }
                out.endArray();
            }
            out.endObject();
        }

        public Reputation read(JsonReader in) throws IOException {
            in.beginObject();
            String name = "Unnamed";
            String neutral = "Neutral";
            String id = null;
            ArrayList<Object> markers = new ArrayList<Object>();
            while (in.hasNext()) {
                switch (in.nextName()) {
                    case "id": {
                        id = in.nextString();
                        break;
                    }
                    case "name": {
                        name = in.nextString();
                        break;
                    }
                    case "neutral": {
                        neutral = in.nextString();
                        break;
                    }
                    case "markers": {
                        in.beginArray();
                        while (in.hasNext()) {
                            markers.add(REPUTATION_MARKER_ADAPTER.read(in));
                        }
                        in.endArray();
                    }
                }
            }
            in.endObject();
            Reputation reputation = new Reputation(id, name, neutral);
            markers.forEach(reputation::add);
            return reputation;
        }
    };
}

