/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.io.adapter;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import hardcorequesting.bag.GroupData;
import hardcorequesting.death.DeathStats;
import hardcorequesting.io.adapter.DeathAdapter;
import hardcorequesting.io.adapter.TeamAdapter;
import hardcorequesting.quests.QuestingData;
import hardcorequesting.team.Team;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class QuestingAdapter {
    public static final TypeAdapter<QuestingData> QUESTING_DATA_ADAPTER = new TypeAdapter<QuestingData>(){
        public static final String TEAM = "team";
        public static final String LIVES = "lives";
        public static final String UUID = "uuid";
        public static final String NAME = "name";
        public static final String GROUP_DATA = "groupData";
        public static final String SELECTED_QUEST = "selectedQuest";
        public static final String PLAYER_LORE = "playedLore";
        public static final String RECEIVED_BOOK = "receivedBook";
        public static final String DEATHS = "deaths";

        public void write(JsonWriter out, QuestingData value) throws IOException {
            out.beginObject();
            out.name(UUID).value(value.getUuid());
            out.name(NAME).value(value.getName());
            out.name(LIVES).value((long)value.getRawLives());
            out.name(TEAM);
            if (value.getTeam().getId() == -1) {
                TeamAdapter.TEAM_ADAPTER.write(out, (Object)value.getTeam());
            } else {
                out.value((long)value.getTeam().getId());
            }
            out.name(SELECTED_QUEST).value(value.selectedQuest);
            out.name(PLAYER_LORE).value(value.playedLore);
            out.name(RECEIVED_BOOK).value(value.receivedBook);
            out.name(GROUP_DATA).beginObject();
            for (Map.Entry<String, GroupData> entry : value.getGroupData().entrySet()) {
                if (entry.getKey() == null) continue;
                out.name(entry.getKey()).value((long)entry.getValue().retrieved);
            }
            out.endObject();
            out.name(DEATHS);
            DeathAdapter.DEATH_STATS_ADAPTER.write(out, (Object)value.getDeathStat());
            out.endObject();
        }

        public QuestingData read(JsonReader in) throws IOException {
            boolean playerLore = false;
            boolean receivedBook = false;
            String uuid = null;
            String selectedQuest = null;
            int lives = 0;
            int teamId = -1;
            Team team = null;
            HashMap<String, GroupData> data = new HashMap<String, GroupData>();
            DeathStats deathStats = null;
            in.beginObject();
            while (in.hasNext()) {
                switch (in.nextName()) {
                    case "uuid": {
                        uuid = in.nextString();
                        break;
                    }
                    case "name": {
                        in.nextString();
                        break;
                    }
                    case "lives": {
                        lives = in.nextInt();
                        break;
                    }
                    case "team": {
                        if (in.peek() == JsonToken.NUMBER) {
                            teamId = in.nextInt();
                            break;
                        }
                        team = (Team)TeamAdapter.TEAM_ADAPTER.read(in);
                        break;
                    }
                    case "selectedQuest": {
                        selectedQuest = in.nextString();
                        break;
                    }
                    case "playedLore": {
                        playerLore = in.nextBoolean();
                        break;
                    }
                    case "receivedBook": {
                        receivedBook = in.nextBoolean();
                        break;
                    }
                    case "groupData": {
                        in.beginObject();
                        while (in.hasNext()) {
                            data.put(in.nextName(), new GroupData(in.nextInt()));
                        }
                        in.endObject();
                        break;
                    }
                    case "deaths": {
                        deathStats = (DeathStats)DeathAdapter.DEATH_STATS_ADAPTER.read(in);
                    }
                }
            }
            in.endObject();
            QuestingData questingData = new QuestingData(uuid, lives, teamId, data, deathStats);
            questingData.playedLore = playerLore;
            questingData.receivedBook = receivedBook;
            questingData.selectedQuest = selectedQuest;
            if (teamId == -1) {
                questingData.setTeam(team);
            }
            return questingData;
        }
    };
}

