/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.io.adapter;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import hardcorequesting.io.adapter.MinecraftAdapter;
import hardcorequesting.io.adapter.QuestAdapter;
import hardcorequesting.quests.ItemPrecision;
import hardcorequesting.quests.Quest;
import hardcorequesting.quests.data.QuestDataTask;
import hardcorequesting.quests.data.QuestDataTaskDeath;
import hardcorequesting.quests.data.QuestDataTaskItems;
import hardcorequesting.quests.data.QuestDataTaskLocation;
import hardcorequesting.quests.data.QuestDataTaskMob;
import hardcorequesting.quests.data.QuestDataTaskReputationKill;
import hardcorequesting.quests.task.QuestTask;
import hardcorequesting.quests.task.QuestTaskDeath;
import hardcorequesting.quests.task.QuestTaskItems;
import hardcorequesting.quests.task.QuestTaskLocation;
import hardcorequesting.quests.task.QuestTaskMob;
import hardcorequesting.quests.task.QuestTaskReputation;
import hardcorequesting.quests.task.QuestTaskReputationKill;
import hardcorequesting.reputation.Reputation;
import hardcorequesting.reputation.ReputationMarker;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;

public class QuestTaskAdapter {
    public static final TypeAdapter<QuestDataTask> QUEST_DATA_TASK_ADAPTER = new TypeAdapter<QuestDataTask>(){
        private static final String TYPE = "type";

        public void write(JsonWriter out, QuestDataTask value) throws IOException {
            out.beginObject();
            out.name(TYPE).value(String.valueOf((Object)value.getDataType()));
            value.write(out);
            out.endObject();
        }

        public QuestDataTask read(JsonReader in) throws IOException {
            in.beginObject();
            QuestDataTask dataTask = null;
            if (in.hasNext() && in.nextName().equals(TYPE)) {
                dataTask = QuestDataType.valueOf(in.nextString()).construct(in);
            }
            in.endObject();
            return dataTask;
        }
    };
    protected static final TypeAdapter<QuestTaskItems.ItemRequirement> ITEM_REQUIREMENT_ADAPTER = new TypeAdapter<QuestTaskItems.ItemRequirement>(){
        private final String ITEM = "item";
        private final String FLUID = "fluid";
        private final String REQUIRED = "required";
        private final String PRECISION = "precision";

        public void write(JsonWriter out, QuestTaskItems.ItemRequirement value) throws IOException {
            ItemStack stack = value.getStack();
            Fluid fluid = value.fluid;
            int required = value.required;
            ItemPrecision precision = value.getPrecision();
            out.beginObject();
            if (stack != null) {
                MinecraftAdapter.ITEM_STACK.write(out.name("item"), (Object)stack);
            } else if (fluid != null) {
                MinecraftAdapter.FLUID.write(out.name("fluid"), (Object)fluid);
            } else {
                out.nullValue();
                out.endObject();
                return;
            }
            if (required != 1) {
                out.name("required").value((long)required);
            }
            if (precision != ItemPrecision.PRECISE) {
                out.name("precision").value(ItemPrecision.getUniqueID(precision));
            }
            out.endObject();
        }

        public QuestTaskItems.ItemRequirement read(JsonReader in) throws IOException {
            in.beginObject();
            ItemStack stack = null;
            Fluid fluid = null;
            int required = 1;
            ItemPrecision precision = ItemPrecision.PRECISE;
            while (in.hasNext()) {
                ItemPrecision itemPrecision;
                String next = in.nextName();
                if (next.equalsIgnoreCase("item")) {
                    stack = (ItemStack)MinecraftAdapter.ITEM_STACK.read(in);
                    continue;
                }
                if (next.equalsIgnoreCase("fluid")) {
                    fluid = (Fluid)MinecraftAdapter.FLUID.read(in);
                    continue;
                }
                if (next.equalsIgnoreCase("required")) {
                    required = Math.max(in.nextInt(), required);
                    continue;
                }
                if (!next.equalsIgnoreCase("precision") || (itemPrecision = ItemPrecision.getPrecisionType(in.nextString())) == null) continue;
                precision = itemPrecision;
            }
            in.endObject();
            QuestTaskItems.ItemRequirement result = null;
            if (stack != null) {
                result = new QuestTaskItems.ItemRequirement(stack, required);
            } else if (fluid != null) {
                result = new QuestTaskItems.ItemRequirement(fluid, required);
            } else {
                return null;
            }
            result.setPrecision(precision);
            return result;
        }
    };
    protected static final TypeAdapter<QuestTaskLocation.Location> LOCATION_ADAPTER = new TypeAdapter<QuestTaskLocation.Location>(){
        private final String X = "x";
        private final String Y = "y";
        private final String Z = "z";
        private final String DIM = "dim";
        private final String ICON = "icon";
        private final String RADIUS = "radius";
        private final String VISIBLE = "visible";
        private final String NAME = "name";

        public void write(JsonWriter out, QuestTaskLocation.Location value) throws IOException {
            out.beginObject();
            out.name("name").value(value.getName());
            ItemStack stack = value.getIconStack();
            if (stack != null) {
                MinecraftAdapter.ITEM_STACK.write(out.name("icon"), (Object)stack);
            }
            out.name("x").value((long)value.getX());
            out.name("y").value((long)value.getY());
            out.name("z").value((long)value.getZ());
            out.name("dim").value((long)value.getDimension());
            out.name("radius").value((long)value.getRadius());
            if (value.getVisible() != QuestTaskLocation.Visibility.LOCATION) {
                out.name("visible").value(value.getVisible().name());
            }
            out.endObject();
        }

        public QuestTaskLocation.Location read(JsonReader in) throws IOException {
            in.beginObject();
            QuestTaskLocation.Location result = new QuestTaskLocation.Location();
            while (in.hasNext()) {
                String name = in.nextName();
                if (name.equalsIgnoreCase("name")) {
                    result.setName(in.nextString());
                    continue;
                }
                if (name.equalsIgnoreCase("x")) {
                    result.setX(in.nextInt());
                    continue;
                }
                if (name.equalsIgnoreCase("y")) {
                    result.setY(in.nextInt());
                    continue;
                }
                if (name.equalsIgnoreCase("z")) {
                    result.setZ(in.nextInt());
                    continue;
                }
                if (name.equalsIgnoreCase("dim")) {
                    result.setDimension(in.nextInt());
                    continue;
                }
                if (name.equalsIgnoreCase("radius")) {
                    result.setRadius(in.nextInt());
                    continue;
                }
                if (name.equalsIgnoreCase("icon")) {
                    result.setIconStack((ItemStack)MinecraftAdapter.ITEM_STACK.read(in));
                    continue;
                }
                if (!name.equalsIgnoreCase("visible")) continue;
                result.setVisible(QuestTaskLocation.Visibility.valueOf(in.nextString()));
            }
            in.endObject();
            return result;
        }
    };
    protected static final TypeAdapter<QuestTaskReputation.ReputationSetting> REPUTATION_TASK_ADAPTER = new TypeAdapter<QuestTaskReputation.ReputationSetting>(){
        private final String REPUTATION = "reputation";
        private final String LOWER = "lower";
        private final String UPPER = "upper";
        private final String INVERTED = "inverted";

        public void write(JsonWriter out, QuestTaskReputation.ReputationSetting value) throws IOException {
            out.beginObject();
            out.name("reputation").value(value.getReputation().getId());
            if (value.getLower() != null) {
                out.name("lower").value((long)value.getLower().getId());
            }
            if (value.getUpper() != null) {
                out.name("upper").value((long)value.getUpper().getId());
            }
            out.name("inverted").value(value.isInverted());
            out.endObject();
        }

        public QuestTaskReputation.ReputationSetting read(JsonReader in) throws IOException {
            in.beginObject();
            Reputation reputation = null;
            ReputationMarker lower = null;
            ReputationMarker upper = null;
            boolean inverted = false;
            while (in.hasNext()) {
                switch (in.nextName()) {
                    case "reputation": {
                        reputation = Reputation.getReputation(in.nextString());
                        break;
                    }
                    case "lower": {
                        if (reputation == null) break;
                        lower = reputation.getMarker(in.nextInt());
                        break;
                    }
                    case "upper": {
                        if (reputation == null) break;
                        upper = reputation.getMarker(in.nextInt());
                        break;
                    }
                    case "inverted": {
                        inverted = in.nextBoolean();
                        break;
                    }
                }
            }
            return new QuestTaskReputation.ReputationSetting(reputation, lower, upper, inverted);
        }
    };
    public static QuestTask TASK;
    protected static final TypeAdapter<QuestTaskMob.Mob> MOB_ADAPTER;
    protected static Map<QuestTaskReputation, List<ReputationSettingConstructor>> taskReputationListMap;
    protected static final TypeAdapter<QuestTask> TASK_ADAPTER;

    static {
        MOB_ADAPTER = new TypeAdapter<QuestTaskMob.Mob>(){
            private final String KILLS = "kills";
            private final String EXACT = "exact";
            private final String MOB = "mob";
            private final String ICON = "icon";
            private final String NAME = "name";

            public void write(JsonWriter out, QuestTaskMob.Mob value) throws IOException {
                out.beginObject();
                out.name("name").value(value.getName());
                ItemStack stack = value.getIconStack();
                if (stack != null) {
                    MinecraftAdapter.ITEM_STACK.write(out.name("icon"), (Object)stack);
                }
                out.name("mob").value(value.getMob());
                out.name("kills").value((long)value.getCount());
                out.name("exact").value(value.isExact());
                out.endObject();
            }

            public QuestTaskMob.Mob read(JsonReader in) throws IOException {
                in.beginObject();
                QuestTaskMob.Mob result = new QuestTaskMob.Mob((QuestTaskMob)TASK);
                while (in.hasNext()) {
                    String name = in.nextName();
                    if (name.equalsIgnoreCase("name")) {
                        result.setName(in.nextString());
                        continue;
                    }
                    if (name.equalsIgnoreCase("icon")) {
                        result.setIconStack((ItemStack)MinecraftAdapter.ITEM_STACK.read(in));
                        continue;
                    }
                    if (name.equalsIgnoreCase("mob")) {
                        result.setMob(in.nextString());
                        continue;
                    }
                    if (name.equalsIgnoreCase("exact")) {
                        result.setExact(in.nextBoolean());
                        continue;
                    }
                    if (!name.equalsIgnoreCase("kills")) continue;
                    result.setCount(in.nextInt());
                }
                in.endObject();
                return result;
            }
        };
        taskReputationListMap = new HashMap<QuestTaskReputation, List<ReputationSettingConstructor>>();
        TASK_ADAPTER = new TypeAdapter<QuestTask>(){
            private final String TYPE = "type";
            private final String DESCRIPTION = "description";
            private final String LONG_DESCRIPTION = "longDescription";
            private final String ITEMS = "items";
            private final String DEATHS = "deaths";
            private final String LOCATIONS = "locations";
            private final String MOBS = "mobs";
            private final String REPUTATION = "reputation";
            private final String KILLS = "kills";

            public void write(JsonWriter out, QuestTask value) throws IOException {
                out.beginObject();
                Quest.TaskType type = Quest.TaskType.getType(value.getClass());
                out.name("type").value(type.name());
                if (!value.getDescription().equals(type.getName())) {
                    out.name("description").value(value.getDescription());
                }
                if (!value.getLongDescription().equals(type.getDescription())) {
                    out.name("longDescription").value(value.getLongDescription());
                }
                if (value instanceof QuestTaskItems) {
                    out.name("items").beginArray();
                    for (QuestTaskItems.ItemRequirement requirement : ((QuestTaskItems)value).getItems()) {
                        ITEM_REQUIREMENT_ADAPTER.write(out, (Object)requirement);
                    }
                    out.endArray();
                } else if (value instanceof QuestTaskDeath) {
                    out.name("deaths").value((long)((QuestTaskDeath)value).getDeaths());
                } else if (value instanceof QuestTaskLocation) {
                    out.name("locations").beginArray();
                    for (QuestTaskLocation.Location requirement : ((QuestTaskLocation)value).locations) {
                        LOCATION_ADAPTER.write(out, (Object)requirement);
                    }
                    out.endArray();
                } else if (value instanceof QuestTaskMob) {
                    out.name("mobs").beginArray();
                    for (QuestTaskMob.Mob requirement : ((QuestTaskMob)value).mobs) {
                        MOB_ADAPTER.write(out, (Object)requirement);
                    }
                    out.endArray();
                } else if (value instanceof QuestTaskReputation) {
                    out.name("reputation").beginArray();
                    for (QuestTaskReputation.ReputationSetting requirement : ((QuestTaskReputation)value).getSettings()) {
                        REPUTATION_TASK_ADAPTER.write(out, (Object)requirement);
                    }
                    out.endArray();
                    if (value instanceof QuestTaskReputationKill) {
                        out.name("kills").value((long)((QuestTaskReputationKill)value).getKills());
                    }
                }
                out.endObject();
            }

            public QuestTask read(JsonReader in) throws IOException {
                in.beginObject();
                if (!in.nextName().equalsIgnoreCase("type")) {
                    throw new IOException("Tasks *MUST* start with the type");
                }
                String task = in.nextString();
                Quest.TaskType type = Quest.TaskType.valueOf(task);
                if (type == null) {
                    throw new IOException("Invalid Task Type: " + task);
                }
                TASK = type.addTask(QuestAdapter.QUEST);
                while (in.hasNext()) {
                    Object entry;
                    ArrayList<Object> list;
                    String name = in.nextName();
                    if (name.equalsIgnoreCase("description")) {
                        QuestTaskAdapter.TASK.description = in.nextString();
                        continue;
                    }
                    if (name.equalsIgnoreCase("longDescription")) {
                        TASK.setLongDescription(in.nextString());
                        continue;
                    }
                    if (TASK instanceof QuestTaskItems && name.equalsIgnoreCase("items")) {
                        list = new ArrayList<Object>();
                        in.beginArray();
                        while (in.hasNext()) {
                            entry = (QuestTaskItems.ItemRequirement)ITEM_REQUIREMENT_ADAPTER.read(in);
                            if (entry == null) continue;
                            list.add(entry);
                        }
                        in.endArray();
                        ((QuestTaskItems)TASK).setItems(list.toArray(new QuestTaskItems.ItemRequirement[list.size()]));
                        continue;
                    }
                    if (TASK instanceof QuestTaskDeath && name.equalsIgnoreCase("deaths")) {
                        int death = in.nextInt();
                        ((QuestTaskDeath)TASK).setDeaths(death);
                        continue;
                    }
                    if (TASK instanceof QuestTaskLocation && name.equalsIgnoreCase("locations")) {
                        list = new ArrayList();
                        in.beginArray();
                        while (in.hasNext()) {
                            entry = (QuestTaskLocation.Location)LOCATION_ADAPTER.read(in);
                            if (entry == null) continue;
                            list.add(entry);
                        }
                        in.endArray();
                        ((QuestTaskLocation)QuestTaskAdapter.TASK).locations = list.toArray(new QuestTaskLocation.Location[list.size()]);
                        continue;
                    }
                    if (TASK instanceof QuestTaskMob && name.equalsIgnoreCase("mobs")) {
                        list = new ArrayList();
                        in.beginArray();
                        while (in.hasNext()) {
                            entry = (QuestTaskMob.Mob)MOB_ADAPTER.read(in);
                            if (entry == null) continue;
                            list.add(entry);
                        }
                        in.endArray();
                        ((QuestTaskMob)QuestTaskAdapter.TASK).mobs = list.toArray(new QuestTaskMob.Mob[list.size()]);
                        continue;
                    }
                    if (TASK instanceof QuestTaskReputation && name.equalsIgnoreCase("reputation")) {
                        list = new ArrayList();
                        in.beginArray();
                        while (in.hasNext()) {
                            ReputationSettingConstructor constructor = ReputationSettingConstructor.read(in);
                            if (constructor == null) continue;
                            list.add(constructor);
                        }
                        in.endArray();
                        taskReputationListMap.put((QuestTaskReputation)TASK, list);
                        continue;
                    }
                    if (!name.equalsIgnoreCase("kills") || !(TASK instanceof QuestTaskReputationKill)) continue;
                    ((QuestTaskReputationKill)TASK).setKills(in.nextInt());
                }
                in.endObject();
                return null;
            }
        };
    }

    protected static class ReputationSettingConstructor {
        private static final String REPUTATION = "reputation";
        private static final String LOWER = "lower";
        private static final String UPPER = "upper";
        private static final String INVERTED = "inverted";
        String reputation;
        boolean inverted;
        private int upper;
        private int lower;

        private ReputationSettingConstructor(String reputation, int lower, int upper, boolean inverted) {
            this.reputation = reputation;
            this.lower = lower;
            this.upper = upper;
            this.inverted = inverted;
        }

        public static ReputationSettingConstructor read(JsonReader in) throws IOException {
            in.beginObject();
            int low = Integer.MIN_VALUE;
            int high = Integer.MIN_VALUE;
            String reputation = null;
            boolean inverted = false;
            while (in.hasNext()) {
                String name = in.nextName();
                if (name.equalsIgnoreCase(REPUTATION)) {
                    reputation = in.nextString();
                    continue;
                }
                if (name.equalsIgnoreCase(UPPER)) {
                    high = in.nextInt();
                    continue;
                }
                if (name.equalsIgnoreCase(LOWER)) {
                    low = in.nextInt();
                    continue;
                }
                if (!name.equalsIgnoreCase(INVERTED)) continue;
                inverted = in.nextBoolean();
            }
            in.endObject();
            if (reputation == null) {
                return null;
            }
            return new ReputationSettingConstructor(reputation, low, high, inverted);
        }

        public QuestTaskReputation.ReputationSetting constructReuptationSetting() {
            Reputation reputation = Reputation.getReputations().get(this.reputation);
            if (reputation != null) {
                ReputationMarker lower = null;
                ReputationMarker upper = null;
                if (this.lower >= 0 && this.lower < reputation.getMarkerCount()) {
                    lower = reputation.getMarker(this.lower);
                }
                if (this.upper >= 0 && this.upper < reputation.getMarkerCount()) {
                    upper = reputation.getMarker(this.lower);
                }
                return new QuestTaskReputation.ReputationSetting(reputation, lower, upper, this.inverted);
            }
            return null;
        }
    }

    public static enum QuestDataType {
        GENERIC(QuestDataTask::construct),
        DEATH(QuestDataTaskDeath::construct),
        ITEMS(QuestDataTaskItems::construct),
        LOCATION(QuestDataTaskLocation::construct),
        MOB(QuestDataTaskMob::construct),
        REPUTATION_KILL(QuestDataTaskReputationKill::construct);

        private Function<JsonReader, QuestDataTask> func;

        private QuestDataType(Function<JsonReader, QuestDataTask> func) {
            this.func = func;
        }

        public QuestDataTask construct(JsonReader in) {
            return this.func.apply(in);
        }
    }
}

