/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.io.adapter;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import hardcorequesting.HardcoreQuesting;
import hardcorequesting.io.adapter.MinecraftAdapter;
import hardcorequesting.io.adapter.QuestTaskAdapter;
import hardcorequesting.quests.Quest;
import hardcorequesting.quests.QuestLine;
import hardcorequesting.quests.QuestSet;
import hardcorequesting.quests.RepeatInfo;
import hardcorequesting.quests.RepeatType;
import hardcorequesting.quests.TriggerType;
import hardcorequesting.quests.reward.ReputationReward;
import hardcorequesting.quests.task.QuestTask;
import hardcorequesting.quests.task.QuestTaskReputation;
import hardcorequesting.reputation.Reputation;
import hardcorequesting.reputation.ReputationBar;
import hardcorequesting.util.SaveHelper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class QuestAdapter {
    private static final TypeAdapter<RepeatInfo> REPEAT_INFO_ADAPTER = new TypeAdapter<RepeatInfo>(){
        private final String TYPE = "type";
        private final String HOURS = "hours";
        private final String DAYS = "days";

        public void write(JsonWriter out, RepeatInfo value) throws IOException {
            out.beginObject();
            out.name("type").value(value.getType().name());
            if (value.getType().isUseTime()) {
                out.name("days").value((long)value.getDays());
                out.name("hours").value((long)value.getHours());
            }
            out.endObject();
        }

        public RepeatInfo read(JsonReader in) throws IOException {
            RepeatType type = RepeatType.NONE;
            int days = 0;
            int hours = 0;
            in.beginObject();
            while (in.hasNext()) {
                switch (in.nextName().toLowerCase()) {
                    case "type": {
                        type = RepeatType.valueOf(in.nextString());
                        break;
                    }
                    case "hours": {
                        hours = in.nextInt();
                        break;
                    }
                    case "days": {
                        days = in.nextInt();
                    }
                }
            }
            in.endObject();
            return new RepeatInfo(type, days, hours);
        }
    };
    private static final TypeAdapter<ReputationBar> REPUTATION_BAR_ADAPTER = new TypeAdapter<ReputationBar>(){
        private final String X = "x";
        private final String Y = "y";
        private final String REPUTATION_ID = "reputationId";

        public void write(JsonWriter out, ReputationBar value) throws IOException {
            out.beginObject();
            out.name("reputationId").value(value.getRepId());
            out.name("x").value((long)value.getX());
            out.name("y").value((long)value.getY());
            out.endObject();
        }

        public ReputationBar read(JsonReader in) throws IOException {
            String id = null;
            int y = -1;
            int x = -1;
            in.beginObject();
            while (in.hasNext()) {
                switch (in.nextName()) {
                    case "x": {
                        x = in.nextInt();
                        break;
                    }
                    case "y": {
                        y = in.nextInt();
                        break;
                    }
                    case "reputationId": {
                        id = in.nextString();
                    }
                }
            }
            in.endObject();
            return new ReputationBar(id, x, y, -1);
        }
    };
    private static final Pattern OTHER_QUEST_SET = Pattern.compile("^\\{(.*?)\\}\\[(.*)\\]$");
    public static Quest QUEST;
    private static Map<String, Quest> nameToQuestMap;
    private static List<ReputationBar> reputationBarList;
    private static Map<Quest, List<String>> requirementMapping;
    private static Map<Quest, List<String>> prerequisiteMapping;
    private static Map<Quest, List<String>> optionMapping;
    private static Map<Quest, List<String>> optionLinkMapping;
    private static Map<ReputationReward, String> reputationRewardMapping;
    private static final TypeAdapter<ReputationReward> REPUTATION_REWARD_ADAPTER;
    public static final TypeAdapter<Quest> QUEST_ADAPTER;
    public static final TypeAdapter<QuestSet> QUEST_SET_ADAPTER;

    public static void postLoad() throws IOException {
        Quest quest;
        for (Map.Entry<Quest, List<String>> entry : prerequisiteMapping.entrySet()) {
            for (String link : entry.getValue()) {
                quest = QuestAdapter.getQuest(link);
                if (quest == null) continue;
                entry.getKey().addRequirement(quest.getId());
            }
        }
        prerequisiteMapping.clear();
        for (Map.Entry<Quest, List<String>> entry : optionLinkMapping.entrySet()) {
            for (String link : entry.getValue()) {
                quest = QuestAdapter.getQuest(link);
                if (quest == null) continue;
                entry.getKey().addOptionLink(quest.getId());
            }
        }
        optionLinkMapping.clear();
        for (Map.Entry<Object, Object> entry : reputationRewardMapping.entrySet()) {
            String rep = (String)entry.getValue();
            Reputation reputation = Reputation.getReputations().get(rep);
            if (reputation == null) {
                throw new IOException("Failed to load reputation " + rep);
            }
            ((ReputationReward)entry.getKey()).setReward(reputation);
        }
        reputationRewardMapping.clear();
        for (Map.Entry<Object, Object> entry : QuestTaskAdapter.taskReputationListMap.entrySet()) {
            ArrayList<QuestTaskReputation.ReputationSetting> reputationSettingList = new ArrayList<QuestTaskReputation.ReputationSetting>();
            for (QuestTaskAdapter.ReputationSettingConstructor constructor : (List)entry.getValue()) {
                QuestTaskReputation.ReputationSetting setting = constructor.constructReuptationSetting();
                if (setting == null) continue;
                reputationSettingList.add(setting);
            }
            ReflectionHelper.setPrivateValue(QuestTaskReputation.class, (Object)entry.getKey(), (Object)reputationSettingList.toArray(new QuestTaskReputation.ReputationSetting[reputationSettingList.size()]), (String[])new String[]{"settings"});
        }
        QuestTaskAdapter.taskReputationListMap.clear();
        nameToQuestMap.clear();
    }

    private static Quest getQuest(String questString) {
        String questId = questString;
        Matcher matcher = OTHER_QUEST_SET.matcher(questString);
        if (matcher.find()) {
            questId = matcher.group(2);
        }
        return Quest.getQuest(QuestAdapter.getUuid(questId));
    }

    private static String getUuid(String id) {
        return nameToQuestMap.containsKey(id) ? nameToQuestMap.get(id).getId() : id;
    }

    static {
        nameToQuestMap = new HashMap<String, Quest>();
        reputationBarList = new ArrayList<ReputationBar>();
        requirementMapping = new HashMap<Quest, List<String>>();
        prerequisiteMapping = new HashMap<Quest, List<String>>();
        optionMapping = new HashMap<Quest, List<String>>();
        optionLinkMapping = new HashMap<Quest, List<String>>();
        reputationRewardMapping = new HashMap<ReputationReward, String>();
        REPUTATION_REWARD_ADAPTER = new TypeAdapter<ReputationReward>(){
            private final String REPUTATION = "reputation";
            private final String VALUE = "value";

            public void write(JsonWriter out, ReputationReward value) throws IOException {
                out.beginObject();
                out.name("reputation").value(((Reputation)value.getReward()).getId());
                out.name("value").value((long)value.getValue());
                out.endObject();
            }

            public ReputationReward read(JsonReader in) throws IOException {
                in.beginObject();
                int val = 0;
                String rep = null;
                while (in.hasNext()) {
                    switch (in.nextName().toLowerCase()) {
                        case "reputation": {
                            rep = in.nextString();
                            break;
                        }
                        case "value": {
                            val = in.nextInt();
                        }
                    }
                }
                in.endObject();
                ReputationReward result = new ReputationReward(null, val);
                reputationRewardMapping.put(result, rep);
                return result;
            }
        };
        QUEST_ADAPTER = new TypeAdapter<Quest>(){
            private final String UUID = "uuid";
            private final String NAME = "name";
            private final String DESCRIPTION = "description";
            private final String X = "x";
            private final String Y = "y";
            private final String ICON = "icon";
            private final String BIG_ICON = "bigicon";
            private final String REQUIREMENTS = "requirements";
            private final String PREREQUISITES = "prerequisites";
            private final String OPTIONS = "options";
            private final String OPTIONLINKS = "optionlinks";
            private final String REPEAT = "repeat";
            private final String TRIGGER = "trigger";
            private final String TRIGGER_TASKS = "triggertasks";
            private final String PARENT_REQUIREMENT = "parentrequirement";
            private final String TASKS = "tasks";
            private final String REWARDS = "reward";
            private final String REWARDS_CHOICE = "rewardchoice";
            private final String REWARDS_REPUTATION = "reputationrewards";
            private final String REWARDS_COMMAND = "commandrewards";

            private void writeQuestList(JsonWriter out, List<Quest> quests, String name) throws IOException {
                if (!quests.isEmpty()) {
                    out.name(name).beginArray();
                    for (Quest quest : quests) {
                        out.value(quest.getId());
                    }
                    out.endArray();
                }
            }

            private void writeItemStackArray(JsonWriter out, ItemStack[] stacks, String name) throws IOException {
                if (stacks != null) {
                    out.name(name).beginArray();
                    for (ItemStack stack : stacks) {
                        if (stack == null) continue;
                        MinecraftAdapter.ITEM_STACK.write(out, (Object)stack);
                    }
                    out.endArray();
                }
            }

            public void write(JsonWriter out, Quest value) throws IOException {
                out.beginObject();
                out.name("uuid").value(value.getId());
                out.name("name").value(value.getName());
                if (!value.getDescription().equals("Unnamed quest")) {
                    out.name("description").value(value.getDescription());
                }
                out.name("x").value((long)value.getGuiX());
                out.name("y").value((long)value.getGuiY());
                if (value.useBigIcon()) {
                    out.name("bigicon").value(true);
                }
                if (value.getIconStack() != null) {
                    MinecraftAdapter.ITEM_STACK.write(out.name("icon"), (Object)value.getIconStack());
                }
                this.writeQuestList(out, value.getRequirements(), "prerequisites");
                this.writeQuestList(out, value.getOptionLinks(), "optionlinks");
                if (value.getRepeatInfo().getType() != RepeatType.NONE) {
                    REPEAT_INFO_ADAPTER.write(out.name("repeat"), (Object)value.getRepeatInfo());
                }
                if (value.getTriggerType() != TriggerType.NONE) {
                    out.name("trigger").value(value.getTriggerType().name());
                }
                if (value.getTriggerType().isUseTaskCount()) {
                    out.name("triggertasks").value((long)value.getTriggerTasks());
                }
                if (value.getUseModifiedParentRequirement()) {
                    out.name("parentrequirement").value((long)value.getParentRequirementCount());
                }
                if (!value.getTasks().isEmpty()) {
                    out.name("tasks").beginArray();
                    for (QuestTask task : value.getTasks()) {
                        QuestTaskAdapter.TASK_ADAPTER.write(out, (Object)task);
                    }
                    out.endArray();
                }
                this.writeItemStackArray(out, value.getReward(), "reward");
                this.writeItemStackArray(out, value.getRewardChoice(), "rewardchoice");
                this.writeStringArray(out, value.getCommandRewardsAsStrings(), "commandrewards");
                if (value.getReputationRewards() != null && !value.getReputationRewards().isEmpty()) {
                    out.name("reputationrewards").beginArray();
                    for (ReputationReward reward : value.getReputationRewards()) {
                        REPUTATION_REWARD_ADAPTER.write(out, (Object)reward);
                    }
                    out.endArray();
                }
                out.endObject();
            }

            private void writeStringArray(JsonWriter out, String[] list, String name) throws IOException {
                if (list != null) {
                    out.name(name).beginArray();
                    for (String s : list) {
                        if (s == null) continue;
                        out.value(s);
                    }
                    out.endArray();
                }
            }

            private <T> void optionalAdd(Map<Quest, List<T>> map, List<T> list) {
                if (!list.isEmpty()) {
                    map.put(QUEST, list);
                }
            }

            private void readStringArray(List<String> list, JsonReader in) throws IOException {
                in.beginArray();
                while (in.hasNext()) {
                    list.add(in.nextString());
                }
                in.endArray();
            }

            private ItemStack[] readItemStackArray(JsonReader in) throws IOException {
                ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
                in.beginArray();
                while (in.hasNext()) {
                    ItemStack stack = (ItemStack)MinecraftAdapter.ITEM_STACK.read(in);
                    if (stack == null) continue;
                    stacks.add(stack);
                }
                in.endArray();
                return stacks.toArray(new ItemStack[stacks.size()]);
            }

            public Quest read(JsonReader in) throws IOException {
                QUEST = new Quest("Unnamed", "Unnamed quest", 0, 0, false);
                ArrayList<String> requirement = new ArrayList<String>();
                ArrayList<String> options = new ArrayList<String>();
                ArrayList<String> prerequisites = new ArrayList<String>();
                ArrayList<String> optionLinks = new ArrayList<String>();
                boolean hasUuid = false;
                in.beginObject();
                block46: while (in.hasNext()) {
                    switch (in.nextName().toLowerCase()) {
                        case "uuid": {
                            QUEST.setId(in.nextString());
                            hasUuid = true;
                            continue block46;
                        }
                        case "name": {
                            QUEST.setName(in.nextString());
                            continue block46;
                        }
                        case "description": {
                            QUEST.setDescription(in.nextString());
                            continue block46;
                        }
                        case "x": {
                            QUEST.setX(in.nextInt());
                            continue block46;
                        }
                        case "y": {
                            QUEST.setY(in.nextInt());
                            continue block46;
                        }
                        case "triggertasks": {
                            QUEST.setTriggerTasks(in.nextInt());
                            continue block46;
                        }
                        case "parentrequirement": {
                            QUEST.setParentRequirementCount(in.nextInt());
                            continue block46;
                        }
                        case "bigicon": {
                            QUEST.setBigIcon(in.nextBoolean());
                            continue block46;
                        }
                        case "icon": {
                            QUEST.setIconStack((ItemStack)MinecraftAdapter.ITEM_STACK.read(in));
                            continue block46;
                        }
                        case "requirements": {
                            this.readStringArray(requirement, in);
                            continue block46;
                        }
                        case "options": {
                            this.readStringArray(options, in);
                            continue block46;
                        }
                        case "prerequisites": {
                            this.readStringArray(prerequisites, in);
                            continue block46;
                        }
                        case "optionlinks": {
                            this.readStringArray(optionLinks, in);
                            continue block46;
                        }
                        case "repeat": {
                            QUEST.setRepeatInfo((RepeatInfo)REPEAT_INFO_ADAPTER.read(in));
                            continue block46;
                        }
                        case "trigger": {
                            QUEST.setTriggerType(TriggerType.valueOf(in.nextString()));
                            continue block46;
                        }
                        case "tasks": {
                            in.beginArray();
                            while (in.hasNext()) {
                                QuestTask task = (QuestTask)QuestTaskAdapter.TASK_ADAPTER.read(in);
                                if (task == null) continue;
                                QUEST.getTasks().add(task);
                            }
                            in.endArray();
                            continue block46;
                        }
                        case "reward": {
                            QUEST.setReward(this.readItemStackArray(in));
                            continue block46;
                        }
                        case "rewardchoice": {
                            QUEST.setRewardChoice(this.readItemStackArray(in));
                            continue block46;
                        }
                        case "reputationrewards": {
                            in.beginArray();
                            ArrayList<ReputationReward> reputationRewards = new ArrayList<ReputationReward>();
                            while (in.hasNext()) {
                                ReputationReward reward = (ReputationReward)REPUTATION_REWARD_ADAPTER.read(in);
                                if (reward == null) continue;
                                reputationRewards.add(reward);
                            }
                            QUEST.setReputationRewards(reputationRewards);
                            in.endArray();
                            continue block46;
                        }
                        case "commandrewards": {
                            ArrayList<String> commands = new ArrayList<String>();
                            this.readStringArray(commands, in);
                            QUEST.setCommandRewards(commands.toArray(new String[commands.size()]));
                            continue block46;
                        }
                    }
                    QuestLine.getActiveQuestLine().quests.remove(QUEST.getId());
                    return null;
                }
                in.endObject();
                if (!QUEST.getId().isEmpty()) {
                    if (!hasUuid) {
                        nameToQuestMap.put(QUEST.getName(), QUEST);
                    }
                    this.optionalAdd(requirementMapping, requirement);
                    this.optionalAdd(optionMapping, options);
                    this.optionalAdd(prerequisiteMapping, prerequisites);
                    this.optionalAdd(optionLinkMapping, optionLinks);
                    try {
                        if (HardcoreQuesting.getPlayer() != null) {
                            QUEST.addTaskData(QUEST.getQuestData(HardcoreQuesting.getPlayer()));
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    return QUEST;
                }
                QuestLine.getActiveQuestLine().quests.remove(QUEST.getId());
                return null;
            }
        };
        QUEST_SET_ADAPTER = new TypeAdapter<QuestSet>(){
            private final String NAME = "name";
            private final String DESCRIPTION = "description";
            private final String QUESTS = "quests";
            private final String REPUTATION_BAR = "reputationBar";
            private final String REPUTATION_BAR_OLD = "reputation";

            private QuestSet removeQuestsRaw(List<Quest> quests) {
                for (Quest quest : quests) {
                    QuestLine.getActiveQuestLine().quests.remove(quest.getId());
                }
                return null;
            }

            public void write(JsonWriter out, QuestSet value) throws IOException {
                reputationBarList.clear();
                out.beginObject();
                out.name("name").value(value.getName());
                if (!value.getDescription().equalsIgnoreCase("No description")) {
                    out.name("description").value(value.getDescription());
                }
                out.name("quests").beginArray();
                for (Quest quest : value.getQuests().values()) {
                    QUEST_ADAPTER.write(out, (Object)quest);
                }
                out.endArray();
                out.name("reputationBar").beginArray();
                for (ReputationBar reputationBar : value.getReputationBars()) {
                    REPUTATION_BAR_ADAPTER.write(out, (Object)reputationBar);
                }
                out.endArray().endObject();
            }

            public QuestSet read(JsonReader in) throws IOException {
                String name = null;
                String description = "No description";
                requirementMapping.clear();
                optionMapping.clear();
                reputationBarList.clear();
                QuestTaskAdapter.taskReputationListMap.clear();
                ArrayList<Quest> quests = new ArrayList<Quest>();
                in.beginObject();
                while (in.hasNext()) {
                    String next = in.nextName();
                    if (next.equalsIgnoreCase("name")) {
                        name = in.nextString();
                        continue;
                    }
                    if (next.equalsIgnoreCase("description")) {
                        description = in.nextString();
                        continue;
                    }
                    if (next.equalsIgnoreCase("quests")) {
                        in.beginArray();
                        while (in.hasNext()) {
                            Quest quest = (Quest)QUEST_ADAPTER.read(in);
                            if (quest == null) continue;
                            quests.add(quest);
                        }
                        in.endArray();
                        continue;
                    }
                    if (!next.equalsIgnoreCase("reputationBar") && !next.equalsIgnoreCase("reputation")) continue;
                    in.beginArray();
                    while (in.hasNext()) {
                        reputationBarList.add(REPUTATION_BAR_ADAPTER.read(in));
                    }
                    in.endArray();
                }
                in.endObject();
                QuestSet set = null;
                for (QuestSet questSet : Quest.getQuestSets()) {
                    if (!questSet.getName().equals(name)) continue;
                    set = questSet;
                    set.setDescription(description);
                    break;
                }
                if (name != null && description != null && set == null) {
                    set = new QuestSet(name, description);
                    Quest.getQuestSets().add(set);
                    SaveHelper.add(SaveHelper.EditType.SET_CREATE);
                }
                if (set != null) {
                    for (Quest quest : quests) {
                        quest.setQuestSet(set);
                    }
                    for (Map.Entry entry : requirementMapping.entrySet()) {
                        for (String i : (List)entry.getValue()) {
                            ((Quest)entry.getKey()).addRequirement(QuestAdapter.getUuid(i));
                        }
                    }
                    for (Map.Entry entry : optionMapping.entrySet()) {
                        for (String i : (List)entry.getValue()) {
                            ((Quest)entry.getKey()).addOptionLink(QuestAdapter.getUuid(i));
                        }
                    }
                    for (ReputationBar reputationBar : reputationBarList) {
                        for (ReputationBar r : new ArrayList<ReputationBar>(set.getReputationBars())) {
                            if (!r.sameLocation(reputationBar)) continue;
                            set.removeRepBar(r);
                        }
                        set.addRepBar(reputationBar);
                    }
                    return set;
                }
                return this.removeQuestsRaw(quests);
            }
        };
    }
}

