/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.io.adapter;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

public class MinecraftAdapter {
    public static final TypeAdapter<NBTTagCompound> NBT_TAG_COMPOUND = new TypeAdapter<NBTTagCompound>(){

        public void write(JsonWriter out, NBTTagCompound value) throws IOException {
            out.value(value.toString());
        }

        public NBTTagCompound read(JsonReader in) throws IOException {
            try {
                NBTTagCompound nbtBase = JsonToNBT.func_180713_a((String)in.nextString());
                if (nbtBase instanceof NBTTagCompound) {
                    return nbtBase;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new IOException("Failed to read NBT");
        }
    };
    public static final TypeAdapter<ItemStack> ITEM_STACK = new TypeAdapter<ItemStack>(){
        private static final String ID = "id";
        private static final String DAMAGE = "damage";
        private static final String STACK_SIZE = "amount";
        private static final String NBT = "nbt";

        public void write(JsonWriter out, ItemStack stack) throws IOException {
            if (stack == null) {
                out.nullValue();
                return;
            }
            String id = stack.func_77973_b().getRegistryName().toString();
            out.beginObject();
            out.name(ID).value(id);
            if (stack.func_77952_i() != 0) {
                out.name(DAMAGE).value((long)stack.func_77952_i());
            }
            if (stack.field_77994_a != 1) {
                out.name(STACK_SIZE).value((long)stack.field_77994_a);
            }
            if (stack.func_77942_o() && !stack.func_77978_p().func_82582_d()) {
                NBT_TAG_COMPOUND.write(out.name(NBT), (Object)stack.func_77978_p());
            }
            out.endObject();
        }

        public ItemStack read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                return null;
            }
            String id = "";
            int damage = 0;
            int size = 1;
            NBTTagCompound tag = null;
            in.beginObject();
            while (in.hasNext()) {
                String name = in.nextName();
                if (name.equalsIgnoreCase(ID)) {
                    id = in.nextString();
                    continue;
                }
                if (name.equalsIgnoreCase(DAMAGE)) {
                    damage = in.nextInt();
                    continue;
                }
                if (name.equalsIgnoreCase(STACK_SIZE)) {
                    size = in.nextInt();
                    continue;
                }
                if (!name.equalsIgnoreCase(NBT)) continue;
                tag = (NBTTagCompound)NBT_TAG_COMPOUND.read(in);
            }
            in.endObject();
            Item item = Item.func_111206_d((String)id);
            if (item == null) {
                return null;
            }
            ItemStack stack = new ItemStack(item, size, damage);
            stack.func_77982_d(tag);
            return stack;
        }
    };
    public static final TypeAdapter<Fluid> FLUID = new TypeAdapter<Fluid>(){

        public void write(JsonWriter out, Fluid value) throws IOException {
            out.value(value.getName());
        }

        public Fluid read(JsonReader in) throws IOException {
            return FluidRegistry.getFluid((String)in.nextString());
        }
    };
}

