/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.io.adapter;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import hardcorequesting.bag.BagTier;
import hardcorequesting.bag.Group;
import hardcorequesting.bag.GroupTier;
import hardcorequesting.client.interfaces.GuiColor;
import hardcorequesting.io.adapter.MinecraftAdapter;
import java.io.IOException;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;

public class BagAdapter {
    public static final TypeAdapter<Group> GROUP_ADAPTER = new TypeAdapter<Group>(){
        private final String ID = "id";
        private final String ITEMS = "items";
        private final String NAME = "name";
        private final String LIMIT = "limit";

        public void write(JsonWriter out, Group value) throws IOException {
            out.beginObject();
            out.name("id").value(value.getId());
            if (value.hasName()) {
                out.name("name").value(value.getName());
            }
            out.name("limit").value((long)value.getLimit());
            out.name("items").beginArray();
            for (ItemStack stack : value.getItems()) {
                MinecraftAdapter.ITEM_STACK.write(out, (Object)stack);
            }
            out.endArray();
            out.endObject();
        }

        public Group read(JsonReader in) throws IOException {
            in.beginObject();
            String name = null;
            String id = null;
            int limit = 0;
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            while (in.hasNext()) {
                switch (in.nextName().toLowerCase()) {
                    case "id": {
                        id = in.nextString();
                        break;
                    }
                    case "name": {
                        name = in.nextString();
                        break;
                    }
                    case "limit": {
                        limit = in.nextInt();
                        break;
                    }
                    case "items": {
                        in.beginArray();
                        while (in.hasNext()) {
                            ItemStack stack = (ItemStack)MinecraftAdapter.ITEM_STACK.read(in);
                            if (stack == null) continue;
                            items.add(stack);
                        }
                        in.endArray();
                    }
                }
            }
            in.endObject();
            Group group = new Group(id);
            group.setName(name);
            group.setLimit(limit);
            group.getItems().addAll(items);
            if (!Group.getGroups().containsKey(group.getId())) {
                Group.add(group);
            }
            return group;
        }
    };
    public static final TypeAdapter<GroupTier> GROUP_TIER_ADAPTER = new TypeAdapter<GroupTier>(){
        private final String NAME = "name";
        private final String COLOUR = "colour";
        private final String WEIGHTS = "weights";
        private final String GROUPS = "groups";

        public void write(JsonWriter out, GroupTier value) throws IOException {
            out.beginObject();
            out.name("name").value(value.getName());
            out.name("colour").value(value.getColor().name());
            out.name("weights").beginArray();
            for (int i : value.getWeights()) {
                out.value((long)i);
            }
            out.endArray();
            out.name("groups").beginArray();
            Object object = Group.getGroups().values().iterator();
            while (object.hasNext()) {
                Group group = (Group)object.next();
                if (group.getTier() != value) continue;
                GROUP_ADAPTER.write(out, (Object)group);
            }
            out.endArray();
            out.endObject();
        }

        public GroupTier read(JsonReader in) throws IOException {
            in.beginObject();
            String name = "";
            GuiColor colour = GuiColor.GRAY;
            int[] weights = new int[BagTier.values().length];
            ArrayList<Group> groups = new ArrayList<Group>();
            while (in.hasNext()) {
                switch (in.nextName().toLowerCase()) {
                    case "name": {
                        name = in.nextString();
                        break;
                    }
                    case "colour": {
                        colour = GuiColor.valueOf(in.nextString());
                        break;
                    }
                    case "weights": {
                        in.beginArray();
                        for (int i = 0; i < weights.length && in.hasNext(); ++i) {
                            weights[i] = in.nextInt();
                        }
                        in.endArray();
                        break;
                    }
                    case "groups": {
                        in.beginArray();
                        while (in.hasNext()) {
                            Group group = (Group)GROUP_ADAPTER.read(in);
                            if (group == null) continue;
                            groups.add(group);
                        }
                        in.endArray();
                    }
                }
            }
            in.endObject();
            GroupTier tier = new GroupTier(name, colour, weights);
            for (Group group : groups) {
                group.setTier(tier);
            }
            return tier;
        }
    };
}

