/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.event;

import hardcorequesting.quests.Quest;
import hardcorequesting.quests.QuestLine;
import java.io.File;
import net.minecraft.world.WorldServer;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber
public class WorldEventListener {
    @SubscribeEvent
    public static void onLoad(WorldEvent.Load event) {
        if (!event.getWorld().field_72995_K && event.getWorld().field_73011_w.getDimension() == 0) {
            QuestLine.reset();
            WorldServer world = (WorldServer)event.getWorld();
            if (Quest.useDefault) {
                QuestLine.copyDefaults(WorldEventListener.getWorldPath(world));
            }
            QuestLine.loadWorldData(WorldEventListener.getWorldPath(world), world.field_72995_K);
        }
    }

    @SubscribeEvent
    public static void onSave(WorldEvent.Save event) {
        if (!event.getWorld().field_72995_K && event.getWorld().field_73011_w.getDimension() == 0) {
            QuestLine.saveAll();
        }
    }

    @SubscribeEvent
    public static void onCreate(WorldEvent.CreateSpawnPosition event) {
        if (!event.getWorld().field_72995_K && event.getWorld().field_73011_w.getDimension() == 0) {
            WorldServer world = (WorldServer)event.getWorld();
            QuestLine.reset();
            QuestLine.copyDefaults(WorldEventListener.getWorldPath(world));
            QuestLine.loadWorldData(WorldEventListener.getWorldPath(world), world.field_72995_K);
        }
    }

    private static File getWorldPath(WorldServer world) {
        return world.getChunkSaveLocation();
    }
}

