/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.event;

import hardcorequesting.config.ModConfig;
import hardcorequesting.death.DeathStats;
import hardcorequesting.quests.QuestLine;
import hardcorequesting.quests.QuestingData;
import hardcorequesting.util.Translator;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;

@Mod.EventBusSubscriber
public class PlayerTracker {
    public static final String HQ_TAG = "HardcoreQuesting";
    public static final String RECEIVED_BOOK = "questBook";

    public PlayerTracker() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public int getRemainingLives(ICommandSender sender) {
        return QuestingData.getQuestingData((EntityPlayer)sender).getLives();
    }

    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        EntityPlayer player = event.player;
        if (!QuestingData.hasData(player)) {
            DeathStats.resync();
        }
        QuestLine.sendServerSync(player);
        if (QuestingData.isHardcoreActive()) {
            this.sendLoginMessage(player);
        } else if (ModConfig.NO_HARDCORE_MESSAGE) {
            player.func_146105_b((ITextComponent)new TextComponentTranslation("hqm.message.noHardcore", new Object[0]));
        }
        NBTTagCompound tags = player.getEntityData();
        if (tags.func_74764_b(HQ_TAG)) {
            if (tags.func_74775_l(HQ_TAG).func_74767_n(RECEIVED_BOOK)) {
                QuestingData.getQuestingData((EntityPlayer)player).receivedBook = true;
            }
            if (!QuestingData.isQuestActive()) {
                tags.func_82580_o(HQ_TAG);
            }
        }
        QuestingData.spawnBook(player);
    }

    private void sendLoginMessage(EntityPlayer player) {
        player.func_146105_b((ITextComponent)new TextComponentString(Translator.translate("hqm.message.hardcore") + " " + Translator.translate(this.getRemainingLives((ICommandSender)player) != 1, "hqm.message.livesLeft", this.getRemainingLives((ICommandSender)player))));
    }
}

